/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks.importer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mage.cards.decks.DeckCardInfo;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.importer.DeckImporter;
import mage.cards.decks.importer.PlainTextDeckImporter;
import mage.cards.repository.CardInfo;

public class DraftLogImporter
extends PlainTextDeckImporter {
    private static final Pattern SET_PATTERN = Pattern.compile("------ (\\p{Alnum}+) ------$");
    private static final Pattern PICK_PATTERN = Pattern.compile("--> (.+)$");
    private String currentSet = null;

    @Override
    protected void readLine(String line, DeckCardLists deckList, DeckImporter.FixedInfo fixedInfo) {
        Matcher setMatcher = SET_PATTERN.matcher(line);
        if (setMatcher.matches()) {
            this.currentSet = setMatcher.group(1);
            return;
        }
        Matcher pickMatcher = PICK_PATTERN.matcher(line);
        if (pickMatcher.matches()) {
            String name = pickMatcher.group(1);
            CardInfo cardInfo = this.getCardLookup().lookupCardInfo(name, this.currentSet, null);
            if (cardInfo != null) {
                deckList.getCards().add(new DeckCardInfo(cardInfo.getName(), cardInfo.getCardNumber(), cardInfo.getSetCode()));
            } else {
                this.sbMessage.append("couldn't find: \"").append(name).append("\"\n");
            }
        }
    }
}

