/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks.importer;

import mage.cards.decks.DeckCardInfo;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.importer.DeckImporter;
import mage.cards.decks.importer.PlainTextDeckImporter;
import mage.cards.repository.CardInfo;

public class MWSDeckImporter
extends PlainTextDeckImporter {
    @Override
    protected void readLine(String line, DeckCardLists deckList, DeckImporter.FixedInfo fixedInfo) {
        if (line.isEmpty() || line.startsWith("//")) {
            return;
        }
        boolean sideboard = false;
        if (line.startsWith("SB:")) {
            line = line.substring(3).trim();
            sideboard = true;
        }
        int delim = line.indexOf(32);
        String lineNum = line.substring(0, delim).trim();
        String setCode = "";
        if (line.indexOf(91) != -1) {
            int setStart = line.indexOf(91) + 1;
            int setEnd = line.indexOf(93);
            setCode = line.substring(setStart, setEnd).trim();
            delim = setEnd;
        }
        String lineName = line.substring(delim + 1).trim();
        try {
            int num = Integer.parseInt(lineNum);
            CardInfo cardInfo = null;
            cardInfo = setCode.isEmpty() ? this.getCardLookup().lookupCardInfo(lineName, setCode, null) : this.getCardLookup().lookupCardInfo(lineName);
            if (cardInfo == null) {
                this.sbMessage.append("Could not find card: '").append(lineName).append("' at line ").append(this.lineCount).append('\n');
            } else {
                for (int i = 0; i < num; ++i) {
                    if (!sideboard) {
                        deckList.getCards().add(new DeckCardInfo(cardInfo.getName(), cardInfo.getCardNumber(), cardInfo.getSetCode()));
                        continue;
                    }
                    deckList.getSideboard().add(new DeckCardInfo(cardInfo.getName(), cardInfo.getCardNumber(), cardInfo.getSetCode()));
                }
            }
        }
        catch (NumberFormatException nfe) {
            this.sbMessage.append("Invalid number: ").append(lineNum).append(" at line ").append(this.lineCount).append('\n');
        }
    }
}

