/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks.importer;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import mage.cards.decks.DeckCardInfo;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.importer.JsonDeckImporter;
import mage.cards.repository.CardInfo;
import mage.util.JsonUtil;

public class MtgjsonDeckImporter
extends JsonDeckImporter {
    @Override
    protected void readJson(JsonObject json, DeckCardLists deckList) {
        JsonObject data = JsonUtil.getAsObject(json, "data");
        if (data == null) {
            this.sbMessage.append("Could not find data in json").append("'\n");
            return;
        }
        String deckSet = JsonUtil.getAsString(data, "code");
        String name = JsonUtil.getAsString(data, "name");
        if (!name.isEmpty()) {
            deckList.setName(name);
        }
        JsonArray mainBoard = JsonUtil.getAsArray(data, "mainBoard");
        List<DeckCardInfo> mainDeckList = deckList.getCards();
        this.addBoardToList(mainBoard, mainDeckList, deckSet);
        JsonArray sideBoard = JsonUtil.getAsArray(data, "sideBoard");
        List<DeckCardInfo> sideDeckList = deckList.getSideboard();
        this.addBoardToList(sideBoard, sideDeckList, deckSet);
        JsonArray commander = JsonUtil.getAsArray(data, "commander");
        List<DeckCardInfo> commanderDeckList = deckList.getSideboard();
        this.addBoardToList(commander, commanderDeckList, deckSet);
    }

    private void addBoardToList(JsonArray board, List<DeckCardInfo> list, String deckSet) {
        if (board == null || board.isEmpty()) {
            return;
        }
        board.forEach(arrayCard -> {
            JsonObject card = (JsonObject)arrayCard;
            String name = JsonUtil.getAsString(card, "name");
            String setCode = JsonUtil.getAsString(card, "setCode");
            if (setCode.isEmpty()) {
                setCode = deckSet;
            }
            int num = JsonUtil.getAsInt(card, "count");
            CardInfo cardInfo = this.getCardLookup().lookupCardInfo(name, setCode, null);
            if (cardInfo == null) {
                this.sbMessage.append("Could not find card: '").append(name).append("'\n");
            } else {
                for (int i = 0; i < num; ++i) {
                    list.add(new DeckCardInfo(cardInfo.getName(), cardInfo.getCardNumber(), cardInfo.getSetCode()));
                }
            }
        });
    }
}

