/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.repository;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mage.ObjectColor;
import mage.abilities.SpellAbility;
import mage.cards.Card;
import mage.cards.CardGraphicInfo;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.CardWithSpellOption;
import mage.cards.FrameStyle;
import mage.cards.MeldCard;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.SplitCard;
import mage.cards.mock.MockCard;
import mage.cards.mock.MockSplitCard;
import mage.constants.CardType;
import mage.constants.Rarity;
import mage.constants.SpellAbilityType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.util.CardUtil;
import mage.util.SubTypes;
import org.apache.log4j.Logger;

@DatabaseTable(tableName="card")
public class CardInfo {
    private static final int MAX_RULE_LENGTH = 750;
    private static final String SEPARATOR = "@@@";
    public static final String SPLIT_MANA_SEPARATOR_SHORT = "*";
    public static final String SPLIT_MANA_SEPARATOR_FULL = "{*}";
    public static final String SPLIT_MANA_SEPARATOR_RENDER = " / ";
    @DatabaseField(indexName="name_index")
    protected String name;
    @DatabaseField(indexName="setCode_cardNumber_index")
    protected String setCode;
    @DatabaseField(indexName="setCode_cardNumber_index")
    protected String cardNumber;
    @DatabaseField(indexName="cardNumberAsInt_index")
    protected int cardNumberAsInt;
    @DatabaseField(indexName="className_index")
    protected String className;
    @DatabaseField
    protected String power;
    @DatabaseField
    protected String toughness;
    @DatabaseField
    protected String startingLoyalty;
    @DatabaseField
    protected String startingDefense;
    @DatabaseField
    protected int manaValue;
    @DatabaseField(dataType=DataType.ENUM_STRING)
    protected Rarity rarity;
    @DatabaseField
    protected String types;
    @DatabaseField
    protected String subtypes;
    @DatabaseField
    protected String supertypes;
    @DatabaseField
    protected String manaCosts;
    @DatabaseField(dataType=DataType.STRING, width=750)
    protected String rules;
    @DatabaseField
    protected boolean black;
    @DatabaseField
    protected boolean blue;
    @DatabaseField
    protected boolean green;
    @DatabaseField
    protected boolean red;
    @DatabaseField
    protected boolean white;
    @DatabaseField
    protected String frameColor;
    @DatabaseField
    protected String frameStyle;
    @DatabaseField
    protected boolean variousArt;
    @DatabaseField
    protected boolean splitCard;
    @DatabaseField
    protected boolean splitCardFuse;
    @DatabaseField
    protected boolean splitCardAftermath;
    @DatabaseField
    protected boolean splitCardHalf;
    @DatabaseField
    protected boolean flipCard;
    @DatabaseField
    protected boolean doubleFaced;
    @DatabaseField(indexName="nightCard_index")
    protected boolean nightCard;
    @DatabaseField
    protected boolean meldCard;
    @DatabaseField
    protected String flipCardName;
    @DatabaseField
    protected String secondSideName;
    @DatabaseField
    protected boolean cardWithSpellOption;
    @DatabaseField
    protected String spellOptionCardName;
    @DatabaseField
    protected boolean modalDoubleFacedCard;
    @DatabaseField
    protected String modalDoubleFacedSecondSideName;
    @DatabaseField
    protected String meldsToCardName;
    @DatabaseField
    protected boolean isExtraDeckCard;

    public CardInfo() {
    }

    public CardInfo(Card card) {
        SpellAbilityType spellAbilityType;
        List<String> manaCostRight;
        List<String> manaCostLeft;
        this.name = card.getName();
        this.cardNumber = card.getCardNumber();
        this.cardNumberAsInt = CardUtil.parseCardNumberAsInt(card.getCardNumber());
        this.setCode = card.getExpansionSetCode();
        this.className = card.getClass().getCanonicalName();
        this.power = card.getPower().toString();
        this.toughness = card.getToughness().toString();
        this.manaValue = card.getManaValue();
        this.rarity = card.getRarity();
        this.splitCard = card instanceof SplitCard;
        this.splitCardFuse = card.getSpellAbility() != null && card.getSpellAbility().getSpellAbilityType() == SpellAbilityType.SPLIT_FUSED;
        this.splitCardAftermath = card.getSpellAbility() != null && card.getSpellAbility().getSpellAbilityType() == SpellAbilityType.SPLIT_AFTERMATH;
        this.flipCard = card.isFlipCard();
        this.flipCardName = card.getFlipCardName();
        MeldCard meldToCard = card.getMeldsToCard();
        if (meldToCard != null) {
            this.meldsToCardName = meldToCard.getName();
        }
        this.doubleFaced = card.isTransformable() && card.getSecondCardFace() != null;
        this.nightCard = card.isNightCard();
        this.meldCard = card instanceof MeldCard;
        Card secondSide = card.getSecondCardFace();
        if (secondSide != null) {
            this.secondSideName = secondSide.getName();
        }
        if (card instanceof CardWithSpellOption) {
            this.cardWithSpellOption = true;
            this.spellOptionCardName = ((CardWithSpellOption)card).getSpellCard().getName();
        }
        if (card instanceof ModalDoubleFacedCard) {
            this.modalDoubleFacedCard = true;
            this.modalDoubleFacedSecondSideName = ((ModalDoubleFacedCard)card).getRightHalfCard().getName();
        }
        if (card.getFrameStyle() != null) {
            this.frameStyle = card.getFrameStyle().toString();
        }
        this.frameColor = card.getFrameColor(null).toString();
        this.variousArt = card.getUsesVariousArt();
        this.blue = card.getColor(null).isBlue();
        this.black = card.getColor(null).isBlack();
        this.green = card.getColor(null).isGreen();
        this.red = card.getColor(null).isRed();
        this.white = card.getColor(null).isWhite();
        this.setTypes(card.getCardType());
        this.setSubtypes(card.getSubtype().stream().map(SubType::toString).collect(Collectors.toList()));
        this.setSuperTypes(card.getSuperType());
        if (card instanceof SplitCard) {
            manaCostLeft = ((SplitCard)card).getLeftHalfCard().getManaCostSymbols();
            manaCostRight = ((SplitCard)card).getRightHalfCard().getManaCostSymbols();
            this.setManaCosts(CardUtil.concatManaSymbols(SPLIT_MANA_SEPARATOR_FULL, manaCostLeft, manaCostRight));
        } else if (card instanceof ModalDoubleFacedCard) {
            manaCostLeft = ((ModalDoubleFacedCard)card).getLeftHalfCard().getManaCostSymbols();
            manaCostRight = ((ModalDoubleFacedCard)card).getRightHalfCard().getManaCostSymbols();
            this.setManaCosts(CardUtil.concatManaSymbols(SPLIT_MANA_SEPARATOR_FULL, manaCostLeft, manaCostRight));
        } else if (card instanceof CardWithSpellOption) {
            manaCostLeft = ((CardWithSpellOption)card).getSpellCard().getManaCostSymbols();
            manaCostRight = card.getManaCostSymbols();
            this.setManaCosts(CardUtil.concatManaSymbols(SPLIT_MANA_SEPARATOR_FULL, manaCostLeft, manaCostRight));
        } else {
            this.setManaCosts(card.getManaCostSymbols());
        }
        int length = 0;
        ArrayList<String> rulesList = new ArrayList<String>();
        for (String string : card.getRules()) {
            length += string.length();
            rulesList.add(string);
        }
        if (length > 750) {
            length = 0;
            ArrayList<String> shortRules = new ArrayList<String>();
            for (String rule : rulesList) {
                if (length + rule.length() + 3 <= 750) {
                    shortRules.add(rule);
                    length += rule.length() + 3;
                    continue;
                }
                shortRules.add(rule.substring(0, 750 - (length + 3)));
                break;
            }
            Logger.getLogger(CardInfo.class).warn((Object)("Card rule text was cut - cardname: " + card.getName()));
            this.setRules(shortRules);
        } else {
            this.setRules(rulesList);
        }
        SpellAbility spellAbility = card.getSpellAbility();
        if (spellAbility != null && ((spellAbilityType = spellAbility.getSpellAbilityType()) == SpellAbilityType.SPLIT_LEFT || spellAbilityType == SpellAbilityType.SPLIT_RIGHT)) {
            this.className = this.setCode + '.' + this.name;
            this.splitCardHalf = true;
        }
        this.startingLoyalty = CardUtil.convertLoyaltyOrDefense(card.getStartingLoyalty());
        this.startingDefense = CardUtil.convertLoyaltyOrDefense(card.getStartingDefense());
        this.isExtraDeckCard = card.isExtraDeckCard();
    }

    public Card createCard() {
        return CardImpl.createCard(this.className, new CardSetInfo(this.name, this.setCode, this.cardNumber, this.rarity, new CardGraphicInfo(FrameStyle.valueOf(this.frameStyle), this.variousArt)));
    }

    public Card createMockCard() {
        if (this.splitCard) {
            return new MockSplitCard(this);
        }
        return new MockCard(this);
    }

    public boolean usesVariousArt() {
        return this.variousArt;
    }

    public ObjectColor getColor() {
        ObjectColor color = new ObjectColor();
        color.setBlack(this.black);
        color.setBlue(this.blue);
        color.setGreen(this.green);
        color.setRed(this.red);
        color.setWhite(this.white);
        return color;
    }

    public ObjectColor getFrameColor() {
        return new ObjectColor(this.frameColor);
    }

    public FrameStyle getFrameStyle() {
        return FrameStyle.valueOf(this.frameStyle);
    }

    private String joinList(List<String> items) {
        StringBuilder sb = new StringBuilder();
        for (String item : items) {
            sb.append(item.toString()).append(SEPARATOR);
        }
        return sb.toString();
    }

    public static List<String> parseList(String list, ManaCostSide manaCostSide) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>();
        boolean leftSide = true;
        for (String s : list.split(SEPARATOR)) {
            if (s.equals(SPLIT_MANA_SEPARATOR_FULL)) {
                leftSide = false;
                continue;
            }
            if (!manaCostSide.equals((Object)ManaCostSide.ALL) && (!manaCostSide.equals((Object)ManaCostSide.LEFT) || !leftSide) && (!manaCostSide.equals((Object)ManaCostSide.RIGHT) || leftSide)) continue;
            res.add(s);
        }
        return res;
    }

    public final List<CardType> getTypes() {
        ArrayList<CardType> list = new ArrayList<CardType>();
        for (String type : this.types.split(SEPARATOR)) {
            try {
                list.add(CardType.valueOf(type));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return list;
    }

    public final void setTypes(List<CardType> types) {
        StringBuilder sb = new StringBuilder();
        for (CardType item : types) {
            sb.append(item.name()).append(SEPARATOR);
        }
        this.types = sb.toString();
    }

    public int getManaValue() {
        return this.manaValue;
    }

    public final List<String> getManaCosts(ManaCostSide manaCostSide) {
        return CardInfo.parseList(this.manaCosts, manaCostSide);
    }

    public final void setManaCosts(List<String> manaCosts) {
        this.manaCosts = this.joinList(manaCosts);
    }

    public String getName() {
        return this.name;
    }

    public String getPower() {
        return this.power;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public final List<String> getRules() {
        return CardInfo.parseList(this.rules, ManaCostSide.ALL);
    }

    public final void setRules(List<String> rules) {
        this.rules = this.joinList(rules);
    }

    public final SubTypes getSubTypes() {
        SubTypes sl = new SubTypes(new SubType[0]);
        if (this.subtypes.trim().isEmpty()) {
            return sl;
        }
        for (String s : this.subtypes.split(SEPARATOR)) {
            sl.add(SubType.fromString(s));
        }
        return sl;
    }

    public final void setSubtypes(List<String> subtypes) {
        this.subtypes = this.joinList(subtypes);
    }

    public final List<SuperType> getSupertypes() {
        ArrayList<SuperType> list = new ArrayList<SuperType>();
        for (String type : this.supertypes.split(SEPARATOR)) {
            try {
                list.add(SuperType.valueOf(type));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return list;
    }

    public final void setSuperTypes(List<SuperType> superTypes) {
        StringBuilder sb = new StringBuilder();
        for (SuperType item : superTypes) {
            sb.append(item.name()).append(SEPARATOR);
        }
        this.supertypes = sb.toString();
    }

    public String getToughness() {
        return this.toughness;
    }

    public String getStartingLoyalty() {
        return this.startingLoyalty;
    }

    public String getStartingDefense() {
        return this.startingDefense;
    }

    public String getSetCode() {
        return this.setCode;
    }

    public String getClassName() {
        return this.className;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public int getCardNumberAsInt() {
        return this.cardNumberAsInt;
    }

    public boolean isSplitCard() {
        return this.splitCard;
    }

    public boolean isSplitFuseCard() {
        return this.splitCardFuse;
    }

    public boolean isSplitAftermathCard() {
        return this.splitCardAftermath;
    }

    public boolean isSplitCardHalf() {
        return this.splitCardHalf;
    }

    public boolean isFlipCard() {
        return this.flipCard;
    }

    public String getFlipCardName() {
        return this.flipCardName;
    }

    public String getMeldsToCardName() {
        return this.meldsToCardName;
    }

    public boolean isDoubleFaced() {
        return this.doubleFaced;
    }

    public boolean isNightCard() {
        return this.nightCard;
    }

    public boolean isMeldCard() {
        return this.meldCard;
    }

    public String getSecondSideName() {
        return this.secondSideName;
    }

    public boolean isCardWithSpellOption() {
        return this.cardWithSpellOption;
    }

    public String getSpellOptionCardName() {
        return this.spellOptionCardName;
    }

    public boolean isModalDoubleFacedCard() {
        return this.modalDoubleFacedCard;
    }

    public String getModalDoubleFacedSecondSideName() {
        return this.modalDoubleFacedSecondSideName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof CardInfo)) {
            return false;
        }
        CardInfo other = (CardInfo)o;
        return this.name.equals(other.name) && this.setCode.equals(other.setCode) && this.cardNumber.equals(other.cardNumber);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getName(), this.getSetCode(), this.getCardNumber());
    }

    public boolean isExtraDeckCard() {
        return this.isExtraDeckCard;
    }

    public static enum ManaCostSide {
        LEFT,
        RIGHT,
        ALL;

    }
}

