/*
 * Decompiled with CFR 0.152.
 */
package mage.choices;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.choices.ChoiceImpl;
import mage.constants.SubType;
import mage.game.Game;
import mage.players.Player;

public class ChoiceCreatureType
extends ChoiceImpl {
    private static final String DEFAULT_MESSAGE = "Choose a creature type";

    public ChoiceCreatureType(Game game, Ability source) {
        this(game, source, true, DEFAULT_MESSAGE);
    }

    public ChoiceCreatureType(Game game, Ability source, boolean required, String chooseMessage) {
        super(required);
        MageObject sourceObject;
        this.setMessage(chooseMessage);
        MageObject mageObject = sourceObject = source == null ? null : game.getObject(source);
        if (sourceObject != null) {
            this.setSubMessage(sourceObject.getLogName());
        }
        this.setSearchEnabled(true);
        SubType.getCreatureTypes().stream().map(SubType::toString).forEach(value -> this.withItem((String)value, (String)value, null, null, null));
    }

    protected ChoiceCreatureType(ChoiceCreatureType choice) {
        super(choice);
    }

    @Override
    public ChoiceCreatureType copy() {
        return new ChoiceCreatureType(this);
    }

    @Override
    public void onChooseStart(Game game, UUID choosingPlayerId) {
        HashSet myTypes = new HashSet();
        HashSet opponentTypes = new HashSet();
        game.getState().getPlayersInRange(choosingPlayerId, game).forEach(playerId -> {
            Set list;
            Player player = game.getPlayer((UUID)playerId);
            if (player == null) {
                return;
            }
            Set set = list = playerId.equals(choosingPlayerId) ? myTypes : opponentTypes;
            if (playerId.equals(choosingPlayerId)) {
                player.getHand().getCards(game).forEach(card -> list.addAll(card.getSubtype(game).stream().map(SubType::toString).collect(Collectors.toList())));
            }
            game.getBattlefield().getAllActivePermanents((UUID)playerId).forEach(permanent -> list.addAll(permanent.getSubtype(game).stream().map(SubType::toString).collect(Collectors.toList())));
            player.getGraveyard().getCards(game).forEach(card -> list.addAll(card.getSubtype(game).stream().map(SubType::toString).collect(Collectors.toList())));
            game.getExile().getCardsOwned(game, (UUID)playerId).forEach(card -> list.addAll(card.getSubtype(game).stream().map(SubType::toString).collect(Collectors.toList())));
        });
        game.getStack().forEach(stackObject -> {
            if (stackObject.isControlledBy(choosingPlayerId)) {
                myTypes.addAll(stackObject.getSubtype(game).stream().map(SubType::toString).collect(Collectors.toList()));
            } else {
                opponentTypes.addAll(stackObject.getSubtype(game).stream().map(SubType::toString).collect(Collectors.toList()));
            }
        });
        this.keyChoices.forEach((key, value) -> {
            String additionalInfo = "";
            Integer orderPriority = 0;
            if (myTypes.contains(key)) {
                additionalInfo = additionalInfo + "me";
                orderPriority = orderPriority - 100;
            }
            if (opponentTypes.contains(key)) {
                if (!additionalInfo.isEmpty()) {
                    additionalInfo = additionalInfo + ", ";
                }
                additionalInfo = additionalInfo + "opponent";
                orderPriority = orderPriority - 10;
            }
            this.keyChoices.put(key, key + (additionalInfo.isEmpty() ? "" : " (" + additionalInfo + ")"));
            this.sortData.put(key, orderPriority);
        });
    }
}

