/*
 * Decompiled with CFR 0.152.
 */
package mage.choices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.choices.VoteHandlerAI;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.VoteEvent;
import mage.game.events.VotedEvent;
import mage.players.Player;
import mage.util.CardUtil;

public abstract class VoteHandler<T> {
    protected final Map<UUID, List<T>> playerMap = new HashMap<UUID, List<T>>();
    protected VoteHandlerAI<T> aiVoteHint = null;
    protected boolean secret = false;

    public void doVotes(Ability source, Game game) {
        this.doVotes(source, game, null);
    }

    public void doVotes(Ability source, Game game, VoteHandlerAI<T> aiVoteHint) {
        this.aiVoteHint = aiVoteHint;
        this.playerMap.clear();
        int stepCurrent = 0;
        int stepTotal = game.getState().getPlayersInRange(source.getControllerId(), game).size();
        ArrayList<String> messages = new ArrayList<String>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            ++stepCurrent;
            VoteEvent event = new VoteEvent(playerId, source);
            game.replaceEvent(event);
            Player player = game.getPlayer(event.getTargetId());
            Player decidingPlayer = game.getPlayer(event.getPlayerId());
            if (player == null || decidingPlayer == null) continue;
            int voteCount = event.getExtraVotes() + event.getOptionalExtraVotes() + 1;
            for (int i = 0; i < voteCount; ++i) {
                if (i > event.getExtraVotes() && !player.chooseUse(Outcome.Benefit, "Use an extra vote?", source, game)) continue;
                String stepName = i > 0 ? "extra step" : "step";
                String voteInfo = String.format("Vote, %s %d of %d", stepName, stepCurrent, stepTotal);
                T vote2 = decidingPlayer.isComputer() && this.aiVoteHint != null ? this.aiVoteHint.makeChoice(this, player, decidingPlayer, source, game) : this.playerChoose(voteInfo, player, decidingPlayer, source, game);
                if (vote2 == null) continue;
                String message = voteInfo + ": " + player.getName() + " voted for " + this.voteName(vote2);
                if (!Objects.equals(player, decidingPlayer)) {
                    message = message + " (chosen by " + decidingPlayer.getName() + ')';
                }
                if (this.secret) {
                    messages.add(message);
                } else {
                    game.informPlayers(message);
                }
                this.playerMap.computeIfAbsent(playerId, x -> new ArrayList()).add(vote2);
            }
        }
        if (this.secret) {
            for (String message : messages) {
                game.informPlayers(message);
            }
        }
        LinkedHashMap totalVotes = new LinkedHashMap();
        this.getPossibleVotes(source, game).forEach(vote -> totalVotes.putIfAbsent(vote, 0));
        this.playerMap.entrySet().stream().flatMap(votesList -> ((List)votesList.getValue()).stream()).forEach(vote -> totalVotes.compute(vote, CardUtil::setOrIncrementValue));
        Set<T> winners = this.getMostVoted();
        String totalVotesStr = totalVotes.entrySet().stream().map(entry -> (winners.contains(entry.getKey()) ? " -win- " : " -lose- ") + this.voteName(entry.getKey()) + ": " + entry.getValue()).sorted().collect(Collectors.joining("<br>"));
        game.informPlayers("Vote results:<br>" + totalVotesStr);
        game.fireEvent(new VotedEvent(source, this));
    }

    protected abstract Set<T> getPossibleVotes(Ability var1, Game var2);

    protected abstract T playerChoose(String var1, Player var2, Player var3, Ability var4, Game var5);

    protected abstract String voteName(T var1);

    public List<T> getVotes(UUID playerId) {
        return this.playerMap.computeIfAbsent(playerId, x -> new ArrayList());
    }

    public int getVoteCount(T vote) {
        return this.playerMap.values().stream().flatMap(Collection::stream).map(vote::equals).mapToInt(x -> x != false ? 1 : 0).sum();
    }

    public List<UUID> getVotedFor(T vote) {
        return this.playerMap.entrySet().stream().filter(entry -> entry.getValue() != null && ((List)entry.getValue()).contains(vote)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public Set<T> getMostVoted() {
        HashMap map = new HashMap();
        this.playerMap.values().stream().flatMap(Collection::stream).forEach(t -> map.compute(t, CardUtil::setOrIncrementValue));
        int max = map.values().stream().mapToInt(x -> x).max().orElse(0);
        return map.entrySet().stream().filter(e -> (Integer)e.getValue() >= max).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<UUID> getDidntVote(UUID playerId) {
        if (this.playerMap.computeIfAbsent(playerId, x -> new ArrayList()).isEmpty()) {
            return this.playerMap.keySet();
        }
        return this.playerMap.entrySet().stream().filter(e -> e.getValue() != null && !((List)e.getValue()).isEmpty()).filter(e -> !((List)e.getValue()).stream().allMatch(this.playerMap.get(playerId)::contains)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

