/*
 * Decompiled with CFR 0.152.
 */
package mage.constants;

public enum Outcome {
    Damage(false),
    DestroyPermanent(false),
    BoostCreature(true),
    UnboostCreature(false),
    AddAbility(true),
    LoseAbility(false),
    GainLife(true),
    LoseLife(false),
    ExtraTurn(true),
    BecomeCreature(true),
    PutCreatureInPlay(true, true),
    PutCardInPlay(true, true),
    PutLandInPlay(true, true),
    GainControl(false),
    DrawCard(true),
    Discard(false),
    Sacrifice(false),
    PlayForFree(true, true),
    ReturnToHand(false),
    Exile(false),
    Protect(true),
    PutManaInPool(true),
    Regenerate(true),
    PreventDamage(true),
    PreventCast(false),
    RedirectDamage(true),
    Tap(false),
    Transform(true),
    Untap(true),
    Win(true),
    Copy(true, true),
    Benefit(true),
    Detriment(false),
    Neutral(true),
    Removal(false),
    AIDontUseIt(false),
    Vote(true);

    private final boolean good;
    private boolean anyTargetHasSameValue;

    private Outcome(boolean good) {
        this.good = good;
    }

    private Outcome(boolean good, boolean anyTargetHasSameValue) {
        this.good = good;
        this.anyTargetHasSameValue = anyTargetHasSameValue;
    }

    public boolean isGood() {
        return this.good;
    }

    public boolean anyTargetHasSameValue() {
        return this.anyTargetHasSameValue;
    }

    public static Outcome inverse(Outcome outcome) {
        if (outcome.isGood()) {
            return Detriment;
        }
        return Benefit;
    }
}

