/*
 * Decompiled with CFR 0.152.
 */
package mage.constants;

import java.util.function.Supplier;
import mage.abilities.Ability;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.CursedRoleToken;
import mage.game.permanent.token.MonsterRoleToken;
import mage.game.permanent.token.RoyalRoleToken;
import mage.game.permanent.token.SorcererRoleToken;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.VirtuousRoleToken;
import mage.game.permanent.token.WickedRoleToken;
import mage.game.permanent.token.YoungHeroRoleToken;

public enum RoleType {
    CURSED("Cursed", CursedRoleToken::new),
    MONSTER("Monster", MonsterRoleToken::new),
    ROYAL("Royal", RoyalRoleToken::new),
    SORCERER("Sorcerer", SorcererRoleToken::new),
    VIRTUOUS("Virtuous", VirtuousRoleToken::new),
    WICKED("Wicked", WickedRoleToken::new),
    YOUNG_HERO("Young Hero", YoungHeroRoleToken::new);

    private final String name;
    private final Supplier<Token> supplier;

    private RoleType(String name, Supplier<Token> supplier) {
        this.name = name;
        this.supplier = supplier;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public Token createToken(Permanent permanent, Game game, Ability source) {
        Token token = this.supplier.get();
        token.putOntoBattlefield(1, game, source, source.getControllerId(), false, false, null, permanent.getId());
        return token;
    }
}

