/*
 * Decompiled with CFR 0.152.
 */
package mage.designations;

import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.BecomesMonarchTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

class MonarchDealsCombatDamageToAPlayerTriggeredAbility
extends TriggeredAbilityImpl {
    public MonarchDealsCombatDamageToAPlayerTriggeredAbility() {
        super(Zone.ALL, new BecomesMonarchTargetEffect(), false);
    }

    protected MonarchDealsCombatDamageToAPlayerTriggeredAbility(MonarchDealsCombatDamageToAPlayerTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        MageObject damagingObject;
        if (((DamagedPlayerEvent)event).isCombatDamage() && (damagingObject = game.getObject(event.getSourceId())) instanceof Permanent && damagingObject.isCreature(game) && event.getTargetId().equals(game.getMonarchId())) {
            this.setControllerId(event.getPlayerId());
            ((Effect)this.getEffects().get(0)).setTargetPointer(new FixedTarget(((Permanent)damagingObject).getControllerId()));
            return true;
        }
        return false;
    }

    @Override
    public MonarchDealsCombatDamageToAPlayerTriggeredAbility copy() {
        return new MonarchDealsCombatDamageToAPlayerTriggeredAbility(this);
    }

    @Override
    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return true;
    }

    @Override
    public String getRule() {
        return "Whenever a creature deals combat damage to the monarch, its controller becomes the monarch.";
    }
}

