/*
 * Decompiled with CFR 0.152.
 */
package mage.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.FilterObject;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;

public class FilterCard
extends FilterObject<Card> {
    private static final long serialVersionUID = 1L;
    protected final List<ObjectSourcePlayerPredicate<Card>> extraPredicates = new ArrayList<ObjectSourcePlayerPredicate<Card>>();

    public FilterCard() {
        super("card");
    }

    public FilterCard(String name) {
        this(null, name);
    }

    public FilterCard(SubType subType) {
        this(subType, (Object)((Object)subType) + " card");
    }

    public FilterCard(SubType subType, String name) {
        super(name);
        if (subType != null) {
            this.add(subType.getPredicate());
        }
    }

    protected FilterCard(FilterCard filter) {
        super(filter);
        this.extraPredicates.addAll(filter.extraPredicates);
    }

    @Override
    public boolean match(Card card, Game game) {
        if (card == null) {
            return false;
        }
        return super.match(card, game);
    }

    public boolean match(Card card, UUID playerId, Ability source, Game game) {
        if (!this.match(card, game)) {
            return false;
        }
        ObjectSourcePlayer<Card> osp = new ObjectSourcePlayer<Card>(card, playerId, source);
        return this.extraPredicates.stream().allMatch(p -> p.apply(osp, game));
    }

    public final void add(ObjectSourcePlayerPredicate predicate) {
        if (this.isLockedFilter()) {
            throw new UnsupportedOperationException("You may not modify a locked filter");
        }
        FilterCard.checkPredicateIsSuitableForCardFilter(predicate);
        Predicates.makeSurePredicateCompatibleWithFilter(predicate, Card.class);
        this.extraPredicates.add(predicate);
    }

    public boolean hasPredicates() {
        return !this.predicates.isEmpty() || !this.extraPredicates.isEmpty();
    }

    @Override
    public FilterCard copy() {
        return new FilterCard(this);
    }

    @Override
    public List<Predicate> getExtraPredicates() {
        return new ArrayList<Predicate>(this.extraPredicates);
    }

    public static void checkPredicateIsSuitableForCardFilter(Predicate predicate) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        Predicates.collectAllComponents(predicate, list);
        if (list.stream().anyMatch(TargetController.ControllerPredicate.class::isInstance)) {
            throw new IllegalArgumentException("Wrong code usage: card filter doesn't support controller predicate");
        }
    }

    public FilterCard withMessage(String message) {
        this.setMessage(message);
        return this;
    }
}

