/*
 * Decompiled with CFR 0.152.
 */
package mage.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.filter.FilterObject;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

public class FilterStackObject
extends FilterObject<StackObject> {
    protected final List<ObjectSourcePlayerPredicate<StackObject>> extraPredicates = new ArrayList<ObjectSourcePlayerPredicate<StackObject>>();

    public FilterStackObject() {
        this("spell or ability");
    }

    public FilterStackObject(String name) {
        super(name);
    }

    protected FilterStackObject(FilterStackObject filter) {
        super(filter);
        this.extraPredicates.addAll(filter.extraPredicates);
    }

    public boolean match(StackObject stackObject, UUID playerId, Ability source, Game game) {
        if (!this.match(stackObject, game)) {
            return false;
        }
        ObjectSourcePlayer<StackObject> osp = new ObjectSourcePlayer<StackObject>(stackObject, playerId, source);
        return this.extraPredicates.stream().allMatch(p -> p.apply(osp, game));
    }

    public final void add(ObjectSourcePlayerPredicate predicate) {
        if (this.isLockedFilter()) {
            throw new UnsupportedOperationException("You may not modify a locked filter");
        }
        Predicates.makeSurePredicateCompatibleWithFilter(predicate, StackObject.class, Spell.class, Card.class);
        this.extraPredicates.add(predicate);
    }

    @Override
    public FilterStackObject copy() {
        return new FilterStackObject(this);
    }

    @Override
    public List<Predicate> getExtraPredicates() {
        return new ArrayList<Predicate>(this.extraPredicates);
    }
}

