/*
 * Decompiled with CFR 0.152.
 */
package mage.filter.common;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.filter.FilterImpl;
import mage.filter.FilterInPlay;
import mage.filter.FilterPermanent;
import mage.filter.FilterSpell;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

public class FilterSpellOrPermanent
extends FilterImpl<MageObject>
implements FilterInPlay<MageObject> {
    protected FilterPermanent permanentFilter;
    protected FilterSpell spellFilter;

    public FilterSpellOrPermanent() {
        this("spell or permanent");
    }

    public FilterSpellOrPermanent(String name) {
        super(name);
        this.permanentFilter = new FilterPermanent();
        this.spellFilter = new FilterSpell();
    }

    protected FilterSpellOrPermanent(FilterSpellOrPermanent filter) {
        super(filter);
        this.permanentFilter = filter.permanentFilter.copy();
        this.spellFilter = filter.spellFilter.copy();
    }

    @Override
    public boolean checkObjectClass(Object object) {
        return object instanceof MageObject;
    }

    @Override
    public boolean match(MageObject o, Game game) {
        if (o instanceof Spell) {
            return this.spellFilter.match((Spell)o, game);
        }
        if (o instanceof Permanent) {
            return this.permanentFilter.match((Permanent)o, game);
        }
        return false;
    }

    @Override
    public boolean match(MageObject o, UUID playerId, Ability source, Game game) {
        if (o instanceof Spell) {
            return this.spellFilter.match((Spell)o, playerId, source, game);
        }
        if (o instanceof Permanent) {
            return this.permanentFilter.match((Permanent)o, playerId, source, game);
        }
        return false;
    }

    @Override
    public void setLockedFilter(boolean lockedFilter) {
        super.setLockedFilter(lockedFilter);
        this.spellFilter.setLockedFilter(lockedFilter);
        this.permanentFilter.setLockedFilter(lockedFilter);
    }

    public FilterPermanent getPermanentFilter() {
        return this.permanentFilter;
    }

    public FilterSpell getSpellFilter() {
        return this.spellFilter;
    }

    public void setPermanentFilter(FilterPermanent permanentFilter) {
        this.permanentFilter = permanentFilter;
    }

    public void setSpellFilter(FilterSpell spellFilter) {
        this.spellFilter = spellFilter;
    }

    @Override
    public FilterSpellOrPermanent copy() {
        return new FilterSpellOrPermanent(this);
    }
}

