/*
 * Decompiled with CFR 0.152.
 */
package mage.filter.predicate.card;

import java.util.UUID;
import mage.cards.Card;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class AuraCardCanAttachToPermanentId
implements Predicate<Card> {
    private final UUID toBeCheckedPermanentId;

    public AuraCardCanAttachToPermanentId(UUID toBeCheckedPermanentId) {
        this.toBeCheckedPermanentId = toBeCheckedPermanentId;
    }

    @Override
    public boolean apply(Card input, Game game) {
        Permanent permanent = game.getPermanent(this.toBeCheckedPermanentId);
        if (permanent == null || input == null || !input.isEnchantment(game)) {
            return false;
        }
        return input.getSpellAbility().getTargets().stream().anyMatch(target -> target.getFilter().match(permanent, game));
    }

    public String toString() {
        return "AuraCardCanAttachToPermanentId(" + this.toBeCheckedPermanentId + ')';
    }
}

