/*
 * Decompiled with CFR 0.152.
 */
package mage.filter.predicate.other;

import java.util.UUID;
import mage.MageItem;
import mage.abilities.Mode;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.target.Target;

public class AnotherTargetPredicate
implements ObjectSourcePlayerPredicate<MageItem> {
    private final int targetTag;
    private final boolean crossModalCheck;

    public AnotherTargetPredicate(int targetTag) {
        this(targetTag, false);
    }

    public AnotherTargetPredicate(int targetTag, boolean crossModalCheck) {
        this.targetTag = targetTag;
        this.crossModalCheck = crossModalCheck;
    }

    @Override
    public boolean apply(ObjectSourcePlayer<MageItem> input, Game game) {
        block5: {
            StackObject source = game.getStack().getStackObject(input.getSourceId());
            if (source == null || source.getStackAbility().getTargets() == null) break block5;
            if (this.crossModalCheck) {
                for (UUID modeId : source.getStackAbility().getModes().getSelectedModes()) {
                    Mode mode = source.getStackAbility().getModes().get(modeId);
                    for (Target target : mode.getTargets()) {
                        if (target.getTargetTag() <= 0 || target.getTargetTag() == this.targetTag || !target.getTargets().contains(input.getObject().getId())) continue;
                        return false;
                    }
                }
            } else {
                for (Target target : source.getStackAbility().getTargets()) {
                    if (target.getTargetTag() <= 0 || target.getTargetTag() == this.targetTag || !target.getTargets().contains(input.getObject().getId())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public String toString() {
        return "Another target";
    }
}

