/*
 * Decompiled with CFR 0.152.
 */
package mage.filter.predicate.other;

import java.util.UUID;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.players.Player;

public enum PlayerWithTheMostLifePredicate implements ObjectSourcePlayerPredicate<Player>
{
    instance;


    @Override
    public boolean apply(ObjectSourcePlayer<Player> input, Game game) {
        Player inputPlayer = input.getObject();
        if (inputPlayer == null) {
            return false;
        }
        int mostLife = Integer.MIN_VALUE;
        for (UUID playerId : game.getState().getPlayersInRange(input.getPlayerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || player.getLife() <= mostLife) continue;
            mostLife = player.getLife();
        }
        return inputPlayer.getLife() == mostLife;
    }
}

