/*
 * Decompiled with CFR 0.152.
 */
package mage.filter.predicate.permanent;

import java.util.Objects;
import mage.constants.SubType;
import mage.counters.Counter;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

public enum ModifiedPredicate implements Predicate<Permanent>
{
    instance;


    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean apply(Permanent input, Game game) {
        if (input.getCounters(game).values().stream().mapToInt(Counter::getCount).anyMatch(x -> x > 0)) return true;
        if (!input.getAttachments().stream().map(game::getPermanent).filter(Objects::nonNull).anyMatch(permanent -> permanent.hasSubtype(SubType.EQUIPMENT, game) || permanent.hasSubtype(SubType.AURA, game) && permanent.isControlledBy(input.getControllerId()))) return false;
        return true;
    }

    public String toString() {
        return "modified";
    }
}

