/*
 * Decompiled with CFR 0.152.
 */
package mage.game;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import mage.abilities.Abilities;
import mage.abilities.AbilitiesImpl;
import mage.abilities.Ability;
import mage.counters.Counter;
import mage.counters.Counters;
import mage.util.Copyable;

public class CardState
implements Serializable,
Copyable<CardState> {
    protected boolean faceDown;
    protected Map<String, String> info = new LinkedHashMap<String, String>();
    protected Counters counters;
    protected Abilities<Ability> abilities;
    protected boolean lostAllAbilities;
    protected boolean melded;
    private static final Map<String, String> emptyInfo = new HashMap<String, String>();
    private static final Abilities<Ability> emptyAbilities = new AbilitiesImpl<Ability>();

    public CardState() {
        this.counters = new Counters(new Counter[0]);
    }

    protected CardState(CardState state) {
        this.faceDown = state.faceDown;
        this.info.putAll(state.info);
        this.counters = state.counters.copy();
        if (state.abilities != null) {
            this.abilities = new AbilitiesImpl<Ability>();
            for (Ability ability : state.abilities) {
                this.abilities.add(ability.copy());
            }
        }
        this.lostAllAbilities = state.lostAllAbilities;
        this.melded = state.melded;
    }

    @Override
    public CardState copy() {
        return new CardState(this);
    }

    public void setFaceDown(boolean value) {
        this.faceDown = value;
    }

    public boolean isFaceDown() {
        return this.faceDown;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public void addInfo(String key, String value) {
        if (this.info == null) {
            this.info = new HashMap<String, String>();
        }
        if (value == null || value.isEmpty()) {
            this.info.remove(key);
        } else {
            this.info.put(key, value);
        }
    }

    public Map<String, String> getInfo() {
        if (this.info == null) {
            return emptyInfo;
        }
        return this.info;
    }

    public Abilities<Ability> getAbilities() {
        if (this.abilities == null) {
            return emptyAbilities;
        }
        return this.abilities;
    }

    public void addAbility(Ability ability) {
        if (this.abilities == null) {
            this.abilities = new AbilitiesImpl<Ability>();
        }
        this.abilities.add(ability);
        this.abilities.addAll(ability.getSubAbilities());
    }

    public void clearAbilities() {
        if (this.abilities != null) {
            this.abilities = null;
        }
        this.setLostAllAbilities(false);
    }

    public void clear() {
        this.counters.clear();
        this.info.clear();
        this.clearAbilities();
        this.lostAllAbilities = false;
    }

    public boolean hasLostAllAbilities() {
        return this.lostAllAbilities;
    }

    public void setLostAllAbilities(boolean lostAllAbilities) {
        this.lostAllAbilities = lostAllAbilities;
    }

    public boolean isMelded() {
        return this.melded;
    }

    public void setMelded(boolean melded) {
        this.melded = melded;
    }

    public String toString() {
        ArrayList<String> info = new ArrayList<String>();
        if (this.faceDown) {
            info.add("face down");
        }
        if (this.counters != null && !this.counters.isEmpty()) {
            info.add("counters: " + this.counters.values().stream().mapToInt(Counter::getCount).sum());
        }
        if (this.abilities != null && !this.abilities.isEmpty()) {
            info.add("abilities: " + this.abilities.size());
        }
        if (this.lostAllAbilities) {
            info.add("lost all");
        }
        if (this.melded) {
            info.add("melded");
        }
        if (info.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)"; ", info);
    }
}

