/*
 * Decompiled with CFR 0.152.
 */
package mage.game;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ContinuousEffects;
import mage.abilities.effects.PreventionEffectData;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.MeldCard;
import mage.cards.decks.Deck;
import mage.choices.Choice;
import mage.constants.CommanderCardType;
import mage.constants.Duration;
import mage.constants.MultiplayerAttackOption;
import mage.constants.PhaseStep;
import mage.constants.PlayerAction;
import mage.constants.RangeOfInfluence;
import mage.constants.TurnPhase;
import mage.constants.Zone;
import mage.counters.Counters;
import mage.game.CardState;
import mage.game.Exile;
import mage.game.GameOptions;
import mage.game.GameState;
import mage.game.GameStates;
import mage.game.PutToBattlefieldInfo;
import mage.game.combat.Combat;
import mage.game.command.CommandObject;
import mage.game.command.Commander;
import mage.game.command.Dungeon;
import mage.game.command.Emblem;
import mage.game.command.Plane;
import mage.game.events.GameEvent;
import mage.game.events.Listener;
import mage.game.events.PlayerQueryEvent;
import mage.game.events.TableEvent;
import mage.game.match.MatchType;
import mage.game.mulligan.Mulligan;
import mage.game.permanent.Battlefield;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.SpellStack;
import mage.game.stack.StackObject;
import mage.game.turn.Phase;
import mage.game.turn.Step;
import mage.game.turn.Turn;
import mage.players.Player;
import mage.players.PlayerList;
import mage.players.Players;
import mage.util.Copyable;
import mage.util.MessageToClient;
import mage.util.MultiAmountMessage;
import mage.util.functions.CopyApplier;

public interface Game
extends MageItem,
Serializable,
Copyable<Game> {
    public Integer getGameIndex();

    public MatchType getGameType();

    public int getNumPlayers();

    public int getStartingLife();

    public RangeOfInfluence getRangeOfInfluence();

    public MultiplayerAttackOption getAttackOption();

    public void loadCards(Set<Card> var1, UUID var2);

    public Collection<Card> getCards();

    public MeldCard getMeldCard(UUID var1);

    public void addMeldCard(UUID var1, MeldCard var2);

    public Object getCustomData();

    public void setCustomData(Object var1);

    public GameOptions getOptions();

    public MageObject getObject(UUID var1);

    public MageObject getObject(Ability var1);

    public MageObject getBaseObject(UUID var1);

    public MageObject getEmblem(UUID var1);

    public Dungeon getDungeon(UUID var1);

    public Dungeon getPlayerDungeon(UUID var1);

    public UUID getControllerId(UUID var1);

    public UUID getOwnerId(UUID var1);

    public UUID getOwnerId(MageObject var1);

    public Spell getSpell(UUID var1);

    public Spell getSpellOrLKIStack(UUID var1);

    public Permanent getPermanent(UUID var1);

    public Permanent getPermanentOrLKIBattlefield(UUID var1);

    public Permanent getPermanentOrLKIBattlefield(MageObjectReference var1);

    public Permanent getPermanentEntering(UUID var1);

    public Map<UUID, Permanent> getPermanentsEntering();

    public Map<Zone, Map<UUID, MageObject>> getLKI();

    public Map<MageObjectReference, Map<String, Object>> getPermanentCostsTags();

    public void storePermanentCostsTags(MageObjectReference var1, Ability var2);

    public Card getCard(UUID var1);

    public Optional<Ability> getAbility(UUID var1, UUID var2);

    public void setZone(UUID var1, Zone var2);

    public void addPlayer(Player var1, Deck var2);

    public Player getPlayer(UUID var1);

    public Player getPlayerOrPlaneswalkerController(UUID var1);

    public Players getPlayers();

    public PlayerList getPlayerList();

    default public Set<UUID> getOpponents(UUID playerId) {
        return this.getOpponents(playerId, false);
    }

    default public Set<UUID> getOpponents(UUID playerId, boolean excludeLeavedPlayers) {
        Player player = this.getPlayer(playerId);
        if (player == null) {
            return new LinkedHashSet<UUID>();
        }
        return this.getPlayerList().stream().filter(opponentId -> !opponentId.equals(playerId)).filter(player::hasPlayerInRange).filter(opponentId -> !excludeLeavedPlayers || this.getPlayer((UUID)opponentId).isInGame()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    default public boolean isActivePlayer(UUID playerId) {
        return this.getActivePlayerId() != null && this.getActivePlayerId().equals(playerId);
    }

    default public boolean isOpponent(Player player, UUID playerToCheckId) {
        return !player.getId().equals(playerToCheckId);
    }

    public Turn getTurn();

    public PhaseStep getTurnStepType();

    public TurnPhase getTurnPhaseType();

    public Phase getPhase();

    public Step getStep();

    public int getTurnNum();

    public boolean isMainPhase();

    public boolean canPlaySorcery(UUID var1);

    public UUID getActivePlayerId();

    public UUID getPriorityPlayerId();

    public boolean checkIfGameIsOver();

    public boolean hasEnded();

    public Battlefield getBattlefield();

    public SpellStack getStack();

    public Exile getExile();

    public Combat getCombat();

    public GameState getState();

    public String getWinner();

    public void setDraw(UUID var1);

    public boolean isADraw();

    public ContinuousEffects getContinuousEffects();

    public GameStates getGameStates();

    public void loadGameStates(GameStates var1);

    public boolean isSimulation();

    public Game createSimulationForAI();

    public Game createSimulationForPlayableCalc();

    public boolean inCheckPlayableState();

    public MageObject getLastKnownInformation(UUID var1, Zone var2);

    public CardState getLastKnownInformationCard(UUID var1, Zone var2);

    public MageObject getLastKnownInformation(UUID var1, Zone var2, int var3);

    public boolean checkShortLivingLKI(UUID var1, Zone var2);

    public void rememberLKI(Zone var1, MageObject var2);

    public void resetLKI();

    public void resetShortLivingLKI();

    public StackObject findTargetingStackObject(String var1, GameEvent var2);

    public void setLosingPlayer(Player var1);

    public Player getLosingPlayer();

    public int getTotalErrorsCount();

    public int getTotalEffectsCount();

    public void addTableEventListener(Listener<TableEvent> var1);

    public void addPlayerQueryEventListener(Listener<PlayerQueryEvent> var1);

    public void fireAskPlayerEvent(UUID var1, MessageToClient var2, Ability var3);

    public void fireAskPlayerEvent(UUID var1, MessageToClient var2, Ability var3, Map<String, Serializable> var4);

    public void fireChooseChoiceEvent(UUID var1, Choice var2);

    public void fireSelectTargetEvent(UUID var1, MessageToClient var2, Set<UUID> var3, boolean var4, Map<String, Serializable> var5);

    public void fireSelectTargetEvent(UUID var1, MessageToClient var2, Cards var3, boolean var4, Map<String, Serializable> var5);

    public void fireSelectTargetTriggeredAbilityEvent(UUID var1, String var2, List<TriggeredAbility> var3);

    public void fireSelectTargetEvent(UUID var1, String var2, List<Permanent> var3, boolean var4);

    public void fireSelectEvent(UUID var1, String var2);

    public void fireSelectEvent(UUID var1, String var2, Map<String, Serializable> var3);

    public void firePriorityEvent(UUID var1);

    public void firePlayManaEvent(UUID var1, String var2, Map<String, Serializable> var3);

    public void firePlayXManaEvent(UUID var1, String var2);

    public void fireGetChoiceEvent(UUID var1, String var2, MageObject var3, List<? extends ActivatedAbility> var4);

    public void fireGetModeEvent(UUID var1, String var2, Map<UUID, String> var3);

    public void fireGetAmountEvent(UUID var1, String var2, int var3, int var4);

    public void fireGetMultiAmountEvent(UUID var1, List<MultiAmountMessage> var2, int var3, int var4, Map<String, Serializable> var5);

    public void fireChoosePileEvent(UUID var1, String var2, List<? extends Card> var3, List<? extends Card> var4);

    public void fireInformEvent(String var1);

    public void fireStatusEvent(String var1, boolean var2, boolean var3);

    public void fireUpdatePlayersEvent();

    public void informPlayers(String var1);

    public void informPlayer(Player var1, String var2);

    public void debugMessage(String var1);

    public void fireErrorEvent(String var1, Exception var2);

    public void fireGameEndInfo();

    public void fireEvent(GameEvent var1);

    public void addSimultaneousEvent(GameEvent var1);

    public boolean replaceEvent(GameEvent var1);

    public boolean replaceEvent(GameEvent var1, Ability var2);

    public PreventionEffectData preventDamage(GameEvent var1, Ability var2, Game var3, int var4);

    public void start(UUID var1);

    public void resume();

    public void pause();

    public boolean isPaused();

    public void end();

    public void cleanUp();

    public int mulliganDownTo(UUID var1);

    public void mulligan(UUID var1);

    public void endMulligan(UUID var1);

    public void timerTimeout(UUID var1);

    public void idleTimeout(UUID var1);

    public void concede(UUID var1);

    public void setConcedingPlayer(UUID var1);

    public void setManaPaymentMode(UUID var1, boolean var2);

    public void setManaPaymentModeRestricted(UUID var1, boolean var2);

    public void setUseFirstManaAbility(UUID var1, boolean var2);

    public void undo(UUID var1);

    public void emptyManaPools(Ability var1);

    public void addEffect(ContinuousEffect var1, Ability var2);

    public void addEmblem(Emblem var1, MageObject var2, Ability var3);

    public void addEmblem(Emblem var1, MageObject var2, UUID var3);

    public boolean addPlane(Plane var1, UUID var2);

    public void addCommander(Commander var1);

    public Dungeon addDungeon(Dungeon var1, UUID var2);

    public void ventureIntoDungeon(UUID var1, boolean var2);

    public void temptWithTheRing(UUID var1);

    public boolean hasDayNight();

    public void setDaytime(boolean var1);

    public boolean checkDayNight(boolean var1);

    public void addPermanent(Permanent var1, int var2);

    public void sendPlayerAction(PlayerAction var1, UUID var2, Object var3);

    public Permanent copyPermanent(Permanent var1, UUID var2, Ability var3, CopyApplier var4);

    public Permanent copyPermanent(Duration var1, Permanent var2, UUID var3, Ability var4, CopyApplier var5);

    public Card copyCard(Card var1, Ability var2, UUID var3);

    public void addTriggeredAbility(TriggeredAbility var1, GameEvent var2);

    public UUID addDelayedTriggeredAbility(DelayedTriggeredAbility var1, Ability var2);

    public UUID fireReflexiveTriggeredAbility(ReflexiveTriggeredAbility var1, Ability var2);

    public UUID fireReflexiveTriggeredAbility(ReflexiveTriggeredAbility var1, Ability var2, boolean var3);

    @Deprecated
    public void applyEffects();

    public void processAction();

    @Deprecated
    public boolean checkStateAndTriggered();

    public void playPriority(UUID var1, boolean var2);

    public void resetControlAfterSpellResolve(UUID var1);

    public boolean endTurn(Ability var1);

    public void saveState(boolean var1);

    public int bookmarkState();

    public GameState restoreState(int var1, String var2);

    public void removeBookmark(int var1);

    public void removeBookmark_v2(int var1);

    public int getSavedStateSize();

    public boolean isSaveGame();

    public void setSaveGame(boolean var1);

    public void setGameOptions(GameOptions var1);

    public Date getStartTime();

    public Date getEndTime();

    public void cheat(UUID var1, Map<Zone, String> var2);

    public void cheat(UUID var1, List<Card> var2, List<Card> var3, List<PutToBattlefieldInfo> var4, List<Card> var5, List<Card> var6, List<Card> var7);

    public void setScopeRelevant(boolean var1);

    public boolean getScopeRelevant();

    public void initTimer(UUID var1);

    public void resumeTimer(UUID var1);

    public void pauseTimer(UUID var1);

    public int getPriorityTime();

    public void setPriorityTime(int var1);

    public int getBufferTime();

    public void setBufferTime(int var1);

    public UUID getStartingPlayerId();

    public void setStartingPlayerId(UUID var1);

    public void saveRollBackGameState();

    public boolean canRollbackTurns(int var1);

    public void rollbackTurns(int var1);

    public boolean executingRollback();

    public void setEnterWithCounters(UUID var1, Counters var2);

    public Counters getEnterWithCounters(UUID var1);

    public UUID getMonarchId();

    public void setMonarchId(Ability var1, UUID var2);

    public UUID getInitiativeId();

    public void takeInitiative(Ability var1, UUID var2);

    public int damagePlayerOrPermanent(UUID var1, int var2, UUID var3, Ability var4, Game var5, boolean var6, boolean var7);

    public int damagePlayerOrPermanent(UUID var1, int var2, UUID var3, Ability var4, Game var5, boolean var6, boolean var7, List<UUID> var8);

    public Mulligan getMulligan();

    public Set<UUID> getCommandersIds(Player var1, CommanderCardType var2, boolean var3);

    default public Set<Card> getCommanderCardsFromCommandZone(Player player, CommanderCardType commanderCardType) {
        return this.getCommandersIds(player, commanderCardType, false).stream().map(this::getCard).filter(Objects::nonNull).filter(card -> Zone.COMMAND.equals((Object)this.getState().getZone(card.getId()))).collect(Collectors.toSet());
    }

    default public Set<Card> getCommanderCardsFromAnyZones(Player player, CommanderCardType commanderCardType, Zone ... searchZones) {
        HashSet<Card> res;
        Set needZones;
        block32: {
            Set needCommandersCards;
            block31: {
                block30: {
                    block29: {
                        block28: {
                            Set<UUID> needCommandersIds;
                            block27: {
                                block26: {
                                    block25: {
                                        block24: {
                                            block23: {
                                                block22: {
                                                    block21: {
                                                        needZones = Arrays.stream(searchZones).collect(Collectors.toSet());
                                                        if (needZones.isEmpty()) {
                                                            throw new IllegalArgumentException("Empty zones list in searching commanders");
                                                        }
                                                        needCommandersIds = this.getCommandersIds(player, commanderCardType, true);
                                                        needCommandersCards = needCommandersIds.stream().map(this::getCard).filter(Objects::nonNull).collect(Collectors.toSet());
                                                        res = new HashSet<Card>();
                                                        if (needZones.contains((Object)Zone.ALL)) break block21;
                                                        if (!needZones.contains((Object)Zone.HAND)) break block22;
                                                    }
                                                    needCommandersCards.stream().filter(card -> Zone.HAND.equals((Object)this.getState().getZone(card.getId()))).forEach(res::add);
                                                }
                                                if (needZones.contains((Object)Zone.ALL)) break block23;
                                                if (!needZones.contains((Object)Zone.GRAVEYARD)) break block24;
                                            }
                                            needCommandersCards.stream().filter(card -> Zone.GRAVEYARD.equals((Object)this.getState().getZone(card.getId()))).forEach(res::add);
                                        }
                                        if (needZones.contains((Object)Zone.ALL)) break block25;
                                        if (!needZones.contains((Object)Zone.LIBRARY)) break block26;
                                    }
                                    needCommandersCards.stream().filter(card -> Zone.LIBRARY.equals((Object)this.getState().getZone(card.getId()))).forEach(res::add);
                                }
                                if (needZones.contains((Object)Zone.ALL)) break block27;
                                if (!needZones.contains((Object)Zone.BATTLEFIELD)) break block28;
                            }
                            needCommandersIds.stream().map(this::getPermanent).filter(Objects::nonNull).forEach(res::add);
                        }
                        if (needZones.contains((Object)Zone.ALL)) break block29;
                        if (!needZones.contains((Object)Zone.STACK)) break block30;
                    }
                    needCommandersCards.stream().filter(card -> Zone.STACK.equals((Object)this.getState().getZone(card.getId()))).forEach(res::add);
                }
                if (needZones.contains((Object)Zone.ALL)) break block31;
                if (!needZones.contains((Object)Zone.EXILED)) break block32;
            }
            needCommandersCards.stream().filter(card -> Zone.EXILED.equals((Object)this.getState().getZone(card.getId()))).forEach(res::add);
        }
        if (needZones.contains((Object)Zone.ALL) || needZones.contains((Object)Zone.COMMAND)) {
            res.addAll(this.getCommanderCardsFromCommandZone(player, commanderCardType));
        }
        if (needZones.contains((Object)Zone.OUTSIDE)) {
            throw new IllegalArgumentException("Outside zone doesn't supported in searching commanders");
        }
        return res;
    }

    default public boolean isCommanderObject(Player player, MageObject object) {
        UUID idToCheck = null;
        if (object instanceof Spell) {
            idToCheck = ((Spell)object).getCard().getId();
        }
        if (object instanceof CommandObject) {
            idToCheck = object.getId();
        }
        if (object instanceof Card) {
            idToCheck = ((Card)object).getMainCard().getId();
        }
        return idToCheck != null && this.getCommandersIds(player, CommanderCardType.COMMANDER_OR_OATHBREAKER, false).contains(idToCheck);
    }

    public void setGameStopped(boolean var1);

    public boolean isGameStopped();

    public boolean isTurnOrderReversed();

    public UUID getTableId();

    public void setTableId(UUID var1);
}

