/*
 * Decompiled with CFR 0.152.
 */
package mage.game;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mage.MageException;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.OpeningHandAction;
import mage.abilities.SpellAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.AttachableToRestrictedAbility;
import mage.abilities.common.CantHaveMoreThanAmountCountersSourceAbility;
import mage.abilities.common.SagaAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ContinuousEffects;
import mage.abilities.effects.Effect;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.common.CopyEffect;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.continuous.BecomesFaceDownCreatureEffect;
import mage.abilities.effects.keyword.FinalityCounterEffect;
import mage.abilities.effects.keyword.ShieldCounterEffect;
import mage.abilities.effects.keyword.StunCounterEffect;
import mage.abilities.hint.common.DayNightHint;
import mage.abilities.keyword.BestowAbility;
import mage.abilities.keyword.CompanionAbility;
import mage.abilities.keyword.DayboundAbility;
import mage.abilities.keyword.NightboundAbility;
import mage.abilities.keyword.PrototypeAbility;
import mage.abilities.keyword.StartYourEnginesAbility;
import mage.abilities.keyword.StormAbility;
import mage.abilities.keyword.TransformAbility;
import mage.abilities.mana.DelayedTriggeredManaAbility;
import mage.abilities.mana.TriggeredManaAbility;
import mage.cards.Card;
import mage.cards.CardWithSpellOption;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.MeldCard;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.SpellOptionCard;
import mage.cards.SplitCard;
import mage.cards.SubCard;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckCardInfo;
import mage.choices.Choice;
import mage.collectors.DataCollectorServices;
import mage.constants.CommanderCardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.MultiplayerAttackOption;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.constants.PlayerAction;
import mage.constants.RangeOfInfluence;
import mage.constants.SagaChapter;
import mage.constants.SpellAbilityType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.TurnPhase;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.designations.Designation;
import mage.designations.Initiative;
import mage.designations.Monarch;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.filter.predicate.permanent.LegendRuleAppliesPredicate;
import mage.game.CardState;
import mage.game.Exile;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.GameCommanderImpl;
import mage.game.GameOptions;
import mage.game.GameState;
import mage.game.GameStates;
import mage.game.PutToBattlefieldInfo;
import mage.game.combat.Combat;
import mage.game.combat.CombatGroup;
import mage.game.command.CommandObject;
import mage.game.command.Commander;
import mage.game.command.Dungeon;
import mage.game.command.Emblem;
import mage.game.command.Plane;
import mage.game.command.dungeons.UndercityDungeon;
import mage.game.command.emblems.EmblemOfCard;
import mage.game.command.emblems.RadiationEmblem;
import mage.game.command.emblems.TheRingEmblem;
import mage.game.command.emblems.XmageHelperEmblem;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.events.Listener;
import mage.game.events.PlayerQueryEvent;
import mage.game.events.PlayerQueryEventSource;
import mage.game.events.PreventDamageEvent;
import mage.game.events.PreventedDamageEvent;
import mage.game.events.TableEvent;
import mage.game.events.TableEventSource;
import mage.game.events.UnattachedEvent;
import mage.game.mulligan.Mulligan;
import mage.game.permanent.Battlefield;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.game.stack.Spell;
import mage.game.stack.SpellStack;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;
import mage.game.turn.Phase;
import mage.game.turn.Step;
import mage.game.turn.Turn;
import mage.game.turn.TurnMod;
import mage.players.Player;
import mage.players.PlayerList;
import mage.players.Players;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.TargetPermanent;
import mage.target.TargetPlayer;
import mage.util.CardUtil;
import mage.util.GameLog;
import mage.util.MessageToClient;
import mage.util.MultiAmountMessage;
import mage.util.RandomUtil;
import mage.util.ThreadUtils;
import mage.util.functions.CopyApplier;
import mage.watchers.Watcher;
import mage.watchers.common.AttackedOrBlockedThisCombatWatcher;
import mage.watchers.common.AttackedThisTurnWatcher;
import mage.watchers.common.BlockedAttackerWatcher;
import mage.watchers.common.BlockingOrBlockedWatcher;
import mage.watchers.common.BloodthirstWatcher;
import mage.watchers.common.CardsDrawnThisTurnWatcher;
import mage.watchers.common.CastSpellLastTurnWatcher;
import mage.watchers.common.CommanderPlaysCountWatcher;
import mage.watchers.common.CreaturesDiedWatcher;
import mage.watchers.common.EndStepCountWatcher;
import mage.watchers.common.FirstStrikeWatcher;
import mage.watchers.common.ManaPaidSourceWatcher;
import mage.watchers.common.ManaSpentToCastWatcher;
import mage.watchers.common.PlanarRollWatcher;
import mage.watchers.common.PlayerDamagedBySourceWatcher;
import mage.watchers.common.PlayerLostLifeWatcher;
import mage.watchers.common.SpellsCastWatcher;
import mage.watchers.common.TemptedByTheRingWatcher;
import org.apache.log4j.Logger;

public abstract class GameImpl
implements Game {
    private static final AtomicInteger GLOBAL_INDEX = new AtomicInteger();
    private static final int ROLLBACK_TURNS_MAX = 4;
    private static final String UNIT_TESTS_ERROR_TEXT = "Error in unit tests";
    private static final Logger logger = Logger.getLogger(GameImpl.class);
    private transient Object customData;
    private transient Player losingPlayer;
    protected boolean simulation = false;
    protected boolean aiGame = false;
    protected boolean checkPlayableState = false;
    protected AtomicInteger totalErrorsCount = new AtomicInteger();
    protected final UUID id;
    protected final Integer gameIndex;
    protected UUID tableId = null;
    protected boolean ready;
    protected transient TableEventSource tableEventSource = new TableEventSource();
    protected transient PlayerQueryEventSource playerQueryEventSource = new PlayerQueryEventSource();
    protected Map<UUID, Card> gameCards = new HashMap<UUID, Card>();
    protected Map<UUID, MeldCard> meldCards = new HashMap<UUID, MeldCard>(0);
    protected Map<Zone, Map<UUID, MageObject>> lki = new EnumMap<Zone, Map<UUID, MageObject>>(Zone.class);
    protected Map<Zone, Map<UUID, CardState>> lkiCardState = new EnumMap<Zone, Map<UUID, CardState>>(Zone.class);
    protected Map<UUID, Map<Integer, MageObject>> lkiExtended = new HashMap<UUID, Map<Integer, MageObject>>();
    protected Map<Zone, Set<UUID>> lkiShortLiving = new EnumMap<Zone, Set<UUID>>(Zone.class);
    protected Map<String, Map<UUID, Set<UUID>>> targetedMap = new HashMap<String, Map<UUID, Set<UUID>>>();
    protected Map<UUID, Permanent> permanentsEntering = new HashMap<UUID, Permanent>();
    protected Map<UUID, Counters> enterWithCounters = new HashMap<UUID, Counters>();
    protected GameState state;
    private transient Stack<Integer> savedStates = new Stack();
    protected transient GameStates gameStates = new GameStates();
    protected transient Map<Integer, GameState> gameStatesRollBack = new HashMap<Integer, GameState>();
    protected transient boolean executingRollback;
    protected transient int turnToGoToForRollback;
    protected Date startTime;
    protected Date endTime;
    protected UUID startingPlayerId;
    protected UUID winnerId;
    protected boolean gameStopped = false;
    protected RangeOfInfluence range;
    protected Mulligan mulligan;
    protected MultiplayerAttackOption attackOption;
    protected GameOptions gameOptions;
    protected String startMessage;
    private boolean scopeRelevant = false;
    private boolean saveGame = false;
    private int priorityTime;
    private int bufferTime;
    private final int startingLife;
    private final int startingHandSize;
    private final int minimumDeckSize;
    protected transient PlayerList playerList;
    private transient int infiniteLoopCounter;
    private transient int lastNumberOfAbilitiesOnTheStack;
    private transient List<Integer> lastPlayersLifes = null;
    private final transient LinkedList<UUID> stackObjectsCheck = new LinkedList();
    private final LinkedList<UUID> concedingPlayers = new LinkedList();

    public GameImpl(MultiplayerAttackOption attackOption, RangeOfInfluence range, Mulligan mulligan, int minimumDeckSize, int startingLife, int startingHandSize) {
        this.id = UUID.randomUUID();
        this.gameIndex = GLOBAL_INDEX.incrementAndGet();
        this.range = range;
        this.mulligan = mulligan;
        this.attackOption = attackOption;
        this.state = new GameState();
        this.startingLife = startingLife;
        this.startingHandSize = startingHandSize;
        this.executingRollback = false;
        this.minimumDeckSize = minimumDeckSize;
        this.initGameDefaultWatchers();
    }

    protected GameImpl(GameImpl game) {
        this.aiGame = game.aiGame;
        this.simulation = game.simulation;
        this.checkPlayableState = game.checkPlayableState;
        this.id = game.id;
        this.gameIndex = game.gameIndex;
        this.tableId = game.tableId;
        this.totalErrorsCount.set(game.totalErrorsCount.get());
        this.ready = game.ready;
        this.gameCards = CardUtil.deepCopyObject(game.gameCards);
        this.meldCards = CardUtil.deepCopyObject(game.meldCards);
        this.lki = CardUtil.deepCopyObject(game.lki);
        this.lkiCardState = CardUtil.deepCopyObject(game.lkiCardState);
        this.lkiExtended = CardUtil.deepCopyObject(game.lkiExtended);
        this.lkiShortLiving = CardUtil.deepCopyObject(game.lkiShortLiving);
        this.targetedMap = CardUtil.deepCopyObject(game.targetedMap);
        this.permanentsEntering = CardUtil.deepCopyObject(game.permanentsEntering);
        this.enterWithCounters = CardUtil.deepCopyObject(game.enterWithCounters);
        this.state = game.state.copy();
        this.startTime = game.startTime;
        this.endTime = game.endTime;
        this.startingPlayerId = game.startingPlayerId;
        this.winnerId = game.winnerId;
        this.gameStopped = game.gameStopped;
        this.range = game.range;
        this.mulligan = game.mulligan.copy();
        this.attackOption = game.attackOption;
        this.gameOptions = game.gameOptions.copy();
        this.startMessage = game.startMessage;
        this.scopeRelevant = game.scopeRelevant;
        this.saveGame = game.saveGame;
        this.priorityTime = game.priorityTime;
        this.bufferTime = game.bufferTime;
        this.startingLife = game.startingLife;
        this.startingHandSize = game.startingHandSize;
        this.minimumDeckSize = game.minimumDeckSize;
    }

    @Override
    public Integer getGameIndex() {
        return this.gameIndex;
    }

    @Override
    public boolean isSimulation() {
        return this.simulation;
    }

    @Override
    public Game createSimulationForAI() {
        Game res = (Game)this.copy();
        ((GameImpl)res).simulation = true;
        ((GameImpl)res).aiGame = true;
        return res;
    }

    @Override
    public Game createSimulationForPlayableCalc() {
        Game res = (Game)this.copy();
        ((GameImpl)res).simulation = true;
        ((GameImpl)res).checkPlayableState = true;
        return res;
    }

    @Override
    public boolean inCheckPlayableState() {
        return this.checkPlayableState;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Object getCustomData() {
        return this.customData;
    }

    @Override
    public void setCustomData(Object data) {
        this.customData = data;
    }

    @Override
    public GameOptions getOptions() {
        if (this.gameOptions != null) {
            return this.gameOptions;
        }
        return new GameOptions();
    }

    @Override
    public void loadCards(Set<Card> cards, UUID ownerId) {
        for (Card card : cards) {
            SubCard<SplitCard> rightCard;
            SubCard<SplitCard> leftCard;
            if (card instanceof PermanentCard) {
                card = ((PermanentCard)card).getCard();
            }
            card.setOwnerId(ownerId);
            this.addCardToState(card);
            if (card instanceof SplitCard) {
                leftCard = ((SplitCard)card).getLeftHalfCard();
                leftCard.setOwnerId(ownerId);
                this.addCardToState(leftCard);
                rightCard = ((SplitCard)card).getRightHalfCard();
                rightCard.setOwnerId(ownerId);
                this.addCardToState(rightCard);
                continue;
            }
            if (card instanceof ModalDoubleFacedCard) {
                leftCard = ((ModalDoubleFacedCard)card).getLeftHalfCard();
                leftCard.setOwnerId(ownerId);
                this.addCardToState(leftCard);
                rightCard = ((ModalDoubleFacedCard)card).getRightHalfCard();
                rightCard.setOwnerId(ownerId);
                this.addCardToState(rightCard);
                continue;
            }
            if (card instanceof CardWithSpellOption) {
                SpellOptionCard spellCard = ((CardWithSpellOption)card).getSpellCard();
                spellCard.setOwnerId(ownerId);
                this.addCardToState(spellCard);
                continue;
            }
            if (card.isTransformable() && card.getSecondCardFace() != null) {
                Card nightCard = card.getSecondCardFace();
                nightCard.setOwnerId(ownerId);
                this.addCardToState(nightCard);
                continue;
            }
            if (card.getMeldsToClazz() == null) continue;
        }
    }

    private void addCardToState(Card card) {
        this.gameCards.put(card.getId(), card);
        this.state.addCard(card);
    }

    @Override
    public Collection<Card> getCards() {
        return this.gameCards.values();
    }

    @Override
    public void addMeldCard(UUID meldId, MeldCard meldCard) {
        this.meldCards.put(meldId, meldCard);
    }

    @Override
    public MeldCard getMeldCard(UUID meldId) {
        return this.meldCards.get(meldId);
    }

    @Override
    public void addPlayer(Player player, Deck deck) {
        player.useDeck(deck, this);
        this.state.addPlayer(player);
        this.initPlayerDefaultWatchers(player.getId());
    }

    @Override
    public RangeOfInfluence getRangeOfInfluence() {
        return this.range;
    }

    @Override
    public MultiplayerAttackOption getAttackOption() {
        return this.attackOption;
    }

    @Override
    public Player getPlayer(UUID playerId) {
        if (playerId == null) {
            return null;
        }
        return this.state.getPlayer(playerId);
    }

    @Override
    public Player getPlayerOrPlaneswalkerController(UUID targetId) {
        Player player = this.getPlayer(targetId);
        if (player != null) {
            return player;
        }
        Permanent permanent = this.getPermanent(targetId);
        if (permanent == null) {
            return null;
        }
        player = this.getPlayer(permanent.getControllerId());
        return player;
    }

    @Override
    public MageObject getObject(UUID objectId) {
        if (objectId == null) {
            return null;
        }
        if (this.state.getBattlefield().containsPermanent(objectId)) {
            Permanent object = this.state.getBattlefield().getPermanent(objectId);
            return object;
        }
        if (this.getPermanentsEntering().containsKey(objectId)) {
            return this.getPermanentEntering(objectId);
        }
        for (StackObject item : this.state.getStack()) {
            if (item.getId().equals(objectId)) {
                return item;
            }
            if (!(item instanceof Spell) || !item.getSourceId().equals(objectId)) continue;
            return item;
        }
        for (CommandObject commandObject : this.state.getCommand()) {
            if (!commandObject.getId().equals(objectId)) continue;
            return commandObject;
        }
        MageObject object = this.getCard(objectId);
        if (object == null) {
            for (Designation designation : this.state.getDesignations()) {
                if (!designation.getId().equals(objectId)) continue;
                return designation;
            }
            for (Emblem emblem : this.state.getHelperEmblems()) {
                if (!emblem.getId().equals(objectId)) continue;
                return emblem;
            }
            object = this.getLastKnownInformation(objectId, Zone.BATTLEFIELD);
        }
        return object;
    }

    @Override
    public MageObject getObject(Ability source) {
        return source != null ? this.getObject(source.getSourceId()) : null;
    }

    @Override
    public MageObject getBaseObject(UUID objectId) {
        if (objectId == null) {
            return null;
        }
        if (this.state.getBattlefield().containsPermanent(objectId)) {
            Permanent object = this.state.getBattlefield().getPermanent(objectId);
            return object;
        }
        MageObject object = this.getLastKnownInformation(objectId, Zone.BATTLEFIELD);
        if (object != null) {
            return object;
        }
        for (CommandObject commandObject : this.state.getCommand()) {
            if (!(commandObject instanceof Commander) || !commandObject.getId().equals(objectId)) continue;
            return commandObject;
        }
        object = this.getCard(objectId);
        if (object == null) {
            for (CommandObject commandObject : this.state.getCommand()) {
                if (!commandObject.getId().equals(objectId)) continue;
                return commandObject;
            }
        }
        return object;
    }

    @Override
    public MageObject getEmblem(UUID objectId) {
        if (objectId == null) {
            return null;
        }
        for (CommandObject commandObject : this.state.getCommand()) {
            if (!commandObject.getId().equals(objectId)) continue;
            return commandObject;
        }
        return null;
    }

    @Override
    public Dungeon getDungeon(UUID objectId) {
        return this.state.getCommand().stream().filter(commandObject -> commandObject.getId().equals(objectId)).filter(Dungeon.class::isInstance).map(Dungeon.class::cast).findFirst().orElse(null);
    }

    @Override
    public Dungeon getPlayerDungeon(UUID playerId) {
        return this.state.getCommand().stream().filter(commandObject -> commandObject.isControlledBy(playerId)).filter(Dungeon.class::isInstance).map(Dungeon.class::cast).findFirst().orElse(null);
    }

    private void removeDungeon(Dungeon dungeon) {
        if (dungeon == null) {
            return;
        }
        Player player = this.getPlayer(dungeon.getControllerId());
        if (player != null) {
            this.informPlayers(player.getLogName() + " has completed " + dungeon.getLogName());
        }
        this.state.getCommand().remove(dungeon);
        this.fireEvent(GameEvent.getEvent(GameEvent.EventType.DUNGEON_COMPLETED, dungeon.getId(), null, dungeon.getControllerId(), dungeon.getName(), 0));
    }

    private Dungeon getOrCreateDungeon(UUID playerId, boolean undercity) {
        Dungeon dungeon = this.getPlayerDungeon(playerId);
        if (dungeon != null && dungeon.hasNextRoom()) {
            return dungeon;
        }
        this.removeDungeon(dungeon);
        return this.addDungeon(undercity ? new UndercityDungeon() : Dungeon.selectDungeon(playerId, this), playerId);
    }

    @Override
    public void ventureIntoDungeon(UUID playerId, boolean isEnterToUndercity) {
        if (playerId == null) {
            return;
        }
        if (this.replaceEvent(GameEvent.getEvent(GameEvent.EventType.VENTURE, playerId, null, playerId))) {
            return;
        }
        this.getOrCreateDungeon(playerId, isEnterToUndercity).moveToNextRoom(playerId, this);
        this.fireEvent(GameEvent.getEvent(GameEvent.EventType.VENTURED, playerId, null, playerId));
    }

    private TheRingEmblem getOrCreateTheRing(UUID playerId) {
        TheRingEmblem emblem = this.state.getCommand().stream().filter(TheRingEmblem.class::isInstance).map(TheRingEmblem.class::cast).filter(commandObject -> commandObject.isControlledBy(playerId)).findFirst().orElse(null);
        if (emblem != null) {
            return emblem;
        }
        TheRingEmblem newEmblem = new TheRingEmblem(playerId);
        this.state.addCommandObject(newEmblem);
        return newEmblem;
    }

    @Override
    public void temptWithTheRing(UUID playerId) {
        Player player = this.getPlayer(playerId);
        if (player == null) {
            return;
        }
        player.chooseRingBearer(this);
        this.getOrCreateTheRing(playerId).addNextAbility(this);
        Permanent ringbearer = player.getRingBearer(this);
        UUID ringbearerId = ringbearer == null ? null : ringbearer.getId();
        this.fireEvent(GameEvent.getEvent(GameEvent.EventType.TEMPTED_BY_RING, ringbearerId, null, playerId));
    }

    @Override
    public boolean hasDayNight() {
        return this.state.isHasDayNight();
    }

    @Override
    public void setDaytime(boolean daytime) {
        if (!this.state.isHasDayNight()) {
            this.informPlayers("It has become " + (daytime ? "day" : "night"));
        }
        if (!this.state.setDaytime(daytime)) {
            return;
        }
        this.informPlayers("It has become " + (daytime ? "day" : "night"));
        this.fireEvent(GameEvent.getEvent(GameEvent.EventType.BECOMES_DAY_NIGHT, null, null, null));
        for (Permanent permanent : this.state.getBattlefield().getAllPermanents()) {
            if ((!daytime || !permanent.getAbilities(this).containsClass(NightboundAbility.class)) && (daytime || !permanent.getAbilities(this).containsClass(DayboundAbility.class))) continue;
            permanent.transform(null, this, true);
        }
    }

    @Override
    public boolean checkDayNight(boolean daytime) {
        return this.state.isHasDayNight() && this.state.isDaytime() == daytime;
    }

    @Override
    public UUID getOwnerId(UUID objectId) {
        return this.getOwnerId(this.getObject(objectId));
    }

    @Override
    public UUID getOwnerId(MageObject object) {
        if (object instanceof Spell) {
            return ((Spell)object).getOwnerId();
        }
        if (object instanceof StackObject) {
            return ((StackObject)object).getControllerId();
        }
        if (object instanceof CommandObject) {
            return ((CommandObject)object).getControllerId();
        }
        if (object instanceof Card) {
            return ((Card)object).getOwnerId();
        }
        return null;
    }

    @Override
    public UUID getControllerId(UUID objectId) {
        if (objectId == null) {
            return null;
        }
        MageObject object = this.getObject(objectId);
        if (object != null) {
            if (object instanceof StackObject) {
                return ((StackObject)object).getControllerId();
            }
            if (object instanceof Permanent) {
                return ((Permanent)object).getControllerId();
            }
            if (object instanceof CommandObject) {
                return ((CommandObject)object).getControllerId();
            }
            UUID controllerId = this.getContinuousEffects().getControllerOfSourceId(objectId);
            if (controllerId != null) {
                return controllerId;
            }
            Player player = this.getPlayer(objectId);
            if (player != null) {
                return player.getId();
            }
            if (object instanceof Card) {
                return ((Card)object).getOwnerId();
            }
        }
        return null;
    }

    @Override
    public Spell getSpell(UUID spellId) {
        return this.state.getStack().getSpell(spellId);
    }

    @Override
    public Spell getSpellOrLKIStack(UUID spellId) {
        MageObject obj;
        Spell spell = this.state.getStack().getSpell(spellId);
        if (spell == null && (obj = this.getLastKnownInformation(spellId, Zone.STACK)) instanceof Spell) {
            spell = (Spell)obj;
        }
        return spell;
    }

    @Override
    public Permanent getPermanent(UUID permanentId) {
        return this.state.getPermanent(permanentId);
    }

    @Override
    public Permanent getPermanentOrLKIBattlefield(UUID permanentId) {
        Permanent permanent = this.state.getPermanent(permanentId);
        if (permanent == null) {
            permanent = (Permanent)this.getLastKnownInformation(permanentId, Zone.BATTLEFIELD);
        }
        return permanent;
    }

    @Override
    public Permanent getPermanentOrLKIBattlefield(MageObjectReference permanentRef) {
        UUID id = permanentRef.getSourceId();
        Permanent permanent = this.state.getPermanent(id);
        if (permanent == null || this.state.getZoneChangeCounter(id) != permanentRef.getZoneChangeCounter()) {
            permanent = (Permanent)this.getLastKnownInformation(id, Zone.BATTLEFIELD, permanentRef.getZoneChangeCounter());
        }
        return permanent;
    }

    @Override
    public Permanent getPermanentEntering(UUID permanentId) {
        return this.permanentsEntering.get(permanentId);
    }

    @Override
    public Map<UUID, Permanent> getPermanentsEntering() {
        return this.permanentsEntering;
    }

    @Override
    public Card getCard(UUID cardId) {
        if (cardId == null) {
            return null;
        }
        Card card = this.gameCards.get(cardId);
        if (card == null) {
            card = this.state.getCopiedCard(cardId);
        }
        if (card == null) {
            card = this.getMeldCard(cardId);
        }
        if (card == null) {
            card = (Card)this.state.getValue("CopiedCard" + cardId);
        }
        return card;
    }

    @Override
    public Optional<Ability> getAbility(UUID abilityId, UUID sourceId) {
        MageObject object = this.getObject(sourceId);
        if (object != null) {
            return object.getAbilities().get(abilityId);
        }
        return Optional.empty();
    }

    @Override
    public void setZone(UUID objectId, Zone zone) {
        this.state.setZone(objectId, zone);
    }

    @Override
    public GameStates getGameStates() {
        return this.gameStates;
    }

    @Override
    public void loadGameStates(GameStates states) {
        this.gameStates = states;
    }

    @Override
    public void saveState(boolean bookmark) {
        if (!this.simulation && this.gameStates != null && (bookmark || this.saveGame)) {
            this.gameStates.save(this.state);
        }
    }

    @Override
    public void setConcedingPlayer(UUID playerId) {
        if (!this.concedingPlayers.contains(playerId)) {
            this.concedingPlayers.add(playerId);
        }
        Player currentPriorityPlayer = null;
        if (this.state.getPriorityPlayerId() != null) {
            currentPriorityPlayer = this.getPlayer(this.state.getPriorityPlayerId());
        } else if (this.state.getChoosingPlayerId() != null) {
            currentPriorityPlayer = this.getPlayer(this.state.getChoosingPlayerId());
        }
        if (currentPriorityPlayer == null) {
            logger.warn((Object)("Game don't have priority player - checking game end: " + this));
            if (!ThreadUtils.isRunGameThread()) {
                logger.error((Object)"Non-game thread can't concede or end games - someone called it from freeze game?");
            }
            this.checkConcede(false);
            this.checkIfGameIsOver();
            return;
        }
        if (currentPriorityPlayer.getId().equals(playerId)) {
            currentPriorityPlayer.signalPlayerConcede(true);
        } else if (currentPriorityPlayer.getTurnControlledBy().equals(playerId)) {
            currentPriorityPlayer.signalPlayerConcede(true);
        } else {
            currentPriorityPlayer.signalPlayerConcede(false);
        }
        if (ThreadUtils.isRunGameThread()) {
            this.checkConcede();
        }
    }

    public void checkConcede() {
        this.checkConcede(true);
    }

    public void checkConcede(boolean mustRunInGameThread) {
        if (mustRunInGameThread) {
            ThreadUtils.ensureRunInGameThread();
        }
        UUID playerId = this.concedingPlayers.poll();
        while (playerId != null) {
            this.leave(playerId);
            playerId = this.concedingPlayers.poll();
        }
    }

    @Override
    public boolean checkIfGameIsOver() {
        boolean noMorePlayers;
        if (this.state.isGameOver()) {
            return true;
        }
        if (Thread.currentThread().isInterrupted()) {
            return true;
        }
        int remainingPlayers = 0;
        int numLosers = 0;
        for (Player player : this.state.getPlayers().values()) {
            if (!player.hasLeft()) {
                ++remainingPlayers;
            }
            if (!player.hasLost()) continue;
            ++numLosers;
        }
        boolean bl = noMorePlayers = remainingPlayers <= 1 || numLosers >= this.state.getPlayers().size() - 1;
        if (noMorePlayers) {
            this.end();
            if (remainingPlayers == 0 && logger.isDebugEnabled()) {
                logger.debug((Object)("DRAW for gameId: " + this.getId()));
                for (Player player : this.state.getPlayers().values()) {
                    logger.debug((Object)("-- " + player.getName() + " left: " + (player.hasLeft() ? "Y" : "N") + " lost: " + (player.hasLost() ? "Y" : "N")));
                }
            }
            for (Player player : this.state.getPlayers().values()) {
                if (player.hasLeft() || player.hasLost()) continue;
                logger.debug((Object)("Player " + player.getName() + " has won gameId: " + this.getId()));
                player.won(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasEnded() {
        return this.endTime != null;
    }

    @Override
    public boolean isADraw() {
        return this.hasEnded() && this.winnerId == null;
    }

    @Override
    public String getWinner() {
        if (this.winnerId == null) {
            return "Game is a draw";
        }
        return "Player " + this.state.getPlayer(this.winnerId).getName() + " is the winner";
    }

    @Override
    public GameState getState() {
        return this.state;
    }

    @Override
    public int bookmarkState() {
        if (!this.simulation) {
            this.saveState(true);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Bookmarking state: " + this.gameStates.getSize()));
            }
            this.savedStates.push(this.gameStates.getSize() - 1);
            return this.savedStates.size();
        }
        return this.savedStates.size();
    }

    @Override
    public GameState restoreState(int bookmark, String context) {
        if (!this.simulation && !this.hasEnded() && bookmark != 0) {
            if (!this.savedStates.contains(bookmark - 1)) {
                if (!this.savedStates.isEmpty()) {
                    logger.error((Object)("It was not possible to do the requested undo operation (bookmark " + (bookmark - 1) + " does not exist) context: " + context));
                    logger.info((Object)("Saved states: " + this.savedStates.toString()));
                }
            } else {
                int stateNum = (Integer)this.savedStates.get(bookmark - 1);
                this.removeBookmark(bookmark);
                GameState restore = this.gameStates.rollback(stateNum);
                if (restore != null) {
                    this.state.restore(restore);
                    this.playerList.setCurrent(this.state.getPlayerByOrderId());
                    return this.state;
                }
            }
        }
        return null;
    }

    @Override
    public void removeBookmark(int bookmark) {
        if (!this.simulation && bookmark != 0) {
            while (this.savedStates.size() > bookmark) {
                this.savedStates.pop();
            }
            this.gameStates.remove(bookmark);
        }
    }

    @Override
    public void removeBookmark_v2(int bookmark) {
        if (!this.simulation && bookmark != 0) {
            while (this.savedStates.size() >= bookmark) {
                int outdatedIndex = this.savedStates.pop();
                while (this.gameStates.getSize() - 1 >= outdatedIndex) {
                    this.gameStates.remove(this.gameStates.getSize() - 1);
                }
            }
        }
    }

    private void clearAllBookmarks() {
        if (!this.simulation) {
            while (!this.savedStates.isEmpty()) {
                this.savedStates.pop();
            }
            this.gameStates.remove(0);
            for (Player player : this.getPlayers().values()) {
                player.setStoredBookmark(-1);
            }
        }
    }

    @Override
    public int getSavedStateSize() {
        if (!this.simulation) {
            return this.savedStates.size();
        }
        return 0;
    }

    @Override
    public void cleanUp() {
        this.gameCards.clear();
        this.meldCards.clear();
    }

    @Override
    public void start(UUID choosingPlayerId) {
        this.startTime = new Date();
        DataCollectorServices.getInstance().onGameStart(this);
        if (this.state.getPlayers().values().iterator().hasNext()) {
            this.init(choosingPlayerId);
            this.play(this.startingPlayerId);
        }
    }

    protected void play(UUID nextPlayerId) {
        boolean forcedToFinished = false;
        if (!this.isPaused() && !this.checkIfGameIsOver()) {
            this.playerList = this.state.getPlayerList(nextPlayerId);
            Player playerByOrder = this.getPlayer((UUID)this.playerList.get());
            this.state.setPlayerByOrderId(playerByOrder == null ? null : playerByOrder.getId());
            while (!this.isPaused() && !this.checkIfGameIsOver() && this.playExtraTurns()) {
                if (playerByOrder == null) {
                    logger.error((Object)"Can't find next player by order, but game stil run. Finish it.");
                    forcedToFinished = true;
                    break;
                }
                GameEvent event = new GameEvent(GameEvent.EventType.PLAY_TURN, null, null, playerByOrder.getId());
                if (!this.replaceEvent(event) && !this.playTurn(playerByOrder) || !this.playExtraTurns()) break;
                playerByOrder = this.playerList.getNext(this, true);
                if (playerByOrder == null) continue;
                this.state.setPlayerByOrderId(playerByOrder.getId());
            }
        }
        if (this.checkIfGameIsOver() && !this.isSimulation() || forcedToFinished) {
            this.winnerId = this.findWinnersAndLosers();
            StringBuilder sb = new StringBuilder("GAME END gameId: ").append(this.getId()).append(' ');
            int count = 0;
            for (Player player : this.getState().getPlayers().values()) {
                if (count > 0) {
                    sb.append(" - ");
                }
                sb.append('[').append(player.getName()).append(" => ");
                sb.append(player.hasWon() ? "W" : "");
                sb.append(player.hasLost() ? "L" : "");
                sb.append(player.hasQuit() ? "Q" : "");
                sb.append(player.hasIdleTimeout() ? "I" : "");
                sb.append(player.hasTimerTimeout() ? "T" : "");
                sb.append(']');
                ++count;
            }
            logger.debug((Object)sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean playExtraTurns() {
        TurnMod extraTurn = this.useNextExtraTurn();
        try {
            while (extraTurn != null) {
                Player extraPlayer;
                GameEvent event = new GameEvent(GameEvent.EventType.PLAY_TURN, null, null, extraTurn.getPlayerId());
                if (!this.replaceEvent(event) && (extraPlayer = this.getPlayer(extraTurn.getPlayerId())) != null && extraPlayer.canRespond()) {
                    this.state.setExtraTurnId(extraTurn.getId());
                    this.informPlayers(String.format("%s takes an extra turn%s", extraPlayer.getLogName(), extraTurn.getInfo()));
                    if (!this.playTurn(extraPlayer)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                extraTurn = this.useNextExtraTurn();
            }
        }
        finally {
            this.state.setExtraTurnId(null);
        }
        return true;
    }

    private TurnMod useNextExtraTurn() {
        boolean checkForExtraTurn = true;
        while (checkForExtraTurn) {
            TurnMod extraTurn = this.getState().getTurnMods().useNextExtraTurn();
            if (extraTurn != null) {
                GameEvent event = new GameEvent(GameEvent.EventType.EXTRA_TURN, extraTurn.getId(), null, extraTurn.getPlayerId());
                if (this.replaceEvent(event)) continue;
                return extraTurn;
            }
            checkForExtraTurn = false;
        }
        return null;
    }

    private boolean playTurn(Player player) {
        boolean skipTurn = false;
        do {
            if (this.executingRollback) {
                this.rollbackTurnsExecution(this.turnToGoToForRollback);
                player = this.getPlayer(this.state.getActivePlayerId());
            } else {
                this.state.setActivePlayerId(player.getId());
                this.saveRollBackGameState();
            }
            if (this.checkStopOnTurnOption()) {
                return false;
            }
            skipTurn = this.state.getTurn().play(this, player);
        } while (this.executingRollback);
        if (this.isPaused() || this.checkIfGameIsOver()) {
            return false;
        }
        if (!skipTurn) {
            this.endOfTurn();
            this.state.setTurnNum(this.state.getTurnNum() + 1);
        }
        return true;
    }

    @Override
    public void resume() {
        this.playerList = this.state.getPlayerList(this.state.getActivePlayerId());
        Player player = this.getPlayer((UUID)this.playerList.get());
        boolean wasPaused = this.state.isPaused();
        this.state.resume();
        if (!this.checkIfGameIsOver()) {
            this.fireInformEvent("Turn " + this.state.getTurnNum());
            if (this.checkStopOnTurnOption()) {
                return;
            }
            this.state.getTurn().resumePlay(this, wasPaused);
            if (!this.isPaused() && !this.checkIfGameIsOver()) {
                this.endOfTurn();
                Player nextPlayer = this.playerList.getNext(this, true);
                if (nextPlayer != null) {
                    player = nextPlayer;
                }
                this.state.setTurnNum(this.state.getTurnNum() + 1);
            }
        }
        this.play(player.getId());
    }

    private boolean checkStopOnTurnOption() {
        if (this.gameOptions.stopOnTurn != null && this.gameOptions.stopAtStep == PhaseStep.UNTAP && this.gameOptions.stopOnTurn.equals(this.state.getTurnNum())) {
            this.winnerId = null;
            this.saveState(false);
            return true;
        }
        return false;
    }

    protected void init(UUID choosingPlayerId) {
        Card card;
        Object player2;
        Player startingPlayer;
        for (Iterator player3 : this.state.getPlayers().values()) {
            player3.beginTurn(this);
            if (this.priorityTime <= 0 || player3.getPriorityTimeLeft() != Integer.MAX_VALUE) continue;
            this.initTimer(player3.getId());
        }
        if (this.startMessage == null || this.startMessage.isEmpty()) {
            this.startMessage = "Game has started";
        }
        this.fireStatusEvent(this.startMessage, false, false);
        this.saveState(false);
        if (this.checkIfGameIsOver()) {
            return;
        }
        this.state.addAbility((Ability)new SimpleStaticAbility(Zone.ALL, new ShieldCounterEffect()), null);
        this.state.addAbility((Ability)new SimpleStaticAbility(Zone.ALL, new StunCounterEffect()), null);
        this.state.addAbility((Ability)new SimpleStaticAbility(Zone.ALL, new FinalityCounterEffect()), null);
        HashMap<Player, Card> playerCompanionMap = new HashMap<Player, Card>();
        block1: for (Player player4 : this.state.getPlayers().values()) {
            HashSet<Card> cards = new HashSet<Card>(player4.getLibrary().getCards(this));
            HashSet<Card> potentialCompanions = new HashSet<Card>();
            block2: for (Card card2 : player4.getSideboard().getUniqueCards(this)) {
                for (Ability ability : card2.getAbilities(this)) {
                    Object companionAbility;
                    if (!(ability instanceof CompanionAbility) || !((CompanionAbility)(companionAbility = (CompanionAbility)ability)).isLegal(cards, this.minimumDeckSize)) continue;
                    potentialCompanions.add(card2);
                    continue block2;
                }
            }
            for (Card card2 : potentialCompanions) {
                if (!player4.chooseUse(Outcome.Benefit, "Use " + card2.getLogName() + " as your companion?", null, this)) continue;
                playerCompanionMap.put(player4, card2);
                continue block1;
            }
        }
        playerCompanionMap.forEach((player, companion) -> {
            if (companion != null) {
                this.informPlayers(player.getLogName() + " has chosen " + companion.getLogName() + " as their companion.");
                this.getState().getCompanion().update(player.getName() + "'s companion", new CardsImpl((Card)companion));
            }
        });
        if (!this.gameOptions.skipInitShuffling) {
            for (Player player4 : this.state.getPlayers().values()) {
                player4.shuffleLibrary(null, this);
            }
        }
        Player choosingPlayer = null;
        if (this.startingPlayerId == null) {
            TargetPlayer targetPlayer = new TargetPlayer();
            targetPlayer.withTargetName("starting player");
            if (choosingPlayerId != null && (choosingPlayer = this.getPlayer(choosingPlayerId)) != null && !choosingPlayer.canRespond()) {
                choosingPlayer = null;
            }
            if (choosingPlayer == null) {
                choosingPlayerId = this.pickChoosingPlayer();
                if (choosingPlayerId == null) {
                    return;
                }
                choosingPlayer = this.getPlayer(choosingPlayerId);
            }
            if (choosingPlayer == null) {
                return;
            }
            this.getState().setChoosingPlayerId(choosingPlayerId);
            if (choosingPlayer.choose(Outcome.Benefit, targetPlayer, null, this)) {
                this.startingPlayerId = targetPlayer.getTargets().get(0);
            } else if (this.getState().getPlayers().size() < 3) {
                return;
            }
        }
        if (this.startingPlayerId == null) {
            for (Object player5 : this.state.getPlayers().values()) {
                if (!player5.canRespond()) continue;
                this.startingPlayerId = player5.getId();
                break;
            }
            if (this.startingPlayerId == null) {
                return;
            }
        }
        if ((startingPlayer = this.state.getPlayer(this.startingPlayerId)) == null) {
            logger.debug((Object)("Starting player not found. playerId:" + this.startingPlayerId));
            return;
        }
        this.sendStartMessage(choosingPlayer, startingPlayer);
        for (UUID playerId : this.state.getPlayerList(this.startingPlayerId)) {
            player2 = this.getPlayer(playerId);
            if (!this.gameOptions.testMode || player2.getLife() == 0) {
                player2.initLife(this.getStartingLife());
            }
            if (this.gameOptions.testMode) continue;
            this.mulligan.drawHand(this.startingHandSize, (Player)player2, this);
        }
        this.mulligan.executeMulliganPhase(this, this.startingHandSize);
        this.getState().setChoosingPlayerId(null);
        this.state.resetWatchers();
        for (UUID playerId : this.state.getPlayerList(this.startingPlayerId)) {
            player2 = this.getPlayer(playerId);
            CardsImpl cardsWithOpeningAction = new CardsImpl();
            for (Card card3 : player2.getHand().getCards(this)) {
                for (Ability ability : card3.getAbilities(this)) {
                    OpeningHandAction action;
                    if (!(ability instanceof OpeningHandAction) || !(action = (OpeningHandAction)((Object)ability)).isOpeningHandActionAllowed(card3, (Player)player2, this)) continue;
                    cardsWithOpeningAction.add(card3);
                }
            }
            while (!cardsWithOpeningAction.isEmpty() && player2.canRespond()) {
                if (cardsWithOpeningAction.size() > 1) {
                    TargetCard targetCard = new TargetCard(1, Zone.HAND, new FilterCard("card for opening hand action"));
                    player2.chooseTarget(Outcome.Benefit, cardsWithOpeningAction, targetCard, null, this);
                    card = this.getCard(targetCard.getFirstTarget());
                } else {
                    card = cardsWithOpeningAction.getRandom(this);
                }
                if (card != null) {
                    for (Ability ability : card.getAbilities(this)) {
                        OpeningHandAction action;
                        if (!(ability instanceof OpeningHandAction) || !(action = (OpeningHandAction)((Object)ability)).askUseOpeningHandAction(card, (Player)player2, this)) continue;
                        action.doOpeningHandAction(card, (Player)player2, this);
                    }
                }
                cardsWithOpeningAction.remove(card);
            }
        }
        if (this.gameOptions.planeChase) {
            Plane plane = Plane.createRandomPlane();
            plane.setControllerId(this.startingPlayerId);
            this.addPlane(plane, this.startingPlayerId);
            this.state.setPlaneChase(this, this.gameOptions.planeChase);
        }
        if (!this.gameOptions.perPlayerEmblemCards.isEmpty()) {
            for (UUID playerId : this.state.getPlayerList(this.startingPlayerId)) {
                for (DeckCardInfo info : this.gameOptions.perPlayerEmblemCards) {
                    card = EmblemOfCard.cardFromDeckInfo(info);
                    EmblemOfCard emblem = new EmblemOfCard(card);
                    this.addEmblem((Emblem)emblem, (MageObject)card, playerId);
                    for (Ability ability : emblem.getAbilities()) {
                        this.state.addAbility(ability, null, emblem);
                    }
                }
            }
        }
        if (!this.gameOptions.globalEmblemCards.isEmpty()) {
            for (DeckCardInfo info : this.gameOptions.globalEmblemCards) {
                Card card4 = EmblemOfCard.cardFromDeckInfo(info);
                EmblemOfCard emblem = new EmblemOfCard(card4);
                this.addEmblem((Emblem)emblem, (MageObject)card4, this.startingPlayerId);
                for (Ability ability : emblem.getAbilities()) {
                    this.state.addAbility(ability, null, emblem);
                }
            }
        }
        this.initGameDefaultHelperEmblems();
    }

    public void initGameDefaultWatchers() {
        ArrayList<Watcher> newWatchers = new ArrayList<Watcher>();
        newWatchers.add(new CastSpellLastTurnWatcher());
        newWatchers.add(new PlayerLostLifeWatcher());
        newWatchers.add(new FirstStrikeWatcher());
        newWatchers.add(new BlockedAttackerWatcher());
        newWatchers.add(new PlanarRollWatcher());
        newWatchers.add(new AttackedThisTurnWatcher());
        newWatchers.add(new CardsDrawnThisTurnWatcher());
        newWatchers.add(new ManaSpentToCastWatcher());
        newWatchers.add(new ManaPaidSourceWatcher());
        newWatchers.add(new BlockingOrBlockedWatcher());
        newWatchers.add(new EndStepCountWatcher());
        newWatchers.add(new CommanderPlaysCountWatcher());
        newWatchers.add(new CreaturesDiedWatcher());
        newWatchers.add(new TemptedByTheRingWatcher());
        newWatchers.add(new SpellsCastWatcher());
        newWatchers.add(new AttackedOrBlockedThisCombatWatcher());
        newWatchers.forEach(watcher -> {
            if (!watcher.getScope().equals((Object)WatcherScope.GAME)) {
                throw new IllegalStateException("Game default watchers must have GAME scope: " + watcher.getClass().getCanonicalName());
            }
        });
        newWatchers.forEach(this.getState()::addWatcher);
    }

    public void initPlayerDefaultWatchers(UUID playerId) {
        PlayerDamagedBySourceWatcher playerDamagedBySourceWatcher = new PlayerDamagedBySourceWatcher();
        playerDamagedBySourceWatcher.setControllerId(playerId);
        this.getState().addWatcher(playerDamagedBySourceWatcher);
        BloodthirstWatcher bloodthirstWatcher = new BloodthirstWatcher();
        bloodthirstWatcher.setControllerId(playerId);
        this.getState().addWatcher(bloodthirstWatcher);
    }

    public void initGameDefaultHelperEmblems() {
        for (UUID playerId : this.state.getPlayerList(this.startingPlayerId)) {
            this.state.addHelperEmblem(new RadiationEmblem(), playerId);
        }
        for (UUID playerId : this.state.getPlayerList(this.startingPlayerId)) {
            this.state.addHelperEmblem(new XmageHelperEmblem().withCardHint("storm counter", StormAbility.getHint()), playerId);
            this.state.addHelperEmblem(new XmageHelperEmblem().withCardHint("day or night", DayNightHint.instance), playerId);
        }
    }

    protected void sendStartMessage(Player choosingPlayer, Player startingPlayer) {
        StringBuilder message = new StringBuilder();
        if (choosingPlayer != null) {
            message.append(choosingPlayer.getLogName()).append(" chooses that ");
        }
        if (choosingPlayer != null && choosingPlayer.getId().equals(startingPlayer.getId())) {
            message.append("they");
        } else {
            message.append(startingPlayer.getLogName());
        }
        message.append(" take the first turn");
        this.informPlayers(message.toString());
    }

    protected UUID findWinnersAndLosers() {
        UUID winnerIdFound = null;
        for (Player player : this.state.getPlayers().values()) {
            if (player.hasWon()) {
                logger.debug((Object)(player.getName() + " has won gameId: " + this.getId()));
                winnerIdFound = player.getId();
                break;
            }
            if (player.hasLost() || player.hasLeft()) continue;
            logger.debug((Object)(player.getName() + " has not lost so they won gameId: " + this.getId()));
            player.won(this);
            winnerIdFound = player.getId();
            break;
        }
        for (Player player : this.state.getPlayers().values()) {
            if (winnerIdFound == null || player.getId().equals(winnerIdFound) || player.hasLost()) continue;
            player.lost(this);
        }
        return winnerIdFound;
    }

    protected void endOfTurn() {
        for (Player player : this.getPlayers().values()) {
            player.endOfTurn(this);
        }
        this.state.resetWatchers();
        this.state.cleanupPermanentCostsTags(this);
    }

    protected UUID pickChoosingPlayer() {
        UUID[] players = this.getPlayers().keySet().toArray(new UUID[0]);
        while (!this.hasEnded()) {
            UUID playerId = players[RandomUtil.nextInt(players.length)];
            Player player = this.getPlayer(playerId);
            if (player == null || !player.canRespond()) continue;
            this.fireInformEvent(this.state.getPlayer(playerId).getLogName() + " won the toss");
            return player.getId();
        }
        logger.debug((Object)("Game was not possible to pick a choosing player. GameId:" + this.getId()));
        return null;
    }

    @Override
    public void pause() {
        this.state.pause();
    }

    @Override
    public boolean isPaused() {
        return this.state.isPaused();
    }

    @Override
    public void end() {
        if (!this.state.isGameOver()) {
            logger.debug((Object)("END of gameId: " + this.getId()));
            this.endTime = new Date();
            this.state.endGame();
            for (Player player : this.state.getPlayers().values()) {
                player.abort();
            }
            this.state.getBattlefield().getAllPermanents().stream().filter(permanent -> permanent.isFaceDown(this)).map(permanent -> {
                Player player = this.getPlayer(permanent.getControllerId());
                Card card = permanent.getMainCard();
                if (card != null) {
                    return String.format("Face down card reveal: %s had %s", player == null ? "Unknown" : player.getLogName(), card.getLogName());
                }
                return null;
            }).filter(Objects::nonNull).sorted().forEach(this::informPlayers);
            DataCollectorServices.getInstance().onGameEnd(this);
        }
    }

    @Override
    public void addTableEventListener(Listener<TableEvent> listener) {
        this.tableEventSource.addListener(listener);
    }

    @Override
    public int mulliganDownTo(UUID playerId) {
        return this.mulligan.mulliganDownTo(this, playerId);
    }

    @Override
    public void endMulligan(UUID playerId) {
        this.mulligan.endMulligan(this, playerId);
    }

    @Override
    public void mulligan(UUID playerId) {
        this.mulligan.mulligan(this, playerId);
    }

    @Override
    public synchronized void timerTimeout(UUID playerId) {
        Player player = this.state.getPlayer(playerId);
        if (player != null) {
            player.timerTimeout(this);
        } else {
            logger.error((Object)new StringBuilder("timerTimeout - player not found - playerId: ").append(playerId));
        }
    }

    @Override
    public synchronized void idleTimeout(UUID playerId) {
        Player player = this.state.getPlayer(playerId);
        if (player != null) {
            player.idleTimeout(this);
        } else {
            logger.error((Object)new StringBuilder("idleTimeout - player not found - playerId: ").append(playerId));
        }
    }

    @Override
    public synchronized void concede(UUID playerId) {
        Player player = this.state.getPlayer(playerId);
        if (player != null && !player.hasLost()) {
            logger.debug((Object)("Player " + player.getName() + " concedes game " + this.getId()));
            this.fireInformEvent(player.getLogName() + " has conceded.");
            player.concede(this);
        }
    }

    @Override
    public synchronized void undo(UUID playerId) {
        int bookmark;
        Player player = this.state.getPlayer(playerId);
        if (player != null && (bookmark = player.getStoredBookmark()) != -1) {
            player.restoreState(bookmark, "undo", this);
            player.setStoredBookmark(-1);
            this.fireUpdatePlayersEvent();
        }
    }

    @Override
    public void sendPlayerAction(PlayerAction playerAction, UUID playerId, Object data) {
        Player player = this.state.getPlayer(playerId);
        if (player != null) {
            player.sendPlayerAction(playerAction, this, data);
        }
    }

    @Override
    public synchronized void setManaPaymentMode(UUID playerId, boolean autoPayment) {
        Player player = this.state.getPlayer(playerId);
        if (player != null) {
            player.getUserData().setManaPoolAutomatic(autoPayment);
            player.getManaPool().setAutoPayment(autoPayment);
        }
    }

    @Override
    public synchronized void setManaPaymentModeRestricted(UUID playerId, boolean autoPaymentRestricted) {
        Player player = this.state.getPlayer(playerId);
        if (player != null) {
            player.getUserData().setManaPoolAutomaticRestricted(autoPaymentRestricted);
            player.getManaPool().setAutoPaymentRestricted(autoPaymentRestricted);
        }
    }

    @Override
    public synchronized void setUseFirstManaAbility(UUID playerId, boolean useFirstManaAbility) {
        Player player = this.state.getPlayer(playerId);
        if (player != null) {
            player.getUserData().setUseFirstManaAbility(useFirstManaAbility);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void playPriority(UUID activePlayerId, boolean resuming) {
        block25: {
            if (!this.isSimulation() && this.inCheckPlayableState()) {
                throw new IllegalStateException("Wrong code usage. Only simulation games can be in CheckPlayableState");
            }
            priorityErrorsCount = 0;
            this.infiniteLoopCounter = 0;
            rollbackBookmarkOnPriorityStart = 0;
            this.clearAllBookmarks();
            this.applyEffects();
lbl9:
            // 3 sources

            while (!(this.isPaused() || this.checkIfGameIsOver() || this.getTurn().isEndTurnRequested())) {
                if (!resuming) {
                    this.state.getPlayers().resetPassed();
                    this.state.getPlayerList().setCurrent(activePlayerId);
                } else {
                    this.state.getPlayerList().setCurrent(this.getPriorityPlayerId());
                }
                this.fireUpdatePlayersEvent();
lbl18:
                // 3 sources

                while (!this.isPaused() && !this.checkIfGameIsOver()) {
                    try {
                        if (rollbackBookmarkOnPriorityStart == 0) {
                            rollbackBookmarkOnPriorityStart = this.bookmarkState();
                        }
                        player = this.getPlayer((UUID)this.state.getPlayerList().get());
                        this.state.setPriorityPlayerId(player.getId());
lbl24:
                        // 2 sources

                        while (!player.isPassed() && player.canRespond() && !this.isPaused() && !this.checkIfGameIsOver()) {
                            if (resuming) ** GOTO lbl-1000
                            this.checkStateAndTriggered();
                            this.applyEffects();
                            if (this.state.getStack().isEmpty()) {
                                this.resetLKI();
                            }
                            this.saveState(false);
                            if (this.isPaused() || this.checkIfGameIsOver()) {
                                this.resetLKI();
                                this.clearAllBookmarks();
                                return;
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl92
                    }
                    catch (Exception e) {
                        this.totalErrorsCount.incrementAndGet();
                        GameImpl.logger.fatal((Object)("Game error: " + this.getId() + " - " + this), (Throwable)e);
                        this.fireErrorEvent("Game error occurred: ", e);
                        GameImpl.logger.info((Object)"---");
                        GameImpl.logger.info((Object)("Game state on error: " + this));
                        info = this.getStack().stream().map((Function<StackObject, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$playPriority$7(mage.game.stack.StackObject ), (Lmage/game/stack/StackObject;)Ljava/lang/String;)()).collect(Collectors.joining("\n"));
                        GameImpl.logger.info((Object)String.format("Stack on error %d: \n%s\n", new Object[]{this.getStack().size(), info}));
                        GameImpl.logger.info((Object)"---");
                        if (priorityErrorsCount > 15) {
                            throw new MageException("Too many errors, game will be end. Last error: " + e);
                        }
                        restoredState = this.restoreState(rollbackBookmarkOnPriorityStart, "Game error: " + e);
                        rollbackBookmarkOnPriorityStart = 0;
                        if (restoredState != null) {
                            this.informPlayers(String.format("Auto-restored to %s due game error: %s", new Object[]{restoredState, e}));
                        } else {
                            GameImpl.logger.error((Object)"Can't auto-restore to prev state");
                        }
                        activePlayer = this.getPlayer(this.getActivePlayerId());
                        if (activePlayer == null) throw new MageException("Error in unit tests");
                        if (activePlayer.isTestMode() != false) throw new MageException("Error in unit tests");
                        if (activePlayer.isFastFailInTestMode() != false) throw new MageException("Error in unit tests");
                        ++priorityErrorsCount;
                    }
                }
            }
            {
                catch (Throwable var10_11) {
                    throw var10_11;
                }
                catch (Exception e) {}
                ** try [egrp 7[TRYBLOCK] [18 : 782->877)] { 
lbl68:
                // 1 sources

                this.totalErrorsCount.incrementAndGet();
                GameImpl.logger.fatal((Object)("Game end on critical error: " + e), (Throwable)e);
                this.fireErrorEvent("Game end on critical error: " + e, e);
                this.end();
                if ("Error in unit tests".equals(e.getMessage()) == false) return;
                throw new IllegalStateException("Error in unit tests");
lbl75:
                // 1 sources

                finally {
                    this.resetLKI();
                    this.clearAllBookmarks();
                }
            }
lbl-1000:
            // 1 sources

            {
                if (!player.priority(this)) ** GOTO lbl86
                if (!this.executingRollback()) ** GOTO lbl-1000
                this.resetLKI();
                this.clearAllBookmarks();
                return;
            }
lbl-1000:
            // 1 sources

            {
                this.getState().handleSimultaneousEvent(this);
                this.applyEffects();
lbl86:
                // 2 sources

                if (!this.isPaused()) ** GOTO lbl-1000
                this.resetLKI();
                this.clearAllBookmarks();
                return;
            }
lbl-1000:
            // 2 sources

            {
                resuming = false;
                ** GOTO lbl24
lbl92:
                // 1 sources

                this.resetShortLivingLKI();
                resuming = false;
                if (!this.isPaused() && !this.checkIfGameIsOver()) ** GOTO lbl-1000
                this.resetLKI();
                this.clearAllBookmarks();
                return;
            }
lbl-1000:
            // 1 sources

            {
                if (!this.allPassed()) break block25;
                if (this.state.getStack().isEmpty()) {
                    this.resetLKI();
                    this.resetLKI();
                    this.clearAllBookmarks();
                    return;
                }
                this.resolve();
                this.checkConcede();
                this.applyEffects();
                this.state.getPlayers().resetPassed();
                this.fireUpdatePlayersEvent();
                this.resetShortLivingLKI();
                ** GOTO lbl9
            }
        }
        this.state.getPlayerList().getNext();
        ** GOTO lbl18
        this.resetLKI();
        this.clearAllBookmarks();
    }

    protected void resolve() {
        StackObject top = null;
        boolean wasError = false;
        try {
            top = (StackObject)this.state.getStack().peek();
            DataCollectorServices.getInstance().onTestsStackResolve(this);
            top.resolve(this);
            this.resetControlAfterSpellResolve(top.getId());
        }
        catch (Throwable e) {
            wasError = true;
            throw e;
        }
        finally {
            if (top != null) {
                this.state.getStack().remove(top, this);
                if (!wasError) {
                    this.checkInfiniteLoop(top.getSourceId());
                }
                if (!this.getTurn().isEndTurnRequested()) {
                    while (this.state.hasSimultaneousEvents()) {
                        this.state.handleSimultaneousEvent(this);
                    }
                }
            }
        }
    }

    @Override
    public void resetControlAfterSpellResolve(UUID topId) {
        Spell spell = this.getSpellOrLKIStack(topId);
        if (spell != null && spell.getCommandedByPlayerId() != null) {
            Player targetPlayer;
            Player turnController;
            UUID commandedBy = spell.getCommandedByPlayerId();
            UUID spellControllerId = commandedBy.equals(spell.getControllerId()) ? spell.getSpellAbility().getFirstTarget() : spell.getControllerId();
            if (spellControllerId != null && (turnController = this.getPlayer(commandedBy)) != null && (targetPlayer = this.getPlayer(spellControllerId)) != null) {
                targetPlayer.setGameUnderYourControl(this, true, false);
                this.informPlayers(turnController.getLogName() + " lost control over " + targetPlayer.getLogName());
                if (targetPlayer.getTurnControlledBy().equals(turnController.getId())) {
                    turnController.getPlayersUnderYourControl().remove(targetPlayer.getId());
                }
            }
            spell.setCommandedBy(null, null);
        }
    }

    protected void checkInfiniteLoop(UUID removedStackObjectSourceId) {
        if (this.stackObjectsCheck.contains(removedStackObjectSourceId) && this.getStack().size() >= this.lastNumberOfAbilitiesOnTheStack) {
            Player controller;
            ArrayList<Integer> newLastPlayersLifes = new ArrayList<Integer>();
            for (Player player : this.getPlayers().values()) {
                newLastPlayersLifes.add(player.getLife());
            }
            if (this.lastPlayersLifes != null && this.lastPlayersLifes.size() == newLastPlayersLifes.size()) {
                for (int i = 0; i < newLastPlayersLifes.size(); ++i) {
                    if ((Integer)newLastPlayersLifes.get(i) >= this.lastPlayersLifes.get(i)) continue;
                    this.lastPlayersLifes = null;
                    this.infiniteLoopCounter = 0;
                    break;
                }
            } else {
                this.lastPlayersLifes = newLastPlayersLifes;
            }
            ++this.infiniteLoopCounter;
            if (this.infiniteLoopCounter > 15 && (controller = this.getPlayer(this.getControllerId(removedStackObjectSourceId))) != null) {
                Player player;
                for (UUID playerId : this.getState().getPlayersInRange(controller.getId(), this)) {
                    player = this.getPlayer(playerId);
                    if (!player.chooseUse(Outcome.Detriment, "Draw game because of infinite looping?", null, this)) {
                        this.informPlayers(controller.getLogName() + " has NOT confirmed that the game is a draw because of infinite looping.");
                        this.infiniteLoopCounter = 0;
                        return;
                    }
                    this.informPlayers(controller.getLogName() + " has confirmed that the game is a draw because of infinite looping.");
                }
                for (UUID playerId : this.getState().getPlayersInRange(controller.getId(), this)) {
                    player = this.getPlayer(playerId);
                    if (player == null) continue;
                    player.drew(this);
                }
            }
        } else {
            this.stackObjectsCheck.add(removedStackObjectSourceId);
            if (this.stackObjectsCheck.size() > 4) {
                this.stackObjectsCheck.removeFirst();
            }
        }
        this.lastNumberOfAbilitiesOnTheStack = this.getStack().size();
    }

    protected boolean allPassed() {
        for (Player player : this.state.getPlayers().values()) {
            if (player.isPassed() || !player.canRespond()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void emptyManaPools(Ability source) {
        for (Player player : this.getPlayers().values()) {
            int amount = player.getManaPool().emptyPool(this);
            if (!this.state.isManaBurn() || amount <= 0) continue;
            player.loseLife(amount, this, source, false);
        }
    }

    @Override
    public synchronized void applyEffects() {
        this.state.applyEffects(this);
    }

    @Override
    public void processAction() {
        this.state.handleSimultaneousEvent(this);
        this.resetShortLivingLKI();
        this.applyEffects();
        this.state.getTriggers().checkStateTriggers(this);
    }

    @Override
    public void addEffect(ContinuousEffect continuousEffect, Ability source) {
        Ability newAbility = source.copy();
        newAbility.initSourceObjectZoneChangeCounter(this, true);
        ContinuousEffect newEffect = continuousEffect.copy();
        newEffect.newId();
        newEffect.init(newAbility, this);
        this.state.addEffect(newEffect, newAbility);
    }

    @Override
    public void addEmblem(Emblem emblem, MageObject sourceObject, Ability source) {
        this.addEmblem(emblem, sourceObject, source.getControllerId());
    }

    @Override
    public void addEmblem(Emblem emblem, MageObject sourceObject, UUID toPlayerId) {
        Emblem newEmblem = emblem.copy();
        newEmblem.setSourceObjectAndInitImage(sourceObject);
        newEmblem.setControllerId(toPlayerId);
        newEmblem.assignNewId();
        newEmblem.getAbilities().newId();
        for (Ability ability : newEmblem.getAbilities()) {
            ability.setSourceId(newEmblem.getId());
        }
        this.state.addCommandObject(newEmblem);
    }

    @Override
    public boolean addPlane(Plane plane, UUID toPlayerId) {
        for (Object cobject : this.state.getCommand()) {
            if (!(cobject instanceof Plane)) continue;
            return false;
        }
        Plane newPlane = plane.copy();
        newPlane.setSourceObjectAndInitImage();
        newPlane.setControllerId(toPlayerId);
        newPlane.assignNewId();
        newPlane.getAbilities().newId();
        for (Ability ability : newPlane.getAbilities()) {
            ability.setSourceId(newPlane.getId());
        }
        this.state.addCommandObject(newPlane);
        this.informPlayers("You have planeswalked to " + newPlane.getLogName());
        GameEvent event = new GameEvent(GameEvent.EventType.PLANESWALK, newPlane.getId(), null, newPlane.getId(), 0, true);
        if (!this.replaceEvent(event)) {
            GameEvent ge = new GameEvent(GameEvent.EventType.PLANESWALKED, newPlane.getId(), null, newPlane.getId(), 0, true);
            this.fireEvent(ge);
        }
        return true;
    }

    @Override
    public void addCommander(Commander commander) {
        this.state.addCommandObject(commander);
    }

    @Override
    public Dungeon addDungeon(Dungeon dungeon, UUID playerId) {
        dungeon.setControllerId(playerId);
        this.state.addCommandObject(dungeon);
        return dungeon;
    }

    @Override
    public void addPermanent(Permanent permanent, int createOrder) {
        if (createOrder == 0) {
            createOrder = this.getState().getNextPermanentOrderNumber();
        }
        permanent.setCreateOrder(createOrder);
        this.getBattlefield().addPermanent(permanent);
    }

    @Override
    public Permanent copyPermanent(Permanent copyFromPermanent, UUID copyToPermanentId, Ability source, CopyApplier applier) {
        return this.copyPermanent(Duration.Custom, copyFromPermanent, copyToPermanentId, source, applier);
    }

    @Override
    public Permanent copyPermanent(Duration duration, Permanent copyFromPermanent, UUID copyToPermanentId, Ability source, CopyApplier applier) {
        Permanent newBluePrint = null;
        for (Effect effect : this.getState().getContinuousEffects().getLayeredEffects(this)) {
            MageObject mageObject;
            CopyEffect copyEffect;
            if (!(effect instanceof CopyEffect) || !(copyEffect = (CopyEffect)effect).getSourceId().equals(copyFromPermanent.getId()) || !((mageObject = ((CopyEffect)effect).getTarget()) instanceof Permanent)) continue;
            newBluePrint = ((Permanent)mageObject).copy();
        }
        if (newBluePrint == null) {
            newBluePrint = copyFromPermanent.copy();
            newBluePrint.reset(this);
            BecomesFaceDownCreatureEffect.FaceDownType faceDownType = BecomesFaceDownCreatureEffect.findFaceDownType(this, copyFromPermanent);
            if (faceDownType != null) {
                BecomesFaceDownCreatureEffect.makeFaceDownObject(this, null, newBluePrint, faceDownType, null);
            }
            newBluePrint.assignNewId();
            if (copyFromPermanent.isTransformed()) {
                TransformAbility.transformPermanent(newBluePrint, this, source);
            }
            if (copyFromPermanent.isPrototyped()) {
                Abilities<Ability> abilities = copyFromPermanent.getAbilities();
                for (Ability ability : abilities) {
                    if (!(ability instanceof PrototypeAbility)) continue;
                    ((PrototypeAbility)ability).prototypePermanent(newBluePrint, this);
                }
            }
        }
        if (applier != null) {
            applier.apply(this, newBluePrint, source, copyToPermanentId);
        }
        newBluePrint.setCopy(true, copyFromPermanent.getCopyFrom() != null ? copyFromPermanent.getCopyFrom() : copyFromPermanent);
        CopyEffect newCopyEffect = new CopyEffect(duration, newBluePrint, copyToPermanentId);
        newCopyEffect.setApplier(applier);
        Ability ability = source.copy();
        newCopyEffect.init(ability, this);
        if (duration == Duration.Custom) {
            for (Effect effect : this.getState().getContinuousEffects().getLayeredEffects(this)) {
                CopyEffect copyEffect;
                if (!(effect instanceof CopyEffect) || !(copyEffect = (CopyEffect)effect).getSourceId().equals(copyToPermanentId) || copyEffect.getDuration() != Duration.Custom) continue;
                copyEffect.discard();
            }
        }
        this.state.addEffect(newCopyEffect, ability);
        return newBluePrint;
    }

    @Override
    public Card copyCard(Card cardToCopy, Ability source, UUID newController) {
        return this.state.copyCard(cardToCopy, newController, this);
    }

    @Override
    public void addTriggeredAbility(TriggeredAbility ability, GameEvent triggeringEvent) {
        if (ability.getControllerId() == null) {
            MageObject mageObject;
            String sourceName = "no sourceId";
            if (ability.getSourceId() != null && (mageObject = this.getObject(ability.getSourceId())) != null) {
                sourceName = mageObject.getName();
            }
            logger.fatal((Object)("Added triggered ability without controller: " + sourceName + " rule: " + ability.getRule()));
            return;
        }
        if (ability instanceof TriggeredManaAbility || ability instanceof DelayedTriggeredManaAbility) {
            TriggeredAbility manaAbility = ability.copy();
            manaAbility.initSourceObjectZoneChangeCounter(this, false);
            if (manaAbility.activate(this, false)) {
                manaAbility.resolve(this);
            }
        } else {
            TriggeredAbility newAbility = ability.copy();
            newAbility.newId();
            newAbility.initSourceObjectZoneChangeCounter(this, false);
            if (!(newAbility instanceof DelayedTriggeredAbility)) {
                newAbility.setSourcePermanentTransformCount(this);
            }
            newAbility.setTriggerEvent(triggeringEvent);
            this.state.addTriggeredAbility(newAbility);
        }
    }

    @Override
    public UUID addDelayedTriggeredAbility(DelayedTriggeredAbility delayedAbility, Ability source) {
        if (source != null) {
            delayedAbility.setSourceId(source.getSourceId());
            delayedAbility.setControllerId(source.getControllerId());
        }
        DelayedTriggeredAbility newAbility = delayedAbility.copy();
        newAbility.newId();
        if (source != null) {
            int zcc = source.getStackMomentSourceZCC();
            if (zcc == 0) {
                zcc = this.getState().getZoneChangeCounter(source.getSourceId());
            }
            newAbility.setSourceObjectZoneChangeCounter(zcc);
            newAbility.setSourcePermanentTransformCount(this);
        }
        newAbility.init(this);
        this.getState().addDelayedTriggeredAbility(newAbility);
        return newAbility.getId();
    }

    @Override
    public UUID fireReflexiveTriggeredAbility(ReflexiveTriggeredAbility reflexiveAbility, Ability source) {
        return this.fireReflexiveTriggeredAbility(reflexiveAbility, source, false);
    }

    @Override
    public UUID fireReflexiveTriggeredAbility(ReflexiveTriggeredAbility reflexiveAbility, Ability source, boolean fireAsSimultaneousEvent) {
        UUID uuid = this.addDelayedTriggeredAbility(reflexiveAbility, source);
        GameEvent event = GameEvent.getEvent(GameEvent.EventType.OPTION_USED, source.getOriginalId(), source, source.getControllerId());
        if (fireAsSimultaneousEvent) {
            this.getState().addSimultaneousEvent(event, this);
        } else {
            this.fireEvent(event);
        }
        return uuid;
    }

    @Override
    public boolean checkStateAndTriggered() {
        boolean somethingHappened = false;
        while (!this.isPaused() && !this.checkIfGameIsOver()) {
            if (!this.checkStateBasedActions()) {
                this.state.handleSimultaneousEvent(this);
                if (this.isPaused() || this.checkIfGameIsOver() || this.getTurn().isEndTurnRequested() || !this.checkTriggered()) break;
            }
            this.processAction();
            somethingHappened = true;
        }
        this.checkConcede();
        return somethingHappened;
    }

    boolean checkTriggered() {
        boolean played = false;
        this.state.getTriggers().checkStateTriggers(this);
        block0: for (UUID playerId : this.state.getPlayerList(this.state.getActivePlayerId())) {
            List<TriggeredAbility> abilities;
            Player player = this.getPlayer(playerId);
            while (player.canRespond() && !(abilities = this.state.getTriggered(player.getId())).isEmpty()) {
                Iterator<TriggeredAbility> it = abilities.iterator();
                while (it.hasNext()) {
                    TriggeredAbility triggeredAbility = it.next();
                    if (triggeredAbility.isUsesStack()) continue;
                    this.state.removeTriggeredAbility(triggeredAbility);
                    played |= player.triggerAbility(triggeredAbility, this);
                    it.remove();
                }
                if (abilities.isEmpty()) continue block0;
                if (abilities.size() == 1) {
                    this.state.removeTriggeredAbility(abilities.get(0));
                    played |= player.triggerAbility(abilities.get(0), this);
                    continue;
                }
                TriggeredAbility ability = player.chooseTriggeredAbility(abilities, this);
                if (ability == null) continue;
                this.state.removeTriggeredAbility(ability);
                played |= player.triggerAbility(ability, this);
            }
        }
        return played;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean checkStateBasedActions() {
        somethingHappened = false;
        for (Object player : this.state.getPlayers().values()) {
            if (player.hasLost() || (player.getLife() > 0 || !player.canLoseByZeroOrLessLife()) && !player.getLibrary().isEmptyDraw() && player.getCountersCount(CounterType.POISON) < 10) continue;
            player.lost(this);
        }
        dungeonsToRemove = new HashSet<Dungeon>();
        for (CommandObject commandObject : this.state.getCommand()) {
            if (!(commandObject instanceof Dungeon)) continue;
            dungeon = (Dungeon)commandObject;
            if (dungeon.hasNextRoom()) ** GOTO lbl-1000
            if (!this.getStack().stream().filter((Predicate<StackObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isRoomTrigger(mage.game.stack.StackObject ), (Lmage/game/stack/StackObject;)Z)()).map((Function<StackObject, UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSourceId(), (Lmage/game/stack/StackObject;)Ljava/util/UUID;)()).noneMatch((Predicate<UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/util/UUID;)Z)((UUID)dungeon.getId()))) ** GOTO lbl-1000
            if (this.state.getTriggered(dungeon.getControllerId()).stream().filter((Predicate<TriggeredAbility>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isRoomTrigger(mage.abilities.TriggeredAbility ), (Lmage/abilities/TriggeredAbility;)Z)()).map((Function<TriggeredAbility, UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSourceId(), (Lmage/abilities/TriggeredAbility;)Ljava/util/UUID;)()).noneMatch((Predicate<UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/util/UUID;)Z)((UUID)dungeon.getId()))) {
                v0 = true;
            } else lbl-1000:
            // 3 sources

            {
                v0 = false;
            }
            if (!(removeDungeon = v0)) continue;
            dungeonsToRemove.add(dungeon);
        }
        for (Dungeon dungeon : dungeonsToRemove) {
            this.removeDungeon(dungeon);
            somethingHappened = true;
        }
        for (Player player : this.state.getPlayers().values()) {
            commanderIds = this.getCommandersIds(player, CommanderCardType.COMMANDER_OR_OATHBREAKER, false);
            if (commanderIds.isEmpty()) continue;
            commanders = new HashSet<Card>();
            toMove = new CardsImpl();
            player.getGraveyard().stream().filter((Predicate<UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/util/UUID;)Z)(commanderIds)).map((Function<UUID, Card>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getCard(java.util.UUID ), (Ljava/util/UUID;)Lmage/cards/Card;)((GameImpl)this)).filter((Predicate<Card>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Lmage/cards/Card;)Z)()).forEach((Consumer<Card>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lmage/cards/Card;)V)(commanders));
            commanderIds.stream().map((Function<UUID, Card>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkStateBasedActions$8(java.util.UUID ), (Ljava/util/UUID;)Lmage/cards/Card;)((GameImpl)this)).filter((Predicate<Card>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Lmage/cards/Card;)Z)()).forEach((Consumer<Card>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lmage/cards/Card;)V)(commanders));
            commanders.removeIf((Predicate<Card>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkStateBasedActions$9(mage.cards.Card ), (Lmage/cards/Card;)Z)((GameImpl)this));
            for (Card card : commanders) {
                currentZone = this.getState().getZone(card.getId());
                v1 = currentZoneInfo = currentZone == null ? "(error)" : "(" + currentZone.name() + ")";
                if (player.chooseUse(Outcome.Benefit, "Move " + card.getLogName() + " to the command zone or leave it in current zone " + currentZoneInfo + "?", "You can only make this choice once per object", "Move to command", "Leave in current zone " + currentZoneInfo, null, this)) {
                    toMove.add(card);
                    continue;
                }
                this.state.setCommanderShouldStay(card, this);
            }
            if (toMove.isEmpty()) continue;
            player.moveCards(toMove, Zone.COMMAND, (Ability)null, (Game)this);
            somethingHappened = true;
        }
        allCopiedCards = new HashSet<Card>();
        allCopiedCards.addAll(this.getState().getCopiedCards());
        stateSavedCopiedCards = this.getState().getValues("CopiedCard");
        allCopiedCards.addAll((Collection)stateSavedCopiedCards.values().stream().map((Function<Object, Card>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkStateBasedActions$10(java.lang.Object ), (Ljava/lang/Object;)Lmage/cards/Card;)()).filter((Predicate<Card>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Lmage/cards/Card;)Z)()).collect(Collectors.toList()));
        copiedCardsToRemove = new HashSet<Card>();
        block13: for (Card copiedCard : allCopiedCards) {
            zone = this.state.getZone(copiedCard.getMainCard().getId());
            block0 : switch (1.$SwitchMap$mage$constants$Zone[zone.ordinal()]) {
                case 1: 
                case 2: {
                    continue block13;
                }
                case 3: {
                    object = this.getStack().getStackObject(copiedCard.getId());
                    if (object == null) break;
                    continue block13;
                }
                case 4: {
                    for (Object player : this.getPlayers().values()) {
                        if (!player.getGraveyard().contains(copiedCard.getId())) continue;
                        player.getGraveyard().remove(copiedCard);
                        break block0;
                    }
                    break;
                }
                case 5: {
                    for (Object player : this.getPlayers().values()) {
                        if (!player.getHand().contains(copiedCard.getId())) continue;
                        player.getHand().remove(copiedCard);
                        break block0;
                    }
                    break;
                }
                case 6: {
                    for (Object player : this.getPlayers().values()) {
                        if (player.getLibrary().getCard(copiedCard.getId(), this) == null) continue;
                        player.getLibrary().remove(copiedCard.getId(), this);
                        break block0;
                    }
                    break;
                }
                case 7: {
                    this.getExile().removeCard(copiedCard);
                    break;
                }
            }
            copiedCardsToRemove.add(copiedCard);
        }
        copiedCardsToRemove.forEach((Consumer<Card>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$checkStateBasedActions$11(mage.cards.Card ), (Lmage/cards/Card;)V)((GameImpl)this));
        legendary = new ArrayList<Permanent>();
        worldEnchantment = new ArrayList<Permanent>();
        roleMap = new HashMap<UUID, Map>();
        usePowerInsteadOfToughnessForDamageLethalityFilters = this.getState().getActivePowerInsteadOfToughnessForDamageLethalityFilters();
        for (Permanent perm : this.getBattlefield().getAllActivePermanents()) {
            block113: {
                block112: {
                    if (perm.isCreature(this)) {
                        if (perm.getToughness().getValue() <= 0) {
                            if (this.movePermanentToGraveyardWithInfo(perm)) {
                                somethingHappened = true;
                                continue;
                            }
                        } else {
                            usePowerInsteadOfToughnessForDamageLethality = usePowerInsteadOfToughnessForDamageLethalityFilters.stream().anyMatch((Predicate<FilterCreaturePermanent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkStateBasedActions$12(mage.game.permanent.Permanent mage.filter.common.FilterCreaturePermanent ), (Lmage/filter/common/FilterCreaturePermanent;)Z)((GameImpl)this, (Permanent)perm));
                            v2 = lethalDamageThreshold = usePowerInsteadOfToughnessForDamageLethality != false ? Math.max(perm.getPower().getValue(), 1) : perm.getToughness().getValue();
                            if ((lethalDamageThreshold <= perm.getDamage() || perm.isDeathtouched()) && perm.destroy(null, this, false)) {
                                somethingHappened = true;
                                continue;
                            }
                        }
                        if (!(perm.getPairedCard() == null || (paired = perm.getPairedCard().getPermanent(this)) != null && perm.isControlledBy(paired.getControllerId()) && paired.getPairedCard() != null)) {
                            perm.setPairedCard(null);
                            if (paired != null && paired.getPairedCard() != null) {
                                paired.setPairedCard(null);
                            }
                            somethingHappened = true;
                        }
                        if (perm.getBandedCards() != null && !perm.getBandedCards().isEmpty()) {
                            for (UUID bandedId : new ArrayList<UUID>(perm.getBandedCards())) {
                                banded = this.getPermanent(bandedId);
                                if (banded != null && perm.isControlledBy(banded.getControllerId()) && banded.getBandedCards().contains(perm.getId())) continue;
                                perm.removeBandedCard(bandedId);
                                if (banded != null && banded.getBandedCards().contains(perm.getId())) {
                                    banded.removeBandedCard(perm.getId());
                                }
                                somethingHappened = true;
                            }
                        }
                    } else if (perm.getPairedCard() != null) {
                        paired = perm.getPairedCard().getPermanent(this);
                        perm.setPairedCard(null);
                        if (paired != null) {
                            paired.setPairedCard(null);
                        }
                        somethingHappened = true;
                    } else if (perm.getBandedCards() != null && !perm.getBandedCards().isEmpty()) {
                        perm.clearBandedCards();
                        for (UUID bandedId : perm.getBandedCards()) {
                            banded = this.getPermanent(bandedId);
                            if (banded != null) {
                                banded.removeBandedCard(perm.getId());
                            }
                            somethingHappened = true;
                        }
                    }
                    if (perm.isPlaneswalker(this) && perm.getCounters(this).getCount(CounterType.LOYALTY) == 0 && this.movePermanentToGraveyardWithInfo(perm)) {
                        somethingHappened = true;
                        continue;
                    }
                    if (perm.isWorld(this)) {
                        worldEnchantment.add(perm);
                    }
                    if (perm.hasSubtype(SubType.AURA, this)) {
                        if (perm.getAttachedTo() == null) {
                            if (!perm.isCreature(this) && !perm.getAbilities(this).containsClass(BestowAbility.class) && this.movePermanentToGraveyardWithInfo(perm)) {
                                somethingHappened = true;
                            }
                        } else {
                            spellAbility = perm.getSpellAbility();
                            if (spellAbility == null && !perm.getAbilities().isEmpty()) {
                                spellAbility = (Ability)perm.getAbilities().get(0);
                            }
                            if (spellAbility.getTargets().isEmpty()) {
                                for (Ability ability : perm.getAbilities(this)) {
                                    if (!(ability instanceof SpellAbility) || SpellAbilityType.BASE_ALTERNATE != ((SpellAbility)ability).getSpellAbilityType() || ability.getTargets().isEmpty()) continue;
                                    spellAbility = ability;
                                    break;
                                }
                            }
                            if (spellAbility.getTargets().isEmpty()) {
                                enchanted = this.getPermanent(perm.getAttachedTo());
                                GameImpl.logger.error((Object)("Aura without target: " + perm.getName() + " attached to " + (enchanted == null ? " null" : enchanted.getName())));
                            } else {
                                target = (Target)spellAbility.getTargets().get(0);
                                if (target instanceof TargetPermanent) {
                                    attachedTo = this.getPermanent(perm.getAttachedTo());
                                    if (attachedTo == null || !attachedTo.getAttachments().contains(perm.getId())) {
                                        if (perm.getAbilities().stream().anyMatch((Predicate<Ability>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkStateBasedActions$13(mage.abilities.Ability ), (Lmage/abilities/Ability;)Z)())) {
                                            wasAttachedTo = perm.getAttachedTo();
                                            perm.unattach(this);
                                            this.fireEvent(new UnattachedEvent(wasAttachedTo, perm.getId(), perm, null));
                                        } else if (this.movePermanentToGraveyardWithInfo(perm)) {
                                            somethingHappened = true;
                                        }
                                    } else {
                                        auraFilter = ((Target)spellAbility.getTargets().get(0)).getFilter();
                                        if (auraFilter instanceof FilterPermanent) {
                                            if (!((FilterPermanent)auraFilter).match((Permanent)attachedTo, perm.getControllerId(), (Ability)perm.getSpellAbility(), (Game)this) || attachedTo.cantBeAttachedBy(perm, null, this, true)) {
                                                if (perm.getAbilities().stream().anyMatch((Predicate<Ability>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkStateBasedActions$14(mage.abilities.Ability ), (Lmage/abilities/Ability;)Z)())) {
                                                    wasAttachedTo = perm.getAttachedTo();
                                                    perm.unattach(this);
                                                    this.fireEvent(new UnattachedEvent(wasAttachedTo, perm.getId(), perm, null));
                                                } else if (this.movePermanentToGraveyardWithInfo(perm)) {
                                                    somethingHappened = true;
                                                }
                                            }
                                        } else if (!auraFilter.match(attachedTo, this) || attachedTo.cantBeAttachedBy(perm, null, this, true)) {
                                            if (perm.getAbilities().stream().anyMatch((Predicate<Ability>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkStateBasedActions$15(mage.abilities.Ability ), (Lmage/abilities/Ability;)Z)())) {
                                                wasAttachedTo = perm.getAttachedTo();
                                                perm.unattach(this);
                                                this.fireEvent(new UnattachedEvent(wasAttachedTo, perm.getId(), perm, null));
                                            } else if (this.movePermanentToGraveyardWithInfo(perm)) {
                                                somethingHappened = true;
                                            }
                                        }
                                    }
                                } else if (target instanceof TargetPlayer) {
                                    attachedToPlayer = this.getPlayer(perm.getAttachedTo());
                                    if (attachedToPlayer == null || attachedToPlayer.hasLost()) {
                                        if (this.movePermanentToGraveyardWithInfo(perm)) {
                                            somethingHappened = true;
                                        }
                                    } else {
                                        auraFilter = ((Target)spellAbility.getTargets().get(0)).getFilter();
                                        if ((!auraFilter.match(attachedToPlayer, this) || attachedToPlayer.hasProtectionFrom(perm, this)) && this.movePermanentToGraveyardWithInfo(perm)) {
                                            somethingHappened = true;
                                        }
                                    }
                                } else if (target instanceof TargetCard && ((attachedTo = this.getCard(perm.getAttachedTo())) == null || !((Target)spellAbility.getTargets().get(0)).canTarget(perm.getControllerId(), perm.getAttachedTo(), spellAbility, this)) && this.movePermanentToGraveyardWithInfo(perm)) {
                                    if (attachedTo != null) {
                                        attachedTo.removeAttachment(perm.getId(), null, this);
                                    }
                                    somethingHappened = true;
                                }
                            }
                        }
                        if (perm.hasSubtype(SubType.ROLE, this) && this.state.getZone(perm.getId()) == Zone.BATTLEFIELD) {
                            roleMap.computeIfAbsent(perm.getControllerId(), (Function<UUID, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkStateBasedActions$16(java.util.UUID ), (Ljava/util/UUID;)Ljava/util/Map;)()).computeIfAbsent(perm.getAttachedTo(), (Function<UUID, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkStateBasedActions$17(java.util.UUID ), (Ljava/util/UUID;)Ljava/util/Set;)()).add(perm);
                        }
                    }
                    if (!perm.hasSubtype(SubType.SAGA, this) || !perm.getAbilities(this).containsClass(SagaAbility.class)) break block112;
                    maxChapter = perm.getAbilities(this).stream().filter((Predicate<Ability>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lmage/abilities/Ability;)Z)(SagaAbility.class)).map((Function<Ability, SagaAbility>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Lmage/abilities/Ability;)Lmage/abilities/common/SagaAbility;)(SagaAbility.class)).map((Function<SagaAbility, SagaChapter>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getMaxChapter(), (Lmage/abilities/common/SagaAbility;)Lmage/constants/SagaChapter;)()).mapToInt((ToIntFunction<SagaChapter>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, getNumber(), (Lmage/constants/SagaChapter;)I)()).max().orElse(0);
                    if (maxChapter > perm.getCounters(this).getCount(CounterType.LORE)) ** GOTO lbl-1000
                    if (!this.getStack().stream().filter((Predicate<StackObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isChapterAbility(mage.game.stack.StackObject ), (Lmage/game/stack/StackObject;)Z)()).map((Function<StackObject, UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSourceId(), (Lmage/game/stack/StackObject;)Ljava/util/UUID;)()).noneMatch((Predicate<UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/util/UUID;)Z)((UUID)perm.getId()))) ** GOTO lbl-1000
                    if (this.state.getTriggered(perm.getControllerId()).stream().filter((Predicate<TriggeredAbility>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isChapterAbility(mage.abilities.TriggeredAbility ), (Lmage/abilities/TriggeredAbility;)Z)()).map((Function<TriggeredAbility, UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSourceId(), (Lmage/abilities/TriggeredAbility;)Ljava/util/UUID;)()).noneMatch((Predicate<UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/util/UUID;)Z)((UUID)perm.getId()))) {
                        v3 = true;
                    } else lbl-1000:
                    // 3 sources

                    {
                        v3 = sacSaga = false;
                    }
                    if (sacSaga) {
                        perm.sacrifice(null, this);
                        somethingHappened = true;
                    }
                }
                if (!perm.isBattle(this)) break block113;
                if (perm.getCounters(this).getCount(CounterType.DEFENSE) != 0) ** GOTO lbl-1000
                if (!this.getStack().stream().filter((Predicate<StackObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lmage/game/stack/StackObject;)Z)(StackAbility.class)).filter((Predicate<StackObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkStateBasedActions$18(mage.game.stack.StackObject ), (Lmage/game/stack/StackObject;)Z)()).map((Function<StackObject, UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSourceId(), (Lmage/game/stack/StackObject;)Ljava/util/UUID;)()).noneMatch((Predicate<UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/util/UUID;)Z)((UUID)perm.getId()))) ** GOTO lbl-1000
                if (this.state.getTriggered(perm.getControllerId()).stream().filter((Predicate<TriggeredAbility>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lmage/abilities/TriggeredAbility;)Z)(TriggeredAbility.class)).map((Function<TriggeredAbility, UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSourceId(), (Lmage/abilities/TriggeredAbility;)Ljava/util/UUID;)()).noneMatch((Predicate<UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/util/UUID;)Z)((UUID)perm.getId()))) {
                    if (this.movePermanentToGraveyardWithInfo(perm)) {
                        somethingHappened = true;
                    }
                } else if (this.getCombat().getGroups().stream().map((Function<CombatGroup, UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getDefenderId(), (Lmage/game/combat/CombatGroup;)Ljava/util/UUID;)()).filter((Predicate<UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Ljava/util/UUID;)Z)()).noneMatch((Predicate<UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/util/UUID;)Z)((UUID)perm.getId())) && this.getPlayer(perm.getProtectorId()) == null || perm.isControlledBy(perm.getProtectorId())) {
                    perm.chooseProtector(this, null);
                    if (this.getPlayer(perm.getProtectorId()) == null) {
                        this.movePermanentToGraveyardWithInfo(perm);
                    }
                    somethingHappened = true;
                }
            }
            if (perm.isLegendary(this) && perm.legendRuleApplies()) {
                legendary.add(perm);
            }
            if (StaticFilters.FILTER_PERMANENT_EQUIPMENT.match(perm, this) && perm.getAttachedTo() != null) {
                attachedTo = this.getPermanent(perm.getAttachedTo());
                if (attachedTo != null) {
                    for (Ability ability : perm.getAbilities(this)) {
                        if (!(ability instanceof AttachableToRestrictedAbility) || ((AttachableToRestrictedAbility)ability).canEquip(attachedTo.getId(), this)) continue;
                        attachedTo = null;
                        break;
                    }
                }
                if (attachedTo == null || !attachedTo.getAttachments().contains(perm.getId())) {
                    wasAttachedTo = perm.getAttachedTo();
                    perm.attachTo(null, null, this);
                    this.fireEvent(new UnattachedEvent(wasAttachedTo, perm.getId(), perm, null));
                } else if ((!attachedTo.isCreature(this) || attachedTo.hasProtectionFrom(perm, this)) && attachedTo.removeAttachment(perm.getId(), null, this)) {
                    somethingHappened = true;
                }
            }
            if (StaticFilters.FILTER_PERMANENT_FORTIFICATION.match(perm, this) && perm.getAttachedTo() != null) {
                land = this.getPermanent(perm.getAttachedTo());
                if (land == null || !land.getAttachments().contains(perm.getId())) {
                    perm.attachTo(null, null, this);
                } else if ((!land.isLand(this) || land.hasProtectionFrom(perm, this)) && land.removeAttachment(perm.getId(), null, this)) {
                    somethingHappened = true;
                }
            }
            if (!perm.getAttachments().isEmpty()) {
                for (UUID attachmentId : perm.getAttachments()) {
                    attachment = this.getPermanent(attachmentId);
                    if (attachment == null || !attachment.isCreature(this) && !attachment.isBattle(this) && (attachment.hasSubtype(SubType.AURA, this) || attachment.hasSubtype(SubType.EQUIPMENT, this) || attachment.hasSubtype(SubType.FORTIFICATION, this)) || !perm.removeAttachment(attachment.getId(), null, this)) continue;
                    somethingHappened = true;
                    break;
                }
            }
            if (perm.getCounters(this).containsKey(CounterType.P1P1) && perm.getCounters(this).containsKey(CounterType.M1M1)) {
                p1p1 = perm.getCounters(this).getCount(CounterType.P1P1);
                m1m1 = perm.getCounters(this).getCount(CounterType.M1M1);
                min = Math.min(p1p1, m1m1);
                perm.getCounters(this).removeCounter(CounterType.P1P1, min);
                perm.getCounters(this).removeCounter(CounterType.M1M1, min);
            }
            for (Ability ability : perm.getAbilities(this)) {
                if (!(ability instanceof CantHaveMoreThanAmountCountersSourceAbility)) continue;
                counterAbility = (CantHaveMoreThanAmountCountersSourceAbility)ability;
                count = perm.getCounters(this).getCount(counterAbility.getCounterType());
                if (count <= counterAbility.getAmount()) continue;
                perm.removeCounters(counterAbility.getCounterType().getName(), count - counterAbility.getAmount(), counterAbility, this);
                somethingHappened = true;
            }
            if (!perm.getAbilities(this).containsClass(StartYourEnginesAbility.class)) continue;
            Optional.ofNullable(perm.getControllerId()).map((Function<UUID, Player>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPlayer(java.util.UUID ), (Ljava/util/UUID;)Lmage/players/Player;)((GameImpl)this)).ifPresent((Consumer<Player>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$checkStateBasedActions$19(mage.players.Player ), (Lmage/players/Player;)V)((GameImpl)this));
        }
        if (legendary.size() > 1) {
            for (Permanent legend : legendary) {
                filterLegendName = new FilterPermanent();
                filterLegendName.add(SuperType.LEGENDARY.getPredicate());
                filterLegendName.add(new NamePredicate(legend.getName()));
                filterLegendName.add(new ControllerIdPredicate(legend.getControllerId()));
                filterLegendName.add(LegendRuleAppliesPredicate.instance);
                if (!this.getBattlefield().contains(filterLegendName, legend.getControllerId(), null, this, 2) || (controller = this.getPlayer(legend.getControllerId())) == null) continue;
                targetLegendaryToKeep = new TargetPermanent(filterLegendName);
                targetLegendaryToKeep.withNotTarget(true);
                targetLegendaryToKeep.withTargetName(legend.getName() + " to keep (Legendary Rule)?");
                controller.choose(Outcome.Benefit, targetLegendaryToKeep, null, this);
                for (Permanent dupLegend : this.getBattlefield().getActivePermanents(filterLegendName, legend.getControllerId(), this)) {
                    if (targetLegendaryToKeep.getTargets().contains(dupLegend.getId())) continue;
                    this.movePermanentToGraveyardWithInfo(dupLegend);
                }
                return true;
            }
        }
        if (worldEnchantment.size() > 1) {
            newestCard = -1;
            controllerIdOfNewest = new HashSet<E>();
            newestPermanent = null;
            for (Permanent permanent : worldEnchantment) {
                if (newestCard == -1) {
                    newestCard = permanent.getCreateOrder();
                    newestPermanent = permanent;
                    controllerIdOfNewest.clear();
                    controllerIdOfNewest.add(permanent.getControllerId());
                    continue;
                }
                if (newestCard < permanent.getCreateOrder()) {
                    newestCard = permanent.getCreateOrder();
                    newestPermanent = permanent;
                    controllerIdOfNewest.clear();
                    controllerIdOfNewest.add(permanent.getControllerId());
                    continue;
                }
                if (newestCard != permanent.getCreateOrder()) continue;
                newestPermanent = null;
                controllerIdOfNewest.add(permanent.getControllerId());
            }
            controller = controllerIdOfNewest.iterator();
            while (controller.hasNext()) {
                controllerId = (UUID)controller.next();
                newestPermanentControllerRange = this.state.getPlayersInRange(controllerId, this);
                for (Permanent permanent : worldEnchantment) {
                    if (!newestPermanentControllerRange.contains(permanent.getControllerId()) || Objects.equals(newestPermanent, permanent)) continue;
                    this.movePermanentToGraveyardWithInfo(permanent);
                    somethingHappened = true;
                }
            }
        }
        if (!roleMap.isEmpty() && !(rolesToHandle = roleMap.values().stream().map((Function<Map, Collection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, values(), (Ljava/util/Map;)Ljava/util/Collection;)()).flatMap((Function<Collection, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(), (Ljava/util/Collection;)Ljava/util/stream/Stream;)()).filter((Predicate<Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkStateBasedActions$20(java.util.Set ), (Ljava/util/Set;)Z)()).collect(Collectors.toList())).isEmpty()) {
            for (Set roleSet : rolesToHandle) {
                newest = roleSet.stream().mapToInt((ToIntFunction<Permanent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, getCreateOrder(), (Lmage/game/permanent/Permanent;)I)()).max().orElse(-1);
                roleSet.removeIf((Predicate<Permanent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkStateBasedActions$21(int mage.game.permanent.Permanent ), (Lmage/game/permanent/Permanent;)Z)((int)newest));
                for (Permanent permanent : roleSet) {
                    this.movePermanentToGraveyardWithInfo(permanent);
                    somethingHappened = true;
                }
            }
        }
        if (this.hasDayNight()) {
            for (Permanent permanent : this.getBattlefield().getAllActivePermanents()) {
                if ((!permanent.getAbilities(this).containsClass(DayboundAbility.class) || this.state.isDaytime()) && (!permanent.getAbilities(this).containsClass(NightboundAbility.class) || !this.state.isDaytime())) continue;
                somethingHappened = permanent.transform(null, this, true) != false || somethingHappened != false;
            }
        }
        return somethingHappened;
    }

    private boolean movePermanentToGraveyardWithInfo(Permanent permanent) {
        boolean result = false;
        if (permanent.moveToZone(Zone.GRAVEYARD, null, this, false)) {
            if (!this.isSimulation()) {
                this.informPlayers(permanent.getLogName() + " is put into graveyard from battlefield");
            }
            result = true;
        }
        return result;
    }

    @Override
    public void addPlayerQueryEventListener(Listener<PlayerQueryEvent> listener) {
        this.playerQueryEventSource.addListener(listener);
    }

    @Override
    public synchronized void firePriorityEvent(UUID playerId) {
        if (this.simulation) {
            return;
        }
        String message = this.canPlaySorcery(playerId) ? "Play spells and abilities" : "Play instants and activated abilities";
        message = message + this.getControllingPlayerHint(playerId);
        Player player = this.getPlayer(playerId);
        this.playerQueryEventSource.select(player.getTurnControlledBy(), message);
        this.getState().clearLookedAt();
        this.getState().clearRevealed();
    }

    private String getControllingPlayerHint(UUID playerId) {
        Player controllingPlayer;
        Player player = this.getPlayer(playerId);
        if (player != (controllingPlayer = this.getPlayer(player.getTurnControlledBy()))) {
            return " (as " + player.getLogName() + ")";
        }
        return "";
    }

    @Override
    public synchronized void fireSelectEvent(UUID playerId, String message) {
        if (this.simulation) {
            return;
        }
        this.playerQueryEventSource.select(playerId, message + this.getControllingPlayerHint(playerId));
    }

    @Override
    public synchronized void fireSelectEvent(UUID playerId, String message, Map<String, Serializable> options) {
        if (this.simulation) {
            return;
        }
        this.playerQueryEventSource.select(playerId, message + this.getControllingPlayerHint(playerId), options);
    }

    @Override
    public void firePlayManaEvent(UUID playerId, String message, Map<String, Serializable> options) {
        if (this.simulation) {
            return;
        }
        this.playerQueryEventSource.playMana(playerId, message + this.getControllingPlayerHint(playerId), options);
    }

    @Override
    public void firePlayXManaEvent(UUID playerId, String message) {
        if (this.simulation) {
            return;
        }
        this.playerQueryEventSource.playXMana(playerId, message + this.getControllingPlayerHint(playerId));
    }

    @Override
    public void fireAskPlayerEvent(UUID playerId, MessageToClient message, Ability source) {
        this.fireAskPlayerEvent(playerId, message, source, null);
    }

    @Override
    public void fireAskPlayerEvent(UUID playerId, MessageToClient message, Ability source, Map<String, Serializable> options) {
        if (this.simulation) {
            return;
        }
        this.playerQueryEventSource.ask(playerId, message.getMessage() + this.getControllingPlayerHint(playerId), source, this.addMessageToOptions(message, options));
    }

    @Override
    public void fireGetChoiceEvent(UUID playerId, String message, MageObject object, List<? extends ActivatedAbility> choices) {
        if (this.simulation) {
            return;
        }
        String objectName = null;
        if (object != null) {
            objectName = object.getName();
        }
        this.playerQueryEventSource.chooseAbility(playerId, message + this.getControllingPlayerHint(playerId), objectName, choices);
    }

    @Override
    public void fireGetModeEvent(UUID playerId, String message, Map<UUID, String> modes) {
        if (this.simulation) {
            return;
        }
        this.playerQueryEventSource.chooseMode(playerId, message + this.getControllingPlayerHint(playerId), modes);
    }

    @Override
    public void fireSelectTargetEvent(UUID playerId, MessageToClient message, Set<UUID> targets, boolean required, Map<String, Serializable> options) {
        if (this.simulation) {
            return;
        }
        this.playerQueryEventSource.target(playerId, message.getMessage() + this.getControllingPlayerHint(playerId), targets, required, this.addMessageToOptions(message, options));
    }

    @Override
    public void fireSelectTargetEvent(UUID playerId, MessageToClient message, Cards cards, boolean required, Map<String, Serializable> options) {
        if (this.simulation) {
            return;
        }
        this.playerQueryEventSource.target(playerId, message.getMessage() + this.getControllingPlayerHint(playerId), cards, required, this.addMessageToOptions(message, options));
    }

    @Override
    public void fireSelectTargetTriggeredAbilityEvent(UUID playerId, String message, List<TriggeredAbility> abilities) {
        this.playerQueryEventSource.target(playerId, message + this.getControllingPlayerHint(playerId), abilities);
    }

    @Override
    public void fireSelectTargetEvent(UUID playerId, String message, List<Permanent> perms, boolean required) {
        if (this.simulation) {
            return;
        }
        this.playerQueryEventSource.target(playerId, message + this.getControllingPlayerHint(playerId), perms, required);
    }

    @Override
    public void fireGetAmountEvent(UUID playerId, String message, int min, int max) {
        if (this.simulation) {
            return;
        }
        this.playerQueryEventSource.amount(playerId, message + this.getControllingPlayerHint(playerId), min, max);
    }

    @Override
    public void fireGetMultiAmountEvent(UUID playerId, List<MultiAmountMessage> messages, int min, int max, Map<String, Serializable> options) {
        if (this.simulation) {
            return;
        }
        this.playerQueryEventSource.multiAmount(playerId, messages, min, max, options);
    }

    @Override
    public void fireChooseChoiceEvent(UUID playerId, Choice choice) {
        if (this.simulation) {
            return;
        }
        this.playerQueryEventSource.chooseChoice(playerId, choice);
    }

    @Override
    public void fireChoosePileEvent(UUID playerId, String message, List<? extends Card> pile1, List<? extends Card> pile2) {
        if (this.simulation) {
            return;
        }
        this.playerQueryEventSource.choosePile(playerId, message + this.getControllingPlayerHint(playerId), pile1, pile2);
    }

    @Override
    public void informPlayers(String message) {
        DataCollectorServices.getInstance().onGameLog(this, message);
        if (this.simulation) {
            return;
        }
        this.fireInformEvent(message);
    }

    @Override
    public void debugMessage(String message) {
        logger.warn((Object)message);
    }

    @Override
    public void fireInformEvent(String message) {
        if (this.simulation) {
            return;
        }
        this.makeSureCalledOutsideLayerEffects();
        this.tableEventSource.fireTableEvent(TableEvent.EventType.INFO, message, this);
    }

    @Override
    public void fireStatusEvent(String message, boolean withTime, boolean withTurnInfo) {
        if (this.simulation) {
            return;
        }
        this.makeSureCalledOutsideLayerEffects();
        this.tableEventSource.fireTableEvent(TableEvent.EventType.STATUS, message, withTime, withTurnInfo, this);
    }

    @Override
    public void fireUpdatePlayersEvent() {
        if (this.simulation) {
            return;
        }
        this.makeSureCalledOutsideLayerEffects();
        this.tableEventSource.fireTableEvent(TableEvent.EventType.UPDATE, null, this);
        this.getState().clearLookedAt();
        this.getState().clearRevealed();
    }

    @Override
    public void fireGameEndInfo() {
        if (this.simulation) {
            return;
        }
        this.makeSureCalledOutsideLayerEffects();
        this.tableEventSource.fireTableEvent(TableEvent.EventType.END_GAME_INFO, null, this);
    }

    @Override
    public void fireErrorEvent(String message, Exception ex) {
        this.makeSureCalledOutsideLayerEffects();
        this.tableEventSource.fireTableEvent(TableEvent.EventType.ERROR, message, ex, (Game)this);
    }

    private void makeSureCalledOutsideLayerEffects() {
    }

    @Override
    public Players getPlayers() {
        return this.state.getPlayers();
    }

    @Override
    public PlayerList getPlayerList() {
        return this.state.getPlayerList();
    }

    @Override
    public Turn getTurn() {
        return this.state.getTurn();
    }

    @Override
    public PhaseStep getTurnStepType() {
        return this.state.getTurnStepType();
    }

    @Override
    public TurnPhase getTurnPhaseType() {
        return this.state.getTurnPhaseType();
    }

    @Override
    public Phase getPhase() {
        return this.state.getTurn().getPhase();
    }

    @Override
    public Step getStep() {
        return this.state.getTurn().getStep();
    }

    @Override
    public Battlefield getBattlefield() {
        return this.state.getBattlefield();
    }

    @Override
    public SpellStack getStack() {
        return this.state.getStack();
    }

    @Override
    public Exile getExile() {
        return this.state.getExile();
    }

    @Override
    public Combat getCombat() {
        return this.state.getCombat();
    }

    @Override
    public int getTurnNum() {
        return this.state.getTurnNum();
    }

    @Override
    public boolean isMainPhase() {
        return this.state.getTurnStepType() == PhaseStep.PRECOMBAT_MAIN || this.state.getTurnStepType() == PhaseStep.POSTCOMBAT_MAIN;
    }

    @Override
    public boolean canPlaySorcery(UUID playerId) {
        return this.isMainPhase() && this.isActivePlayer(playerId) && this.getStack().isEmpty();
    }

    protected void leave(UUID playerId) {
        Card card;
        Player player = this.getPlayer(playerId);
        if (player == null || player.hasLeft()) {
            logger.debug((Object)("Player already left " + (player != null ? player.getName() : playerId)));
            return;
        }
        logger.debug((Object)("Start leave game: " + player.getName()));
        player.leave();
        if (this.checkIfGameIsOver()) {
            return;
        }
        HashSet<Permanent> toOutside = new HashSet<Permanent>();
        for (Permanent permanent : this.getBattlefield().getAllPermanents()) {
            if (permanent.isOwnedBy(playerId)) {
                if (permanent.getAttachedTo() != null) {
                    Permanent attachedTo = this.getPermanent(permanent.getAttachedTo());
                    if (attachedTo != null) {
                        attachedTo.removeAttachment(permanent.getId(), null, this);
                    } else {
                        Player attachedToPlayer = this.getPlayer(permanent.getAttachedTo());
                        if (attachedToPlayer != null) {
                            attachedToPlayer.removeAttachment(permanent, null, this);
                        }
                    }
                }
                if (permanent.isCreature(this) && this.getCombat() != null) {
                    permanent.removeFromCombat(this, true);
                }
                toOutside.add(permanent);
                continue;
            }
            if (!permanent.isControlledBy(player.getId())) continue;
            block1: for (ContinuousEffect effect : this.getContinuousEffects().getLayeredEffects(this)) {
                if (!effect.hasLayer(Layer.ControlChangingEffects_2)) continue;
                for (Ability ability : this.getContinuousEffects().getLayeredEffectAbilities(effect)) {
                    if (effect.getTargetPointer().getTargets(this, ability).contains(permanent.getId())) {
                        effect.discard();
                        continue block1;
                    }
                    for (Target target : ability.getTargets()) {
                        for (UUID targetId : target.getTargets()) {
                            if (!targetId.equals(permanent.getId())) continue;
                            effect.discard();
                            continue block1;
                        }
                    }
                }
            }
        }
        for (Card card2 : toOutside) {
            this.rememberLKI(Zone.BATTLEFIELD, card2);
        }
        player.moveCards(toOutside, Zone.OUTSIDE, null, (Game)this);
        List<TriggeredAbility> abilities = this.state.getTriggered(player.getId());
        Iterator<TriggeredAbility> iterator = abilities.iterator();
        while (iterator.hasNext()) {
            TriggeredAbility triggeredAbility = iterator.next();
            if (triggeredAbility.isUsesStack()) continue;
            this.state.removeTriggeredAbility(triggeredAbility);
            player.triggerAbility(triggeredAbility, this);
            iterator.remove();
        }
        this.getState().getContinuousEffects().removeInactiveEffects(this);
        this.getStack().removeIf(object -> object.isControlledBy(playerId));
        this.applyEffects();
        List<Permanent> list = this.getBattlefield().getAllActivePermanents(playerId);
        for (Permanent permanent : list) {
            permanent.moveToExile(null, "", null, this);
        }
        for (ExileZone exile : this.getExile().getExileZones()) {
            Iterator it2 = exile.iterator();
            while (it2.hasNext()) {
                card = this.getCard((UUID)it2.next());
                if (card == null || !card.isOwnedBy(playerId)) continue;
                it2.remove();
            }
        }
        boolean addPlaneAgain = false;
        Iterator it3 = this.getState().getCommand().iterator();
        while (it3.hasNext()) {
            CommandObject obj = (CommandObject)it3.next();
            if (!obj.isControlledBy(playerId)) continue;
            if (obj instanceof Emblem) {
                ((Emblem)obj).discardEffects();
            }
            if (obj instanceof Plane) {
                ((Plane)obj).discardEffects();
                addPlaneAgain = true;
            }
            it3.remove();
        }
        if (addPlaneAgain) {
            boolean addedAgain = false;
            for (Player aplayer : this.state.getPlayers().values()) {
                if (aplayer.hasLeft() || addedAgain) continue;
                addedAgain = true;
                Plane plane = Plane.createRandomPlane();
                plane.setControllerId(aplayer.getId());
                this.addPlane(plane, aplayer.getId());
            }
        }
        Iterator<Map.Entry<UUID, Card>> it2 = this.gameCards.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry<UUID, Card> entry = it2.next();
            card = entry.getValue();
            if (!card.isOwnedBy(playerId)) continue;
            it2.remove();
        }
        this.getContinuousEffects().removeInactiveEffects(this);
        if (playerId.equals(this.getMonarchId())) {
            if (!this.isActivePlayer(playerId) && this.getActivePlayerId() != null) {
                this.setMonarchId(null, this.getActivePlayerId());
            } else {
                Player nextPlayer = this.getPlayerList().getNext(this, true);
                if (nextPlayer != null) {
                    this.setMonarchId(null, nextPlayer.getId());
                }
            }
        }
    }

    @Override
    public UUID getActivePlayerId() {
        return this.state.getActivePlayerId();
    }

    @Override
    public UUID getPriorityPlayerId() {
        if (this.state.getPriorityPlayerId() == null) {
            return this.state.getActivePlayerId();
        }
        return this.state.getPriorityPlayerId();
    }

    @Override
    public void addSimultaneousEvent(GameEvent event) {
        this.state.addSimultaneousEvent(event, this);
    }

    @Override
    public void fireEvent(GameEvent event) {
        this.state.handleEvent(event, this);
    }

    @Override
    public boolean replaceEvent(GameEvent event) {
        return this.state.replaceEvent(event, this);
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability targetAbility) {
        return this.state.replaceEvent(event, targetAbility, this);
    }

    @Override
    public PreventionEffectData preventDamage(GameEvent event, Ability source, Game game, int amountToPrevent) {
        PreventionEffectData result = new PreventionEffectData(amountToPrevent);
        if (!event.getFlag()) {
            return result;
        }
        if (!(event instanceof DamageEvent)) {
            result.setError(true);
            return result;
        }
        DamageEvent damageEvent = (DamageEvent)event;
        PreventDamageEvent preventEvent = new PreventDamageEvent(damageEvent.getTargetId(), damageEvent.getSourceId(), source, source.getControllerId(), damageEvent.getAmount(), damageEvent.isCombatDamage());
        if (game.replaceEvent(preventEvent)) {
            result.setReplaced(true);
            return result;
        }
        if (event.getAmount() > amountToPrevent) {
            result.setPreventedDamage(amountToPrevent);
            damageEvent.setAmount(event.getAmount() - amountToPrevent);
        } else {
            result.setPreventedDamage(event.getAmount());
            damageEvent.setAmount(0);
        }
        if (amountToPrevent != Integer.MAX_VALUE) {
            result.setRemainingAmount(amountToPrevent - result.getPreventedDamage());
        }
        MageObject damageSource = game.getObject(damageEvent.getSourceId());
        MageObject preventionSource = game.getObject(source);
        if (damageSource != null && preventionSource != null) {
            MageObject targetObject = game.getObject(event.getTargetId());
            String targetName = "";
            if (targetObject == null) {
                Player targetPlayer = game.getPlayer(event.getTargetId());
                if (targetPlayer != null) {
                    targetName = targetPlayer.getLogName();
                }
            } else {
                targetName = targetObject.getLogName();
            }
            if (!game.isSimulation()) {
                StringBuilder message = new StringBuilder(preventionSource.getLogName()).append(": Prevented ");
                message.append(result.getPreventedDamage()).append(" damage from ").append(damageSource.getLogName());
                if (!targetName.isEmpty()) {
                    message.append(" to ").append(targetName);
                }
                game.informPlayers(message.toString());
            }
        }
        game.fireEvent(new PreventedDamageEvent(damageEvent.getTargetId(), source.getSourceId(), source, source.getControllerId(), result.getPreventedDamage()));
        return result;
    }

    @Override
    public ContinuousEffects getContinuousEffects() {
        return this.state.getContinuousEffects();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.savedStates = new Stack();
        this.tableEventSource = new TableEventSource();
        this.playerQueryEventSource = new PlayerQueryEventSource();
        this.gameStates = new GameStates();
    }

    @Override
    public MageObject getLastKnownInformation(UUID objectId, Zone zone) {
        Map<UUID, MageObject> lkiMap = this.lki.get((Object)zone);
        if (lkiMap != null) {
            MageObject object = lkiMap.get(objectId);
            if (object != null) {
                return object.copy();
            }
            for (MageObject mageObject : lkiMap.values()) {
                if (!(mageObject instanceof Spell) || !((Spell)mageObject).getCard().getId().equals(objectId)) continue;
                return mageObject;
            }
        }
        return null;
    }

    @Override
    public MageObject getLastKnownInformation(UUID objectId, Zone zone, int zoneChangeCounter) {
        MageObject object;
        Map<Integer, MageObject> lkiMapExtended;
        if (zone == Zone.BATTLEFIELD && (lkiMapExtended = this.lkiExtended.get(objectId)) != null && (object = lkiMapExtended.get(zoneChangeCounter)) != null) {
            return object.copy();
        }
        return this.getLastKnownInformation(objectId, zone);
    }

    @Override
    public CardState getLastKnownInformationCard(UUID objectId, Zone zone) {
        Map<UUID, CardState> lkiCardStateMap;
        if (zone.isPublicZone() && (lkiCardStateMap = this.lkiCardState.get((Object)zone)) != null) {
            CardState cardState = lkiCardStateMap.get(objectId);
            return cardState;
        }
        return null;
    }

    @Override
    public boolean checkShortLivingLKI(UUID objectId, Zone zone) {
        Set<UUID> idSet = this.lkiShortLiving.get((Object)zone);
        if (idSet != null) {
            return idSet.contains(objectId);
        }
        return false;
    }

    @Override
    public void rememberLKI(Zone zone, MageObject object) {
        UUID objectId = object.getId();
        if (object instanceof Permanent || object instanceof StackObject) {
            MageObject copy = object.copy();
            Map lkiMap = this.lki.computeIfAbsent(zone, k -> new HashMap());
            lkiMap.put(objectId, copy);
            Set idSet = this.lkiShortLiving.computeIfAbsent(zone, k -> new HashSet());
            idSet.add(objectId);
            if (object instanceof Permanent) {
                Map lkiExtendedMap = this.lkiExtended.computeIfAbsent(objectId, k -> new HashMap());
                lkiExtendedMap.put(object.getZoneChangeCounter(this), copy);
            }
        } else if (zone.isPublicZone()) {
            CardUtil.getObjectParts(object).forEach(partId -> {
                Map lkiMap = this.lkiCardState.computeIfAbsent(zone, k -> new HashMap());
                lkiMap.put(partId, this.getState().getCardState((UUID)partId).copy());
            });
        }
    }

    @Override
    public void resetLKI() {
        this.lki.clear();
        this.lkiExtended.clear();
        this.lkiCardState.clear();
        this.infiniteLoopCounter = 0;
        this.stackObjectsCheck.clear();
    }

    @Override
    public void resetShortLivingLKI() {
        this.lkiShortLiving.clear();
        this.targetedMap.clear();
    }

    @Override
    public StackObject findTargetingStackObject(String checkingReference, GameEvent event) {
        HashMap<UUID, Set> targetMap = this.targetedMap.getOrDefault(checkingReference, null);
        targetMap = targetMap == null ? new HashMap<UUID, Set>() : new HashMap(targetMap);
        Set targetingObjects = targetMap.computeIfAbsent(event.getTargetId(), k -> new HashSet());
        for (StackObject stackObject : this.getStack()) {
            Ability stackAbility = stackObject.getStackAbility();
            if (stackAbility == null || !stackAbility.getSourceId().equals(event.getSourceId()) || !CardUtil.getAllSelectedTargets(stackAbility, this).contains(event.getTargetId()) || !targetingObjects.add(stackObject.getId())) continue;
            targetMap.put(event.getTargetId(), targetingObjects);
            this.targetedMap.put(checkingReference, targetMap);
            return stackObject;
        }
        return null;
    }

    @Override
    public int getTotalErrorsCount() {
        return this.totalErrorsCount.get();
    }

    @Override
    public int getTotalEffectsCount() {
        return this.getContinuousEffects().getTotalEffectsCount();
    }

    @Override
    public void cheat(UUID ownerId, Map<Zone, String> commands) {
        Player player;
        if (commands != null && (player = this.getPlayer(ownerId)) != null) {
            for (Map.Entry<Zone, String> command : commands.entrySet()) {
                switch (command.getKey()) {
                    case HAND: {
                        if (!command.getValue().equals("clear")) break;
                        player.getHand().clear();
                        break;
                    }
                    case LIBRARY: {
                        if (!command.getValue().equals("clear")) break;
                        player.getLibrary().clear();
                        break;
                    }
                    case OUTSIDE: {
                        String[] s;
                        if (!command.getValue().contains("life:") || (s = command.getValue().split(":")).length != 2) break;
                        int amount = Integer.parseInt(s[1]);
                        player.setLife(amount, this, null);
                    }
                }
            }
        }
    }

    @Override
    public Map<Zone, Map<UUID, MageObject>> getLKI() {
        return this.lki;
    }

    @Override
    public Map<MageObjectReference, Map<String, Object>> getPermanentCostsTags() {
        return this.state.getPermanentCostsTags();
    }

    @Override
    public void storePermanentCostsTags(MageObjectReference permanentMOR, Ability source) {
        this.state.storePermanentCostsTags(permanentMOR, source);
    }

    @Override
    public void cheat(UUID ownerId, List<Card> library, List<Card> hand, List<PutToBattlefieldInfo> battlefield, List<Card> graveyard, List<Card> command, List<Card> exiled) {
        SimpleStaticAbility fakeSourceAbilityTemplate = new SimpleStaticAbility(Zone.OUTSIDE, new InfoEffect("fake ability"));
        fakeSourceAbilityTemplate.setControllerId(ownerId);
        Player player = this.getPlayer(ownerId);
        if (player != null) {
            this.loadCards(ownerId, library);
            this.loadCards(ownerId, hand);
            this.loadCards(ownerId, battlefield.stream().map(PutToBattlefieldInfo::getCard).collect(Collectors.toList()));
            this.loadCards(ownerId, graveyard);
            this.loadCards(ownerId, command);
            this.loadCards(ownerId, exiled);
            for (Card card : library) {
                player.getLibrary().putOnTop(card, this);
            }
            for (Card card : hand) {
                card.setZone(Zone.HAND, this);
                player.getHand().add(card);
            }
            for (Card card : graveyard) {
                card.setZone(Zone.GRAVEYARD, this);
                player.getGraveyard().add(card);
            }
            if (this instanceof GameCommanderImpl) {
                for (Card card : command) {
                    ((GameCommanderImpl)this).addCommander(card, player);
                }
            } else if (!command.isEmpty()) {
                throw new IllegalArgumentException("Command zone supports in commander test games");
            }
            for (Card card : exiled) {
                card.setZone(Zone.EXILED, this);
                this.getExile().add(card);
            }
            for (PutToBattlefieldInfo info : battlefield) {
                Ability fakeSourceAbility = fakeSourceAbilityTemplate.copy();
                fakeSourceAbility.setSourceId(info.getCard().getId());
                CardUtil.putCardOntoBattlefieldWithEffects(fakeSourceAbility, this, info.getCard(), player, info.isTapped());
            }
            this.applyEffects();
        }
    }

    private void loadCards(UUID ownerId, List<? extends Card> cards) {
        if (cards == null) {
            return;
        }
        HashSet<Card> set = new HashSet<Card>(cards);
        this.loadCards(set, ownerId);
    }

    @Override
    public boolean endTurn(Ability source) {
        this.getTurn().endTurn(this, source);
        return true;
    }

    @Override
    public Date getStartTime() {
        if (this.startTime == null) {
            return null;
        }
        return new Date(this.startTime.getTime());
    }

    @Override
    public Date getEndTime() {
        if (this.endTime == null) {
            return null;
        }
        return new Date(this.endTime.getTime());
    }

    @Override
    public void setGameOptions(GameOptions options) {
        this.gameOptions = options;
    }

    @Override
    public void setLosingPlayer(Player player) {
        this.losingPlayer = player;
    }

    @Override
    public Player getLosingPlayer() {
        return this.losingPlayer;
    }

    @Override
    public void informPlayer(Player player, String message) {
        if (this.simulation) {
            return;
        }
        this.playerQueryEventSource.informPlayer(player.getId(), message);
    }

    @Override
    public void setScopeRelevant(boolean scopeRelevant) {
        this.scopeRelevant = scopeRelevant;
    }

    @Override
    public boolean getScopeRelevant() {
        return this.scopeRelevant;
    }

    @Override
    public boolean isSaveGame() {
        return this.saveGame;
    }

    @Override
    public void setSaveGame(boolean saveGame) {
        this.saveGame = saveGame;
    }

    public void setStartMessage(String startMessage) {
        this.startMessage = startMessage;
    }

    @Override
    public void initTimer(UUID playerId) {
        if (this.priorityTime > 0) {
            this.makeSureCalledOutsideLayerEffects();
            this.tableEventSource.fireTableEvent(TableEvent.EventType.INIT_TIMER, playerId, null, (Game)this);
        }
    }

    @Override
    public void resumeTimer(UUID playerId) {
        if (this.priorityTime > 0) {
            this.makeSureCalledOutsideLayerEffects();
            this.tableEventSource.fireTableEvent(TableEvent.EventType.RESUME_TIMER, playerId, null, (Game)this);
        }
    }

    @Override
    public void pauseTimer(UUID playerId) {
        if (this.priorityTime > 0) {
            this.makeSureCalledOutsideLayerEffects();
            this.tableEventSource.fireTableEvent(TableEvent.EventType.PAUSE_TIMER, playerId, null, (Game)this);
        }
    }

    @Override
    public int getPriorityTime() {
        return this.priorityTime;
    }

    @Override
    public void setPriorityTime(int priorityTime) {
        this.priorityTime = priorityTime;
    }

    @Override
    public int getBufferTime() {
        return this.bufferTime;
    }

    @Override
    public void setBufferTime(int bufferTime) {
        this.bufferTime = bufferTime;
    }

    @Override
    public UUID getStartingPlayerId() {
        return this.startingPlayerId;
    }

    @Override
    public void setStartingPlayerId(UUID startingPlayerId) {
        this.startingPlayerId = startingPlayerId;
    }

    @Override
    public int getStartingLife() {
        return this.startingLife;
    }

    @Override
    public void setDraw(UUID playerId) {
        Player player = this.getPlayer(playerId);
        if (player != null) {
            for (UUID playerToSetId : this.getState().getPlayersInRange(playerId, this)) {
                Player playerToDraw = this.getPlayer(playerToSetId);
                if (playerToDraw == null) continue;
                playerToDraw.drew(this);
            }
        }
    }

    @Override
    public void saveRollBackGameState() {
        if (this.gameOptions.rollbackTurnsAllowed) {
            int toDelete = this.getTurnNum() - 4;
            if (toDelete > 0) {
                this.gameStatesRollBack.remove(toDelete);
            }
            this.gameStatesRollBack.put(this.getTurnNum(), this.state.copy());
        }
    }

    @Override
    public boolean canRollbackTurns(int turnsToRollback) {
        int turnToGoTo = this.getTurnNum() - turnsToRollback;
        return turnToGoTo > 0 && this.gameStatesRollBack.containsKey(turnToGoTo);
    }

    private void rollbackTurnsExecution(int turnToGoToForRollback) {
        GameState restore = this.gameStatesRollBack.get(turnToGoToForRollback);
        if (restore != null) {
            this.informPlayers(GameLog.getPlayerRequestColoredText("Player request: Rolling back to start of turn " + restore.getTurnNum()));
            this.state.restoreForRollBack(restore);
            this.playerList.setCurrent(this.state.getPlayerByOrderId());
            this.savedStates.clear();
            this.gameStates.clear();
            this.gameStatesRollBack.put(this.getTurnNum(), this.state.copy());
            for (Player playerObject : this.getPlayers().values()) {
                if (!playerObject.isInGame()) continue;
                playerObject.abortReset();
            }
        }
        this.executingRollback = false;
    }

    @Override
    public synchronized void rollbackTurns(int turnsToRollback) {
        if (this.gameOptions.rollbackTurnsAllowed && !this.executingRollback) {
            int turnToGoTo = this.getTurnNum() - turnsToRollback;
            if (turnToGoTo < 1 || !this.gameStatesRollBack.containsKey(turnToGoTo)) {
                this.informPlayers(GameLog.getPlayerRequestColoredText("Player request: It's not possible to rollback " + turnsToRollback + " turn(s)"));
            } else {
                this.executingRollback = true;
                this.turnToGoToForRollback = turnToGoTo;
                for (Player playerObject : this.getPlayers().values()) {
                    if (!playerObject.isHuman() || !playerObject.canRespond()) continue;
                    playerObject.resetStoredBookmark(this);
                    playerObject.resetPlayerPassedActions();
                    playerObject.abort();
                }
                this.fireUpdatePlayersEvent();
                if (this.gameOptions.testMode && this.gameStopped) {
                    this.rollbackTurnsExecution(this.turnToGoToForRollback);
                }
            }
        }
    }

    @Override
    public boolean executingRollback() {
        return this.executingRollback;
    }

    @Override
    public void setEnterWithCounters(UUID sourceId, Counters counters) {
        if (counters == null) {
            this.enterWithCounters.remove(sourceId);
            return;
        }
        this.enterWithCounters.put(sourceId, counters);
    }

    @Override
    public Counters getEnterWithCounters(UUID sourceId) {
        return this.enterWithCounters.get(sourceId);
    }

    private Map<String, Serializable> addMessageToOptions(MessageToClient message, Map<String, Serializable> options) {
        if (message.getSecondMessage() != null) {
            if (options == null) {
                options = new HashMap<String, Serializable>();
            }
            options.put("secondMessage", (Serializable)((Object)message.getSecondMessage()));
        }
        if (message.getHintText() != null) {
            if (options == null) {
                options = new HashMap<String, Serializable>();
            }
            options.put("hintText", (Serializable)((Object)message.getHintText()));
        }
        return options;
    }

    @Override
    public UUID getMonarchId() {
        return this.getState().getMonarchId();
    }

    @Override
    public void setMonarchId(Ability source, UUID monarchId) {
        Player newMonarch;
        if (monarchId.equals(this.getMonarchId())) {
            return;
        }
        if (this.replaceEvent(GameEvent.getEvent(GameEvent.EventType.BECOME_MONARCH, monarchId, source, monarchId))) {
            return;
        }
        if (this.getMonarchId() == null) {
            this.getState().addDesignation(new Monarch(), this, monarchId);
        }
        if ((newMonarch = this.getPlayer(monarchId)) != null) {
            this.getState().setMonarchId(monarchId);
            this.informPlayers(newMonarch.getLogName() + " is the monarch");
            this.fireEvent(new GameEvent(GameEvent.EventType.BECOMES_MONARCH, monarchId, source, monarchId));
        }
    }

    @Override
    public UUID getInitiativeId() {
        return this.getState().getInitiativeId();
    }

    @Override
    public void takeInitiative(Ability source, UUID initiativeId) {
        if (this.getInitiativeId() == null) {
            this.getState().addDesignation(new Initiative(), this, initiativeId);
        }
        this.getState().setInitiativeId(initiativeId);
        this.informPlayers(this.getPlayer(initiativeId).getLogName() + " takes the initiative");
        this.fireEvent(new GameEvent(GameEvent.EventType.TOOK_INITIATIVE, initiativeId, source, initiativeId));
    }

    @Override
    public int damagePlayerOrPermanent(UUID playerOrPermanent, int damage, UUID attackerId, Ability source, Game game, boolean combatDamage, boolean preventable) {
        return this.damagePlayerOrPermanent(playerOrPermanent, damage, attackerId, source, game, combatDamage, preventable, null);
    }

    @Override
    public int damagePlayerOrPermanent(UUID playerOrPermanent, int damage, UUID attackerId, Ability source, Game game, boolean combatDamage, boolean preventable, List<UUID> appliedEffects) {
        Player player = this.getPlayer(playerOrPermanent);
        if (player != null) {
            return player.damage(damage, attackerId, source, game, combatDamage, preventable, appliedEffects);
        }
        Permanent permanent = this.getPermanent(playerOrPermanent);
        if (permanent != null) {
            return permanent.damage(damage, attackerId, source, game, combatDamage, preventable, appliedEffects);
        }
        return 0;
    }

    @Override
    public Mulligan getMulligan() {
        return this.mulligan;
    }

    @Override
    public Set<UUID> getCommandersIds(Player player, CommanderCardType commanderCardType, boolean returnAllCardParts) {
        Set<UUID> mainCards = player.getCommandersIds();
        return this.filterCommandersBySearchZone(mainCards, returnAllCardParts);
    }

    protected final Set<UUID> filterCommandersBySearchZone(Set<UUID> commanderMainCards, boolean returnAllCardParts) {
        HashSet<UUID> filteredCards = new HashSet<UUID>();
        if (returnAllCardParts) {
            commanderMainCards.stream().map(this::getCard).filter(Objects::nonNull).forEach(card -> filteredCards.addAll(CardUtil.getObjectParts(card)));
        } else {
            filteredCards.addAll(commanderMainCards);
        }
        return filteredCards;
    }

    @Override
    public void setGameStopped(boolean gameStopped) {
        this.gameStopped = gameStopped;
    }

    @Override
    public boolean isGameStopped() {
        return this.gameStopped;
    }

    @Override
    public boolean isTurnOrderReversed() {
        return this.state.getReverseTurnOrder();
    }

    public String toString() {
        Player activePayer = this.getPlayer(this.getActivePlayerId());
        ArrayList<String> simInfo = new ArrayList<String>();
        if (this.simulation) {
            simInfo.add("SIMULATION");
        }
        if (this.aiGame) {
            simInfo.add("AI");
        }
        if (this.checkPlayableState) {
            simInfo.add("PLAYABLE CALC");
        }
        if (!ThreadUtils.isRunGameThread()) {
            simInfo.add("NOT GAME THREAD");
        }
        StringBuilder sb = new StringBuilder().append(!simInfo.isEmpty() ? "!!!" + String.join((CharSequence)", ", simInfo) + "!!! " : "").append(this.getGameType().toString()).append("; ").append(CardUtil.getTurnInfo(this)).append("; active: ").append(activePayer == null ? "none" : activePayer.getName()).append("; stack: ").append(this.getStack().toString()).append(this.getState().isGameOver() ? "; FINISHED: " + this.getWinner() : "");
        return sb.toString();
    }

    @Override
    public UUID getTableId() {
        return this.tableId;
    }

    @Override
    public void setTableId(UUID tableId) {
        this.tableId = tableId;
    }

    private static /* synthetic */ void lambda$makeSureCalledOutsideLayerEffects$22(StackTraceElement e) {
        if (e.toString().contains("GameState.applyEffects")) {
            throw new IllegalStateException("Wrong code usage: client side events can't be called from layers effects (wrong informPlayers usage?)");
        }
    }

    private static /* synthetic */ boolean lambda$checkStateBasedActions$21(int newest, Permanent permanent) {
        return permanent.getCreateOrder() == newest;
    }

    private static /* synthetic */ boolean lambda$checkStateBasedActions$20(Set s) {
        return s.size() > 1;
    }

    private /* synthetic */ void lambda$checkStateBasedActions$19(Player player) {
        player.initSpeed(this);
    }

    private static /* synthetic */ boolean lambda$checkStateBasedActions$18(StackObject stackObject) {
        return stackObject.getStackAbility() instanceof TriggeredAbilityImpl;
    }

    private static /* synthetic */ Set lambda$checkStateBasedActions$17(UUID x) {
        return new HashSet();
    }

    private static /* synthetic */ Map lambda$checkStateBasedActions$16(UUID x) {
        return new HashMap();
    }

    private static /* synthetic */ boolean lambda$checkStateBasedActions$15(Ability x) {
        return x instanceof BestowAbility;
    }

    private static /* synthetic */ boolean lambda$checkStateBasedActions$14(Ability x) {
        return x instanceof BestowAbility;
    }

    private static /* synthetic */ boolean lambda$checkStateBasedActions$13(Ability x) {
        return x instanceof BestowAbility;
    }

    private /* synthetic */ boolean lambda$checkStateBasedActions$12(Permanent perm, FilterCreaturePermanent filter) {
        return filter.match(perm, this);
    }

    private /* synthetic */ void lambda$checkStateBasedActions$11(Card card) {
        card.setZone(Zone.OUTSIDE, this);
        this.getState().getCopiedCards().remove(card);
    }

    private static /* synthetic */ Card lambda$checkStateBasedActions$10(Object object) {
        return (Card)object;
    }

    private /* synthetic */ boolean lambda$checkStateBasedActions$9(Card card) {
        return this.state.checkCommanderShouldStay(card, this);
    }

    private /* synthetic */ Card lambda$checkStateBasedActions$8(UUID uuid) {
        return this.getExile().getCard(uuid, this);
    }

    private static /* synthetic */ String lambda$playPriority$7(StackObject o) {
        return "* " + o.toString();
    }
}

