/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import mage.MageInt;
import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Abilities;
import mage.abilities.AbilitiesImpl;
import mage.abilities.Ability;
import mage.abilities.PlayLandAbility;
import mage.abilities.SpellAbility;
import mage.abilities.common.PlayLandAsCommanderAbility;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.cards.Card;
import mage.cards.FrameStyle;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.command.CommandObject;
import mage.game.command.CommandObjectImpl;
import mage.game.events.ZoneChangeEvent;
import mage.util.SubTypes;

public class Commander
extends CommandObjectImpl {
    private final Card sourceObject;
    private boolean copy;
    private MageObject copyFrom;
    private final Abilities<Ability> abilities = new AbilitiesImpl<Ability>();

    public Commander(Card card) {
        super(card.getName());
        Ability newAbility;
        this.sourceObject = card;
        block4: for (Ability ability : card.getAbilities()) {
            if (!(ability instanceof SpellAbility)) continue;
            SpellAbility spellAbility = (SpellAbility)ability;
            switch (spellAbility.getSpellAbilityType()) {
                case BASE: 
                case BASE_ALTERNATE: 
                case SPLIT: 
                case SPLIT_FUSED: 
                case SPLIT_LEFT: 
                case SPLIT_RIGHT: 
                case MODAL: 
                case MODAL_LEFT: 
                case MODAL_RIGHT: 
                case ADVENTURE_SPELL: {
                    if (!this.canUseAbilityFromCommandZone(spellAbility)) continue block4;
                    this.abilities.add(spellAbility.copyWithZone(Zone.COMMAND));
                    continue block4;
                }
                case SPLICE: 
                case SPLIT_AFTERMATH: {
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Error, unknown spell type in commander card: " + (Object)((Object)spellAbility.getSpellAbilityType()) + " from " + card.getName());
        }
        for (Ability ability : card.getAbilities()) {
            if (!(ability instanceof PlayLandAbility) || !this.canUseAbilityFromCommandZone(ability)) continue;
            newAbility = new PlayLandAsCommanderAbility((PlayLandAbility)ability);
            this.abilities.add(newAbility);
        }
        for (Ability ability : card.getAbilities()) {
            if (ability instanceof SpellAbility || ability instanceof PlayLandAbility) continue;
            newAbility = ability.copy();
            this.abilities.add(newAbility);
        }
    }

    private boolean canUseAbilityFromCommandZone(Ability ability) {
        switch (ability.getZone()) {
            case ALL: 
            case COMMAND: 
            case HAND: {
                return true;
            }
        }
        return false;
    }

    private Commander(Commander commander) {
        super(commander);
        this.sourceObject = commander.sourceObject.copy();
        this.copy = commander.copy;
        this.copyFrom = commander.copyFrom != null ? commander.copyFrom.copy() : null;
        this.abilities.addAll(commander.abilities.copy());
    }

    @Override
    public Card getSourceObject() {
        return this.sourceObject;
    }

    @Override
    public UUID getSourceId() {
        return this.sourceObject.getId();
    }

    @Override
    public UUID getControllerId() {
        return this.sourceObject.getOwnerId();
    }

    @Override
    public UUID getControllerOrOwnerId() {
        return this.getControllerId();
    }

    @Override
    public CommandObject copy() {
        return new Commander(this);
    }

    @Override
    public void setCopy(boolean isCopy, MageObject copyFrom) {
        this.copy = isCopy;
        this.copyFrom = copyFrom != null ? copyFrom.copy() : null;
    }

    @Override
    public boolean isCopy() {
        return this.copy;
    }

    @Override
    public MageObject getCopyFrom() {
        return this.copyFrom;
    }

    @Override
    public String getName() {
        return this.sourceObject.getName();
    }

    @Override
    public String getIdName() {
        return this.sourceObject.getName() + " [" + this.sourceObject.getId().toString().substring(0, 3) + ']';
    }

    @Override
    public List<CardType> getCardType(Game game) {
        return this.sourceObject.getCardType(game);
    }

    @Override
    public SubTypes getSubtype() {
        return this.sourceObject.getSubtype();
    }

    @Override
    public SubTypes getSubtype(Game game) {
        return this.sourceObject.getSubtype(game);
    }

    @Override
    public boolean hasSubtype(SubType subtype, Game game) {
        return this.sourceObject.hasSubtype(subtype, game);
    }

    @Override
    public List<SuperType> getSuperType(Game game) {
        return this.sourceObject.getSuperType(game);
    }

    @Override
    public Abilities<Ability> getAbilities() {
        return this.abilities;
    }

    @Override
    public Abilities<Ability> getInitAbilities() {
        HashSet ignore = new HashSet();
        this.sourceObject.getAbilities().forEach(ability -> ignore.add(ability.getId()));
        AbilitiesImpl<Ability> res = new AbilitiesImpl<Ability>();
        this.getAbilities().stream().filter(ability -> !ignore.contains(ability.getId())).forEach(res::add);
        return res;
    }

    @Override
    public boolean hasAbility(Ability ability, Game game) {
        if (this.getAbilities().contains(ability)) {
            return true;
        }
        Abilities<Ability> otherAbilities = game.getState().getAllOtherAbilities(this.getId());
        return otherAbilities != null && otherAbilities.contains(ability);
    }

    @Override
    public ObjectColor getColor() {
        return this.sourceObject.getColor();
    }

    @Override
    public ObjectColor getColor(Game game) {
        return this.sourceObject.getColor(game);
    }

    @Override
    public ObjectColor getFrameColor(Game game) {
        return this.sourceObject.getFrameColor(game);
    }

    @Override
    public FrameStyle getFrameStyle() {
        return this.sourceObject.getFrameStyle();
    }

    @Override
    public ManaCosts<ManaCost> getManaCost() {
        return this.sourceObject.getManaCost();
    }

    @Override
    public void setManaCost(ManaCosts<ManaCost> costs) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public int getManaValue() {
        return this.sourceObject.getManaValue();
    }

    @Override
    public MageInt getPower() {
        return this.sourceObject.getPower();
    }

    @Override
    public MageInt getToughness() {
        return this.sourceObject.getToughness();
    }

    @Override
    public int getStartingLoyalty() {
        return this.sourceObject.getStartingLoyalty();
    }

    @Override
    public void setStartingLoyalty(int startingLoyalty) {
    }

    @Override
    public int getStartingDefense() {
        return this.sourceObject.getStartingDefense();
    }

    @Override
    public void setStartingDefense(int startingDefense) {
    }

    @Override
    public UUID getId() {
        return this.sourceObject.getId();
    }

    @Override
    public int getZoneChangeCounter(Game game) {
        return this.sourceObject.getZoneChangeCounter(game);
    }

    @Override
    public void updateZoneChangeCounter(Game game, ZoneChangeEvent event) {
        this.sourceObject.updateZoneChangeCounter(game, event);
    }

    @Override
    public void setZoneChangeCounter(int value, Game game) {
        this.sourceObject.setZoneChangeCounter(value, game);
    }

    @Override
    public boolean isAllCreatureTypes(Game game) {
        return this.sourceObject.isAllCreatureTypes(game);
    }

    @Override
    public void setIsAllCreatureTypes(boolean value) {
        this.sourceObject.setIsAllCreatureTypes(value);
    }

    @Override
    public void setIsAllCreatureTypes(Game game, boolean value) {
        this.sourceObject.setIsAllCreatureTypes(game, value);
    }

    @Override
    public boolean isAllNonbasicLandTypes(Game game) {
        return this.sourceObject.isAllNonbasicLandTypes(game);
    }

    @Override
    public void setIsAllNonbasicLandTypes(boolean value) {
        this.sourceObject.setIsAllNonbasicLandTypes(value);
    }

    @Override
    public void setIsAllNonbasicLandTypes(Game game, boolean value) {
        this.sourceObject.setIsAllNonbasicLandTypes(game, value);
    }

    @Override
    public void removePTCDA() {
    }
}

