/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import mage.MageInt;
import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Abilities;
import mage.abilities.AbilitiesImpl;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.cards.FrameStyle;
import mage.cards.repository.TokenInfo;
import mage.cards.repository.TokenRepository;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.command.CommandObjectImpl;
import mage.game.events.ZoneChangeEvent;
import mage.util.SubTypes;

public abstract class Emblem
extends CommandObjectImpl {
    private static final ManaCosts emptyCost = new ManaCostsImpl();
    private UUID controllerId;
    protected MageObject sourceObject;
    private boolean copy;
    private MageObject copyFrom;
    protected FrameStyle frameStyle;
    private Abilities<Ability> abilities = new AbilitiesImpl<Ability>();

    public Emblem(String name) {
        super(name);
    }

    protected Emblem(Emblem emblem) {
        super(emblem);
        this.frameStyle = emblem.frameStyle;
        this.controllerId = emblem.controllerId;
        this.sourceObject = emblem.sourceObject;
        this.copy = emblem.copy;
        this.copyFrom = emblem.copyFrom;
        this.abilities = emblem.abilities.copy();
    }

    @Override
    public FrameStyle getFrameStyle() {
        return this.frameStyle;
    }

    public void setSourceObjectAndInitImage(MageObject sourceObject) {
        this.sourceObject = sourceObject;
        TokenInfo foundInfo = TokenRepository.instance.findPreferredTokenInfoForClass(this.getClass().getName(), this.sourceObject == null ? null : this.sourceObject.getExpansionSetCode());
        if (foundInfo == null) {
            throw new IllegalArgumentException("Wrong code usage: can't find token info for the emblem: " + this.getClass().getName());
        }
        this.setExpansionSetCode(foundInfo.getSetCode());
        this.setUsesVariousArt(false);
        this.setCardNumber("");
        this.setImageFileName("");
        this.setImageNumber(foundInfo.getImageNumber());
    }

    @Override
    public MageObject getSourceObject() {
        return this.sourceObject;
    }

    @Override
    public UUID getSourceId() {
        if (this.sourceObject != null) {
            return this.sourceObject.getId();
        }
        return null;
    }

    @Override
    public UUID getControllerId() {
        return this.controllerId;
    }

    public void setControllerId(UUID controllerId) {
        this.controllerId = controllerId;
        this.abilities.setControllerId(controllerId);
    }

    @Override
    public UUID getControllerOrOwnerId() {
        return this.getControllerId();
    }

    @Override
    public abstract Emblem copy();

    @Override
    public void setCopy(boolean isCopy, MageObject copyFrom) {
        this.copy = isCopy;
        this.copyFrom = copyFrom != null ? copyFrom.copy() : null;
    }

    @Override
    public boolean isCopy() {
        return this.copy;
    }

    @Override
    public MageObject getCopyFrom() {
        return this.copyFrom;
    }

    @Override
    public List<CardType> getCardType(Game game) {
        return Collections.emptyList();
    }

    @Override
    public SubTypes getSubtype() {
        return new SubTypes(new SubType[0]);
    }

    @Override
    public SubTypes getSubtype(Game game) {
        return new SubTypes(new SubType[0]);
    }

    @Override
    public boolean hasSubtype(SubType subtype, Game game) {
        return false;
    }

    @Override
    public List<SuperType> getSuperType(Game game) {
        return Collections.emptyList();
    }

    @Override
    public Abilities<Ability> getAbilities() {
        return this.abilities;
    }

    @Override
    public boolean hasAbility(Ability ability, Game game) {
        return this.getAbilities().contains(ability);
    }

    @Override
    public ObjectColor getColor() {
        return ObjectColor.COLORLESS;
    }

    @Override
    public ObjectColor getColor(Game game) {
        return ObjectColor.COLORLESS;
    }

    @Override
    public ObjectColor getFrameColor(Game game) {
        return ObjectColor.COLORLESS;
    }

    @Override
    public ManaCosts<ManaCost> getManaCost() {
        return emptyCost;
    }

    @Override
    public void setManaCost(ManaCosts<ManaCost> costs) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public int getManaValue() {
        return 0;
    }

    @Override
    public MageInt getPower() {
        return MageInt.EmptyMageInt;
    }

    @Override
    public MageInt getToughness() {
        return MageInt.EmptyMageInt;
    }

    @Override
    public int getStartingLoyalty() {
        return 0;
    }

    @Override
    public void setStartingLoyalty(int startingLoyalty) {
    }

    @Override
    public int getStartingDefense() {
        return 0;
    }

    @Override
    public void setStartingDefense(int startingDefense) {
    }

    @Override
    public int getZoneChangeCounter(Game game) {
        return 1;
    }

    @Override
    public void updateZoneChangeCounter(Game game, ZoneChangeEvent event) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public void setZoneChangeCounter(int value, Game game) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public boolean isAllCreatureTypes(Game game) {
        return false;
    }

    @Override
    public void setIsAllCreatureTypes(boolean value) {
    }

    @Override
    public void setIsAllCreatureTypes(Game game, boolean value) {
    }

    @Override
    public boolean isAllNonbasicLandTypes(Game game) {
        return false;
    }

    @Override
    public void setIsAllNonbasicLandTypes(boolean value) {
    }

    @Override
    public void setIsAllNonbasicLandTypes(Game game, boolean value) {
    }

    public void discardEffects() {
        for (Ability ability : this.abilities) {
            for (Effect effect : ability.getEffects()) {
                if (!(effect instanceof ContinuousEffect)) continue;
                ((ContinuousEffect)effect).discard();
            }
        }
    }

    @Override
    public void removePTCDA() {
    }
}

