/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.command.DungeonRoom;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class RoomTriggeredAbility
extends TriggeredAbilityImpl {
    private final DungeonRoom room;

    RoomTriggeredAbility(DungeonRoom room, Effect ... effects) {
        super(Zone.COMMAND, null, false);
        this.room = room;
        for (Effect effect : effects) {
            this.addEffect(effect);
        }
        this.setRuleVisible(false);
        this.setTriggerPhrase("When you enter this room, ");
    }

    RoomTriggeredAbility(DungeonRoom room, RoomTriggeredAbility ability) {
        super(ability);
        this.room = room;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ROOM_ENTERED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getTargetId().equals(this.room.getId());
    }

    @Override
    public RoomTriggeredAbility copy() {
        return new RoomTriggeredAbility(this.room, this);
    }

    public String getText() {
        return this.room.getName() + " &mdash; " + CardUtil.getTextWithFirstCharUpperCase(super.getRule()) + this.room.generateDestinationText();
    }

    @Override
    public String getRule() {
        return super.getRule() + " <i>(" + this.room.getName() + ")</i>";
    }
}

