/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.dungeons;

import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.LoseLifeAllPlayersEffect;
import mage.constants.CardType;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicates;
import mage.game.command.Dungeon;
import mage.game.command.DungeonRoom;
import mage.game.command.dungeons.OublietteEffect;
import mage.game.command.dungeons.SandfallCellEffect;
import mage.game.command.dungeons.VeilsOfFearEffect;
import mage.game.permanent.token.TheAtropalToken;

public final class TombOfAnnihilationDungeon
extends Dungeon {
    static final FilterControlledPermanent filter = new FilterControlledPermanent("an artifact, a creature, or a land");

    public TombOfAnnihilationDungeon() {
        super("Tomb of Annihilation");
        DungeonRoom trappedEntry = new DungeonRoom("Trapped Entry", new LoseLifeAllPlayersEffect(1));
        DungeonRoom veilsOfFear = new DungeonRoom("Veils of Fear", new VeilsOfFearEffect());
        DungeonRoom oubliette = new DungeonRoom("Oubliette", new OublietteEffect());
        DungeonRoom sandfallCell = new DungeonRoom("Sandfall Cell", new SandfallCellEffect());
        DungeonRoom cradleOfTheDeathGod = new DungeonRoom("Cradle of the Death God", new CreateTokenEffect(new TheAtropalToken()));
        trappedEntry.addNextRoom(veilsOfFear);
        trappedEntry.addNextRoom(oubliette);
        veilsOfFear.addNextRoom(sandfallCell);
        oubliette.addNextRoom(cradleOfTheDeathGod);
        sandfallCell.addNextRoom(cradleOfTheDeathGod);
        this.addRoom(trappedEntry);
        this.addRoom(veilsOfFear);
        this.addRoom(oubliette);
        this.addRoom(sandfallCell);
        this.addRoom(cradleOfTheDeathGod);
    }

    private TombOfAnnihilationDungeon(TombOfAnnihilationDungeon dungeon) {
        super(dungeon);
    }

    @Override
    public TombOfAnnihilationDungeon copy() {
        return new TombOfAnnihilationDungeon(this);
    }

    static {
        filter.add(Predicates.or(CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.LAND.getPredicate()));
    }
}

