/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.dungeons;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetDiscard;

class VeilsOfFearEffect
extends OneShotEffect {
    VeilsOfFearEffect() {
        super(Outcome.Neutral);
        this.staticText = "each player loses 2 life unless they discard a card";
    }

    private VeilsOfFearEffect(VeilsOfFearEffect effect) {
        super(effect);
    }

    @Override
    public VeilsOfFearEffect copy() {
        return new VeilsOfFearEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player;
        HashMap<UUID, Card> map = new HashMap<UUID, Card>();
        for (UUID uUID : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            player = game.getPlayer(uUID);
            if (player == null) continue;
            TargetDiscard target = new TargetDiscard(0, 1, StaticFilters.FILTER_CARD, uUID);
            player.choose(Outcome.PreventDamage, target, source, game);
            map.put(uUID, game.getCard(target.getFirstTarget()));
        }
        for (Map.Entry entry : map.entrySet()) {
            player = game.getPlayer((UUID)entry.getKey());
            if (player == null) continue;
            if (entry.getValue() != null) {
                player.discard((Card)entry.getValue(), false, source, game);
                continue;
            }
            player.loseLife(2, game, source, false);
        }
        return true;
    }
}

