/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTargets;

class DackFaydenEmblemEffect
extends ContinuousEffectImpl {
    protected FixedTargets fixedTargets = new FixedTargets(new ArrayList<MageObjectReference>());

    DackFaydenEmblemEffect() {
        super(Duration.EndOfGame, Layer.ControlChangingEffects_2, SubLayer.NA, Outcome.GainControl);
        this.staticText = "gain control of those permanents";
    }

    DackFaydenEmblemEffect(DackFaydenEmblemEffect effect) {
        super(effect);
        this.fixedTargets = effect.fixedTargets.copy();
    }

    @Override
    public DackFaydenEmblemEffect copy() {
        return new DackFaydenEmblemEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID permanentId : this.fixedTargets.getTargets(game, source)) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null) continue;
            permanent.changeControllerId(source.getControllerId(), game, source);
        }
        return true;
    }

    public void setTargets(List<Permanent> targetedPermanents, Game game) {
        this.fixedTargets = new FixedTargets(new ArrayList<Permanent>(targetedPermanents), game);
    }
}

