/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;

class JayaBallardCastFromGraveyardEffect
extends AsThoughEffectImpl {
    JayaBallardCastFromGraveyardEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "You may cast instant and sorcery spells from your graveyard";
    }

    JayaBallardCastFromGraveyardEffect(JayaBallardCastFromGraveyardEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return true;
    }

    @Override
    public JayaBallardCastFromGraveyardEffect copy() {
        return new JayaBallardCastFromGraveyardEffect(this);
    }

    @Override
    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card card = game.getCard(objectId);
        if (card != null && card.isOwnedBy(affectedControllerId) && affectedControllerId.equals(source.getControllerId()) && StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY.match(card, game) && Zone.GRAVEYARD.equals((Object)game.getState().getZone(card.getId()))) {
            game.getState().setValue("JayaBallard", card);
            return true;
        }
        return false;
    }
}

