/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.ExpansionSet;
import mage.cards.Sets;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;
import mage.util.CardUtil;
import mage.util.RandomUtil;
import mage.util.functions.CopyTokenFunction;

class MomirEffect
extends OneShotEffect {
    public MomirEffect() {
        super(Outcome.PutCreatureInPlay);
    }

    public MomirEffect(MomirEffect effect) {
        super(effect);
        this.staticText = "Create a token that's a copy of a creature card with mana value X chosen at random";
    }

    @Override
    public MomirEffect copy() {
        return new MomirEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int value = CardUtil.getSourceCostsTag(game, source, "X", 0);
        if (game.isSimulation()) {
            CreatureToken token = new CreatureToken(value, value + 1);
            token.putOntoBattlefield(1, game, source, source.getControllerId(), false, false);
            return true;
        }
        CardCriteria criteria = new CardCriteria().types(CardType.CREATURE).manaValue(value);
        List<CardInfo> options = CardRepository.instance.findCards(criteria);
        if (options == null || options.isEmpty()) {
            game.informPlayers("No random creature card with mana value of " + value + " was found.");
            return false;
        }
        Token token = null;
        while (!options.isEmpty()) {
            int index = RandomUtil.nextInt(options.size());
            ExpansionSet expansionSet = Sets.findSet(options.get(index).getSetCode());
            if (expansionSet == null || !expansionSet.getSetType().isEternalLegal()) {
                options.remove(index);
                continue;
            }
            Card card = options.get(index).createCard();
            if (card != null) {
                token = CopyTokenFunction.createTokenCopy(card, game);
                break;
            }
            options.remove(index);
        }
        if (token != null) {
            token.putOntoBattlefield(1, game, source, source.getControllerId(), false, false);
            return true;
        }
        return false;
    }
}

