/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import java.util.ArrayList;
import mage.abilities.common.ActivateIfConditionActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.common.MainPhaseStackEmptyCondition;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.dynamicvalue.common.TargetManaValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.RollPlanarDieEffect;
import mage.abilities.effects.common.cost.PlanarDieRollCostIncreasingEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Planes;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.game.command.Plane;
import mage.game.command.planes.FeedingGroundsEffect;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.watchers.common.PlanarRollWatcher;

public class FeedingGroundsPlane
extends Plane {
    private static final String rule = "put X +1/+1 counters on target creature, where X is that creature's mana value";

    public FeedingGroundsPlane() {
        this.setPlaneType(Planes.PLANE_FEEDING_GROUNDS);
        SimpleStaticAbility ability = new SimpleStaticAbility(Zone.COMMAND, new FeedingGroundsEffect());
        this.getAbilities().add(ability);
        AddCountersTargetEffect chaosEffect = new AddCountersTargetEffect(CounterType.P1P1.createInstance(), TargetManaValue.instance);
        TargetPermanent chaosTarget = new TargetPermanent(StaticFilters.FILTER_PERMANENT_A_CREATURE);
        ArrayList<Effect> chaosEffects = new ArrayList<Effect>();
        chaosEffects.add(chaosEffect);
        ArrayList<Target> chaosTargets = new ArrayList<Target>();
        chaosTargets.add(chaosTarget);
        ActivateIfConditionActivatedAbility chaosAbility = new ActivateIfConditionActivatedAbility(Zone.COMMAND, new RollPlanarDieEffect(chaosEffects, chaosTargets), new GenericManaCost(0), MainPhaseStackEmptyCondition.instance);
        chaosAbility.addWatcher(new PlanarRollWatcher());
        this.getAbilities().add(chaosAbility);
        chaosAbility.setMayActivate(TargetController.ANY);
        this.getAbilities().add(new SimpleStaticAbility(Zone.ALL, new PlanarDieRollCostIncreasingEffect(chaosAbility.getOriginalId())));
    }

    private FeedingGroundsPlane(FeedingGroundsPlane plane) {
        super(plane);
    }

    @Override
    public FeedingGroundsPlane copy() {
        return new FeedingGroundsPlane(this);
    }
}

