/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.GainLifeTargetEffect;
import mage.constants.Outcome;
import mage.constants.Planes;
import mage.game.Game;
import mage.game.command.Plane;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;

class FieldsOfSummerEffect
extends OneShotEffect {
    public FieldsOfSummerEffect() {
        super(Outcome.GainLife);
        this.staticText = "that player may gain 2 life";
    }

    protected FieldsOfSummerEffect(FieldsOfSummerEffect effect) {
        super(effect);
    }

    @Override
    public FieldsOfSummerEffect copy() {
        return new FieldsOfSummerEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Plane cPlane = game.getState().getCurrentPlane();
        if (cPlane == null || !cPlane.getPlaneType().equals((Object)Planes.PLANE_FIELDS_OF_SUMMER)) {
            return false;
        }
        Player owner = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (owner != null && owner.canRespond() && owner.chooseUse(Outcome.Benefit, "Gain 2 life?", source, game)) {
            GainLifeTargetEffect effect = new GainLifeTargetEffect(2);
            effect.setTargetPointer(new FixedTarget(owner.getId())).apply(game, source);
            return true;
        }
        return false;
    }
}

