/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Planes;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.command.Plane;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;

class PanopticonTriggeredAbility
extends TriggeredAbilityImpl {
    public PanopticonTriggeredAbility(Effect effect) {
        super(Zone.COMMAND, effect);
    }

    protected PanopticonTriggeredAbility(PanopticonTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PLANESWALKED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Plane cPlane = game.getState().getCurrentPlane();
        if (cPlane == null || !cPlane.getPlaneType().equals((Object)Planes.PLANE_PANOPTICON)) {
            return false;
        }
        Player activePlayer = game.getPlayer(game.getActivePlayerId());
        if (activePlayer != null) {
            this.getEffects().setTargetPointer(new FixedTarget(activePlayer.getId()));
            return true;
        }
        return false;
    }

    @Override
    public String getRule() {
        return "When you planeswalk to {this}, draw a card";
    }

    @Override
    public PanopticonTriggeredAbility copy() {
        return new PanopticonTriggeredAbility(this);
    }
}

