/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import java.util.ArrayList;
import mage.ObjectColor;
import mage.abilities.common.ActivateIfConditionActivatedAbility;
import mage.abilities.common.PutCardIntoGraveFromAnywhereAllTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.common.MainPhaseStackEmptyCondition;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.abilities.effects.common.RollPlanarDieEffect;
import mage.abilities.effects.common.cost.PlanarDieRollCostIncreasingEffect;
import mage.abilities.effects.common.discard.DiscardEachPlayerEffect;
import mage.constants.Planes;
import mage.constants.SetTargetPointer;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.command.Plane;
import mage.target.Target;
import mage.watchers.common.PlanarRollWatcher;

public class TheDarkBaronyPlane
extends Plane {
    private static final FilterCard filter = new FilterCard("a nonblack card");

    public TheDarkBaronyPlane() {
        this.setPlaneType(Planes.PLANE_THE_DARK_BARONY);
        PutCardIntoGraveFromAnywhereAllTriggeredAbility ability = new PutCardIntoGraveFromAnywhereAllTriggeredAbility(Zone.COMMAND, new LoseLifeTargetEffect(1), false, filter, TargetController.ANY, SetTargetPointer.PLAYER);
        this.getAbilities().add(ability);
        DiscardEachPlayerEffect chaosEffect = new DiscardEachPlayerEffect(TargetController.OPPONENT);
        Object chaosTarget = null;
        ArrayList<Effect> chaosEffects = new ArrayList<Effect>();
        chaosEffects.add(chaosEffect);
        ArrayList<Target> chaosTargets = new ArrayList<Target>();
        chaosTargets.add((Target)chaosTarget);
        ActivateIfConditionActivatedAbility chaosAbility = new ActivateIfConditionActivatedAbility(Zone.COMMAND, new RollPlanarDieEffect(chaosEffects, chaosTargets), new GenericManaCost(0), MainPhaseStackEmptyCondition.instance);
        chaosAbility.addWatcher(new PlanarRollWatcher());
        this.getAbilities().add(chaosAbility);
        chaosAbility.setMayActivate(TargetController.ANY);
        this.getAbilities().add(new SimpleStaticAbility(Zone.ALL, new PlanarDieRollCostIncreasingEffect(chaosAbility.getOriginalId())));
    }

    private TheDarkBaronyPlane(TheDarkBaronyPlane plane) {
        super(plane);
    }

    @Override
    public TheDarkBaronyPlane copy() {
        return new TheDarkBaronyPlane(this);
    }

    static {
        filter.add(Predicates.not(new ColorPredicate(ObjectColor.BLACK)));
    }
}

