/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Planes;
import mage.game.Game;
import mage.game.command.Plane;
import mage.game.events.GameEvent;

class TheEonFogSkipUntapStepEffect
extends ContinuousRuleModifyingEffectImpl {
    final boolean allPlayers;

    public TheEonFogSkipUntapStepEffect() {
        this(Duration.WhileOnBattlefield, false);
    }

    public TheEonFogSkipUntapStepEffect(Duration duration, boolean allPlayers) {
        super(duration, Outcome.Neutral, false, false);
        this.allPlayers = allPlayers;
        this.staticText = "Players skip their untap steps";
    }

    protected TheEonFogSkipUntapStepEffect(TheEonFogSkipUntapStepEffect effect) {
        super(effect);
        this.allPlayers = effect.allPlayers;
    }

    @Override
    public TheEonFogSkipUntapStepEffect copy() {
        return new TheEonFogSkipUntapStepEffect(this);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAP_STEP;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Plane cPlane = game.getState().getCurrentPlane();
        if (cPlane == null) {
            return false;
        }
        return cPlane.getPlaneType().equals((Object)Planes.PLANE_THE_EON_FOG);
    }
}

