/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import java.util.ArrayList;
import mage.abilities.common.ActivateIfConditionActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.common.MainPhaseStackEmptyCondition;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.RollPlanarDieEffect;
import mage.abilities.effects.common.continuous.MaximumHandSizeControllerEffect;
import mage.abilities.effects.common.cost.PlanarDieRollCostIncreasingEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Planes;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.command.Plane;
import mage.game.command.planes.UndercityReachesTriggeredAbility;
import mage.target.Target;
import mage.watchers.common.PlanarRollWatcher;

public class UndercityReachesPlane
extends Plane {
    private static final FilterCard filter = new FilterCard("creature spells");

    public UndercityReachesPlane() {
        this.setPlaneType(Planes.PLANE_UNDERCITY_REACHES);
        UndercityReachesTriggeredAbility ability = new UndercityReachesTriggeredAbility();
        this.getAbilities().add(ability);
        MaximumHandSizeControllerEffect chaosEffect = new MaximumHandSizeControllerEffect(Integer.MAX_VALUE, Duration.EndOfGame, MaximumHandSizeControllerEffect.HandSizeModification.SET);
        Object chaosTarget = null;
        ArrayList<Effect> chaosEffects = new ArrayList<Effect>();
        chaosEffects.add(chaosEffect);
        ArrayList<Target> chaosTargets = new ArrayList<Target>();
        chaosTargets.add((Target)chaosTarget);
        ActivateIfConditionActivatedAbility chaosAbility = new ActivateIfConditionActivatedAbility(Zone.COMMAND, new RollPlanarDieEffect(chaosEffects, chaosTargets), new GenericManaCost(0), MainPhaseStackEmptyCondition.instance);
        chaosAbility.addWatcher(new PlanarRollWatcher());
        this.getAbilities().add(chaosAbility);
        chaosAbility.setMayActivate(TargetController.ANY);
        this.getAbilities().add(new SimpleStaticAbility(Zone.ALL, new PlanarDieRollCostIncreasingEffect(chaosAbility.getOriginalId())));
    }

    private UndercityReachesPlane(UndercityReachesPlane plane) {
        super(plane);
    }

    @Override
    public UndercityReachesPlane copy() {
        return new UndercityReachesPlane(this);
    }

    static {
        filter.add(CardType.CREATURE.getPredicate());
    }
}

