/*
 * Decompiled with CFR 0.152.
 */
package mage.game.draft;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import mage.cards.Card;
import mage.cards.ExpansionSet;
import mage.game.draft.Draft;
import mage.game.draft.DraftCube;
import mage.game.draft.DraftOptions;
import mage.game.draft.DraftPlayer;
import mage.game.events.Listener;
import mage.game.events.PlayerQueryEvent;
import mage.game.events.PlayerQueryEventSource;
import mage.game.events.TableEvent;
import mage.game.events.TableEventSource;
import mage.players.Player;
import mage.players.PlayerList;
import mage.util.XmageThreadFactory;
import org.apache.log4j.Logger;

public abstract class DraftImpl
implements Draft {
    protected static final Logger logger = Logger.getLogger(DraftImpl.class);
    protected final UUID id;
    protected UUID tableId = null;
    protected final Map<UUID, DraftPlayer> players = new LinkedHashMap<UUID, DraftPlayer>();
    protected final PlayerList table = new PlayerList();
    protected int numberBoosters;
    protected DraftCube draftCube;
    protected List<ExpansionSet> sets;
    protected List<String> setCodes;
    protected int boosterNum = 1;
    protected int cardNum = 1;
    protected DraftOptions.TimingOption timing;
    protected int boosterLoadingCounter;
    protected final int BOOSTER_LOADING_INTERVAL_SECS = 2;
    protected boolean abort = false;
    protected boolean started = false;
    protected transient TableEventSource tableEventSource = new TableEventSource();
    protected transient PlayerQueryEventSource playerQueryEventSource = new PlayerQueryEventSource();
    protected ScheduledFuture<?> boosterSendingWorker;
    protected ScheduledExecutorService boosterSendingExecutor = null;

    public DraftImpl(DraftOptions options, List<ExpansionSet> sets) {
        this.id = UUID.randomUUID();
        this.setCodes = options.getSetCodes();
        this.draftCube = options.getDraftCube();
        this.timing = options.getTiming();
        this.sets = sets;
        this.numberBoosters = options.getNumberBoosters();
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public UUID getTableId() {
        return this.tableId;
    }

    @Override
    public void setTableId(UUID tableId) {
        this.tableId = tableId;
    }

    @Override
    public void addPlayer(Player player) {
        DraftPlayer draftPlayer = new DraftPlayer(player);
        this.players.put(player.getId(), draftPlayer);
        this.table.add(player.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replacePlayer(Player oldPlayer, Player newPlayer) {
        if (newPlayer != null) {
            DraftPlayer newDraftPlayer = new DraftPlayer(newPlayer);
            DraftPlayer oldDraftPlayer = this.players.get(oldPlayer.getId());
            LinkedHashMap<UUID, DraftPlayer> newPlayers = new LinkedHashMap<UUID, DraftPlayer>();
            Object object = this.players;
            synchronized (object) {
                for (Map.Entry<UUID, DraftPlayer> entry : this.players.entrySet()) {
                    if (entry.getKey().equals(oldPlayer.getId())) {
                        newPlayers.put(newPlayer.getId(), newDraftPlayer);
                        continue;
                    }
                    newPlayers.put(entry.getKey(), entry.getValue());
                }
                this.players.clear();
                for (Map.Entry<UUID, DraftPlayer> entry : newPlayers.entrySet()) {
                    this.players.put(entry.getKey(), entry.getValue());
                }
            }
            object = this.table;
            synchronized (object) {
                UUID currentId = (UUID)this.table.get();
                if (currentId.equals(oldPlayer.getId())) {
                    currentId = newPlayer.getId();
                }
                this.table.clear();
                for (UUID playerId : this.players.keySet()) {
                    this.table.add(playerId);
                }
                this.table.setCurrent(currentId);
            }
            newDraftPlayer.setBoosterAndLoad(oldDraftPlayer.getBooster());
            if (oldDraftPlayer.isPicking()) {
                newDraftPlayer.setPickingAndSending();
            }
            this.boosterSendingStart();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DraftPlayer> getPlayers() {
        Map<UUID, DraftPlayer> map = this.players;
        synchronized (map) {
            return new ArrayList<DraftPlayer>(this.players.values());
        }
    }

    @Override
    public DraftPlayer getPlayer(UUID playerId) {
        return this.players.get(playerId);
    }

    @Override
    public DraftCube getDraftCube() {
        return this.draftCube;
    }

    @Override
    public int getNumberBoosters() {
        return this.numberBoosters;
    }

    @Override
    public List<ExpansionSet> getSets() {
        return this.sets;
    }

    @Override
    public int getBoosterNum() {
        return this.boosterNum;
    }

    @Override
    public int getCardNum() {
        return this.cardNum;
    }

    @Override
    public void leave(UUID playerId) {
    }

    @Override
    public void autoPick(UUID playerId) {
        List<Card> booster;
        if (this.players.containsKey(playerId) && (booster = this.players.get(playerId).getBooster()).size() > 0) {
            this.addPick(playerId, booster.get(booster.size() - 1).getId(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void passBoosterToLeft() {
        Map<UUID, DraftPlayer> map = this.players;
        synchronized (map) {
            UUID startId;
            UUID currentId = startId = (UUID)this.table.get(0);
            UUID nextId = (UUID)this.table.getNext();
            DraftPlayer current = this.players.get(currentId);
            DraftPlayer next = this.players.get(nextId);
            List<Card> currentBooster = current.booster;
            while (true) {
                List<Card> nextBooster = next.booster;
                next.setBoosterAndLoad(currentBooster);
                if (Objects.equals(nextId, startId)) break;
                currentBooster = nextBooster;
                nextId = (UUID)this.table.getNext();
                next = this.players.get(nextId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void passBoosterToRight() {
        Map<UUID, DraftPlayer> map = this.players;
        synchronized (map) {
            UUID startId;
            UUID currentId = startId = (UUID)this.table.get(0);
            UUID prevId = (UUID)this.table.getPrevious();
            DraftPlayer current = this.players.get(currentId);
            DraftPlayer prev = this.players.get(prevId);
            List<Card> currentBooster = current.booster;
            while (true) {
                List<Card> prevBooster = prev.booster;
                prev.setBoosterAndLoad(currentBooster);
                if (Objects.equals(prevId, startId)) break;
                currentBooster = prevBooster;
                prevId = (UUID)this.table.getPrevious();
                prev = this.players.get(prevId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openBooster() {
        Map<UUID, DraftPlayer> map = this.players;
        synchronized (map) {
            if (this.boosterNum <= this.numberBoosters) {
                for (DraftPlayer player : this.players.values()) {
                    if (this.draftCube != null) {
                        player.setBoosterAndLoad(this.draftCube.createBooster());
                        continue;
                    }
                    player.setBoosterAndLoad(this.sets.get(this.boosterNum - 1).createBooster());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pickCards() {
        Map<UUID, DraftPlayer> map = this.players;
        synchronized (map) {
            for (DraftPlayer player : this.players.values()) {
                if (player.getBooster().isEmpty()) {
                    return false;
                }
                player.setPickingAndSending();
            }
        }
        while (!this.donePicking()) {
            this.boosterSendingStart();
            this.picksWait();
        }
        ++this.cardNum;
        return true;
    }

    @Override
    public void boosterSendingStart() {
        if (this.boosterSendingExecutor == null) {
            this.boosterSendingExecutor = Executors.newSingleThreadScheduledExecutor(new XmageThreadFactory("TOURNEY BOOSTERS SEND " + this.getId()));
        }
        this.boosterLoadingCounter = 0;
        if (this.boosterSendingWorker == null) {
            this.boosterSendingWorker = this.boosterSendingExecutor.scheduleAtFixedRate(() -> {
                try {
                    if (this.isAbort() || this.sendBoostersToPlayers()) {
                        this.boosterSendingEnd();
                    } else {
                        ++this.boosterLoadingCounter;
                    }
                }
                catch (Exception ex) {
                    logger.fatal((Object)("Fatal boosterLoadingHandle error in draft " + this.id + " pack " + this.boosterNum + " pick " + this.cardNum), (Throwable)ex);
                }
            }, 0L, 2L, TimeUnit.SECONDS);
        }
    }

    protected void boosterSendingEnd() {
        if (this.boosterSendingWorker != null) {
            this.boosterSendingWorker.cancel(true);
            this.boosterSendingWorker = null;
        }
    }

    protected boolean sendBoostersToPlayers() {
        boolean allBoostersLoaded = true;
        for (DraftPlayer player : this.getPlayers()) {
            if (!player.isPicking() || player.isBoosterLoaded()) continue;
            allBoostersLoaded = false;
            player.getPlayer().pickCard(player.getBooster(), player.getDeck(), this);
        }
        return allBoostersLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean donePicking() {
        if (this.isAbort()) {
            return true;
        }
        Map<UUID, DraftPlayer> map = this.players;
        synchronized (map) {
            return this.players.values().stream().noneMatch(DraftPlayer::isPicking);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allJoined() {
        Map<UUID, DraftPlayer> map = this.players;
        synchronized (map) {
            return this.players.values().stream().allMatch(DraftPlayer::isJoined);
        }
    }

    @Override
    public void addTableEventListener(Listener<TableEvent> listener) {
        this.tableEventSource.addListener(listener);
    }

    @Override
    public void fireUpdatePlayersEvent() {
        this.tableEventSource.fireTableEvent(TableEvent.EventType.UPDATE, null, this);
    }

    @Override
    public void fireEndDraftEvent() {
        this.tableEventSource.fireTableEvent(TableEvent.EventType.END, null, this);
    }

    @Override
    public void addPlayerQueryEventListener(Listener<PlayerQueryEvent> listener) {
        this.playerQueryEventSource.addListener(listener);
    }

    @Override
    public void firePickCardEvent(UUID playerId) {
        DraftPlayer player = this.players.get(playerId);
        this.playerQueryEventSource.pickCard(playerId, "Pick card", player.getBooster(), this.getPickTimeout());
    }

    @Override
    public int getPickTimeout() {
        int cardNum = Math.min(15, this.cardNum);
        int time = this.timing.getPickTimeout(cardNum);
        if (time > 0) {
            time = Math.max(1, time - this.boosterLoadingCounter * 2);
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void picksCheckDone() {
        DraftImpl draftImpl = this;
        synchronized (draftImpl) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void picksWait() {
        DraftImpl draftImpl = this;
        synchronized (draftImpl) {
            try {
                this.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.donePicking()) {
            this.boosterSendingEnd();
        }
    }

    @Override
    public boolean addPick(UUID playerId, UUID cardId, Set<UUID> hiddenCards) {
        DraftPlayer player = this.players.get(playerId);
        if (player.isPicking()) {
            for (Card card : player.booster) {
                if (!card.getId().equals(cardId)) continue;
                player.addPick(card, hiddenCards);
                break;
            }
            this.picksCheckDone();
        }
        return !player.isPicking();
    }

    @Override
    public void setBoosterLoaded(UUID playerId) {
        DraftPlayer player = this.players.get(playerId);
        player.setBoosterLoaded();
    }

    @Override
    public boolean isAbort() {
        return this.abort;
    }

    @Override
    public void setAbort(boolean abort) {
        this.abort = abort;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void setStarted() {
        this.started = true;
    }
}

