/*
 * Decompiled with CFR 0.152.
 */
package mage.game.draft;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mage.cards.ExpansionSet;
import mage.game.draft.BoosterDraft;
import mage.game.draft.DraftOptions;
import mage.game.draft.DraftPlayer;

public class RandomBoosterDraft
extends BoosterDraft {
    List<ExpansionSet> allSets;
    List<ExpansionSet> useBoosters;

    public RandomBoosterDraft(DraftOptions options, List<ExpansionSet> sets) {
        super(options, sets);
        if (sets.isEmpty()) {
            throw new RuntimeException("At least one set must be selected for random booster draft");
        }
        this.allSets = new ArrayList<ExpansionSet>(sets);
        this.resetBoosters();
    }

    @Override
    protected void openBooster() {
        if (this.boosterNum <= this.numberBoosters) {
            for (DraftPlayer player : this.players.values()) {
                player.setBoosterAndLoad(this.getNextBooster().create15CardBooster());
            }
        }
    }

    private ExpansionSet getNextBooster() {
        if (this.useBoosters.isEmpty()) {
            this.resetBoosters();
        }
        ExpansionSet theBooster = this.useBoosters.get(0);
        this.useBoosters.remove(theBooster);
        return theBooster;
    }

    private void resetBoosters() {
        this.useBoosters = new ArrayList<ExpansionSet>(this.allSets);
        Collections.shuffle(this.useBoosters);
    }
}

