/*
 * Decompiled with CFR 0.152.
 */
package mage.game.draft;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import mage.cards.Card;
import mage.cards.ExpansionSet;
import mage.game.draft.DraftCube;
import mage.game.draft.DraftImpl;
import mage.game.draft.DraftOptions;
import mage.game.draft.DraftPlayer;

public class RichManCubeBoosterDraft
extends DraftImpl {
    protected int[] customProfiTimes = new int[]{70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40};
    protected final Map<String, DraftCube.CardIdentity> cardsInCube = new LinkedHashMap<String, DraftCube.CardIdentity>();

    public RichManCubeBoosterDraft(DraftOptions options, List<ExpansionSet> sets) {
        super(options, sets);
    }

    @Override
    public void start() {
        this.cardNum = 1;
        this.boosterNum = 1;
        while (!this.isAbort() && this.cardNum <= 36) {
            this.openBooster();
            this.cardNum = 1;
            this.fireUpdatePlayersEvent();
            while (!this.isAbort() && this.pickCards()) {
                this.passBoosterToLeft();
                this.fireUpdatePlayersEvent();
            }
            ++this.boosterNum;
        }
        this.boosterSendingEnd();
        this.fireEndDraftEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void passBoosterToLeft() {
        Map map = this.players;
        synchronized (map) {
            UUID startId;
            UUID currentId = startId = (UUID)this.table.get(0);
            UUID nextId = (UUID)this.table.getNext();
            DraftPlayer next = (DraftPlayer)this.players.get(nextId);
            this.draftCube.leftCubeCards.clear();
            this.draftCube.leftCubeCards.addAll(this.draftCube.getCubeCards());
            this.cardsInCube.clear();
            for (DraftCube.CardIdentity card : this.draftCube.leftCubeCards) {
                this.cardsInCube.put(card.getName(), card);
            }
            while (true) {
                for (DraftPlayer player : this.players.values()) {
                    if (player == null || player.getDeck() == null) continue;
                    for (Card card : player.getDeck().getSideboard()) {
                        if (this.cardsInCube.get(card.getName()) == null) continue;
                        this.draftCube.removeFromLeftCards(this.cardsInCube.get(card.getName()));
                    }
                }
                List<Card> nextBooster = this.draftCube.createBooster();
                next.setBoosterAndLoad(nextBooster);
                if (Objects.equals(nextId, startId)) break;
                nextId = (UUID)this.table.getNext();
                next = (DraftPlayer)this.players.get(nextId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean pickCards() {
        Map map = this.players;
        synchronized (map) {
            for (DraftPlayer player : this.players.values()) {
                if (this.cardNum > 36) {
                    return false;
                }
                player.setPickingAndSending();
            }
        }
        while (!this.donePicking()) {
            this.boosterSendingStart();
            this.picksWait();
        }
        ++this.cardNum;
        return true;
    }

    @Override
    public void firePickCardEvent(UUID playerId) {
        DraftPlayer player = (DraftPlayer)this.players.get(playerId);
        int cardNum = Math.min(36, this.cardNum);
        int time = (int)Math.ceil((double)this.customProfiTimes[cardNum - 1] * this.timing.getCustomTimeoutFactor());
        this.playerQueryEventSource.pickCard(playerId, "Pick card", player.getBooster(), time);
    }
}

