/*
 * Decompiled with CFR 0.152.
 */
package mage.game.events;

import java.util.UUID;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

public class CoinFlippedEvent
extends GameEvent {
    private final boolean result;
    private final boolean chosen;
    private final boolean winnable;
    private final int flipCount;

    CoinFlippedEvent(UUID playerId, UUID sourceId, int flipCount, boolean result, boolean chosen, boolean winnable) {
        super(GameEvent.EventType.COIN_FLIPPED, playerId, null, playerId);
        this.result = result;
        this.chosen = chosen;
        this.winnable = winnable;
        this.flipCount = flipCount;
        this.setSourceId(sourceId);
    }

    public boolean getResult() {
        return this.result;
    }

    public int getFlipCount() {
        return this.flipCount;
    }

    public String getResultName() {
        return CardUtil.booleanToFlipName(this.result);
    }

    public boolean getChosen() {
        return this.chosen;
    }

    public String getChosenName() {
        return CardUtil.booleanToFlipName(this.chosen);
    }

    public boolean isWinnable() {
        return this.winnable;
    }

    public boolean wasWon() {
        return this.result == this.chosen;
    }
}

