/*
 * Decompiled with CFR 0.152.
 */
package mage.game.events;

import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.PlanarDieRollResult;
import mage.constants.RollDieType;
import mage.game.events.GameEvent;

public class DieRolledEvent
extends GameEvent {
    private final RollDieType rollDieType;
    private final int sides;
    private final int naturalResult;
    private final PlanarDieRollResult planarResult;

    public DieRolledEvent(Ability source, UUID targetId, RollDieType rollDieType, int sides, int naturalResult, int modifier, PlanarDieRollResult planarResult) {
        super(GameEvent.EventType.DIE_ROLLED, targetId, source, source.getControllerId(), naturalResult + modifier, false);
        this.rollDieType = rollDieType;
        this.sides = sides;
        this.naturalResult = naturalResult;
        this.planarResult = planarResult;
    }

    public RollDieType getRollDieType() {
        return this.rollDieType;
    }

    public int getSides() {
        return this.sides;
    }

    public int getResult() {
        return this.amount;
    }

    public int getNaturalResult() {
        return this.naturalResult;
    }

    public PlanarDieRollResult getPlanarResult() {
        return this.planarResult;
    }
}

