/*
 * Decompiled with CFR 0.152.
 */
package mage.game.events;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.ApprovingObject;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.constants.Zone;

public class GameEvent
implements Serializable {
    protected EventType type;
    protected UUID id;
    protected UUID targetId;
    protected UUID sourceId;
    protected UUID playerId;
    protected int amount;
    protected boolean flag;
    protected String data;
    protected Zone zone;
    protected List<UUID> appliedEffects = new ArrayList<UUID>();
    protected ApprovingObject approvingObject;

    public GameEvent(EventType type, UUID targetId, Ability source, UUID playerId) {
        this(type, targetId, source, playerId, 0, false, null);
    }

    public GameEvent(EventType type, UUID targetId, Ability source, UUID playerId, ApprovingObject approvingObject) {
        this(type, targetId, source, playerId, 0, false, approvingObject);
    }

    public GameEvent(EventType type, UUID targetId, Ability source, UUID playerId, int amount, boolean flag) {
        this(type, targetId, source, playerId, amount, flag, null);
    }

    public static GameEvent getEvent(EventType type, UUID targetId, Ability source, UUID playerId, int amount) {
        return new GameEvent(type, targetId, source, playerId, amount, false);
    }

    public static GameEvent getEvent(EventType type, UUID targetId, Ability source, UUID playerId) {
        return new GameEvent(type, targetId, source, playerId);
    }

    public static GameEvent getEvent(EventType type, UUID targetId, Ability source, UUID playerId, ApprovingObject approvingObject) {
        return new GameEvent(type, targetId, source, playerId, approvingObject);
    }

    @Deprecated
    public static GameEvent getEvent(EventType type, UUID targetId, UUID playerId) {
        return new GameEvent(type, targetId, null, playerId);
    }

    public static GameEvent getEvent(EventType type, UUID targetId, Ability source, UUID playerId, String data, int amount) {
        GameEvent event = GameEvent.getEvent(type, targetId, source, playerId);
        event.setAmount(amount);
        event.setData(data);
        return event;
    }

    private GameEvent(EventType type, UUID targetId, Ability source, UUID playerId, int amount, boolean flag, ApprovingObject approvingObject) {
        this.type = type;
        this.targetId = targetId;
        this.sourceId = source == null ? null : source.getSourceId();
        this.amount = amount;
        this.playerId = playerId;
        this.flag = flag;
        this.approvingObject = approvingObject;
        this.id = UUID.randomUUID();
    }

    public EventType getType() {
        return this.type;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTargetId() {
        return this.targetId;
    }

    public void setTargetId(UUID targetId) {
        this.targetId = targetId;
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public void setPlayerId(UUID playerId) {
        this.playerId = playerId;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public void setAmountForCounters(int amount, boolean isEffect) {
        this.amount = amount;
        if (isEffect) {
            this.setFlag(true);
        }
    }

    public boolean getFlag() {
        return this.flag;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Zone getZone() {
        return this.zone;
    }

    public void setZone(Zone zone) {
        this.zone = zone;
    }

    public ApprovingObject getApprovingObject() {
        return this.approvingObject;
    }

    public List<UUID> getAppliedEffects() {
        return this.appliedEffects;
    }

    public void addAppliedEffects(List<UUID> appliedEffects) {
        if (appliedEffects != null) {
            this.appliedEffects.addAll(appliedEffects);
        }
    }

    public void setAppliedEffects(List<UUID> appliedEffects) {
        if (appliedEffects != null) {
            if (this.appliedEffects.isEmpty()) {
                this.appliedEffects = appliedEffects;
            } else {
                this.appliedEffects.addAll(appliedEffects);
            }
        }
    }

    public boolean hasApprovingIdentifier(MageIdentifier identifier) {
        if (this.approvingObject == null) {
            return false;
        }
        if (identifier.equals((Object)MageIdentifier.Default)) {
            return false;
        }
        return identifier.equals((Object)this.approvingObject.getApprovingAbility().getIdentifier());
    }

    protected void setSourceId(UUID sourceId) {
        this.sourceId = sourceId;
    }

    public String toString() {
        return this.type.toString();
    }

    public static enum EventType {
        BEGINNING,
        PREVENT_DAMAGE,
        PREVENTED_DAMAGE,
        PLAY_TURN,
        EXTRA_TURN,
        BEGIN_TURN,
        CHANGE_PHASE,
        PHASE_CHANGED,
        CHANGE_STEP,
        STEP_CHANGED,
        BEGINNING_PHASE,
        BEGINNING_PHASE_PRE,
        BEGINNING_PHASE_POST,
        BEGINNING_PHASE_EXTRA,
        BEGINNING_PHASE_PRE_EXTRA,
        BEGINNING_PHASE_POST_EXTRA,
        UNTAP_STEP_PRE,
        UNTAP_STEP,
        UNTAP_STEP_POST,
        UPKEEP_STEP_PRE,
        UPKEEP_STEP,
        UPKEEP_STEP_POST,
        DRAW_STEP_PRE,
        DRAW_STEP,
        DRAW_STEP_POST,
        PRECOMBAT_MAIN_PHASE,
        PRECOMBAT_MAIN_PHASE_PRE,
        PRECOMBAT_MAIN_PHASE_POST,
        PRECOMBAT_MAIN_STEP_PRE,
        PRECOMBAT_MAIN_STEP,
        PRECOMBAT_MAIN_STEP_POST,
        COMBAT_PHASE,
        COMBAT_PHASE_PRE,
        COMBAT_PHASE_POST,
        BEGIN_COMBAT_STEP_PRE,
        BEGIN_COMBAT_STEP,
        BEGIN_COMBAT_STEP_POST,
        DECLARE_ATTACKERS_STEP_PRE,
        DECLARE_ATTACKERS_STEP,
        DECLARE_ATTACKERS_STEP_POST,
        DECLARE_BLOCKERS_STEP_PRE,
        DECLARE_BLOCKERS_STEP,
        DECLARE_BLOCKERS_STEP_POST,
        COMBAT_DAMAGE_STEP,
        COMBAT_DAMAGE_STEP_PRE,
        COMBAT_DAMAGE_STEP_PRIORITY,
        COMBAT_DAMAGE_STEP_POST,
        END_COMBAT_STEP_PRE,
        END_COMBAT_STEP,
        END_COMBAT_STEP_POST,
        POSTCOMBAT_MAIN_PHASE,
        POSTCOMBAT_MAIN_PHASE_PRE,
        POSTCOMBAT_MAIN_PHASE_POST,
        POSTCOMBAT_MAIN_STEP_PRE,
        POSTCOMBAT_MAIN_STEP,
        POSTCOMBAT_MAIN_STEP_POST,
        END_PHASE,
        END_PHASE_PRE,
        END_PHASE_POST,
        END_TURN_STEP_PRE,
        END_TURN_STEP,
        END_TURN_STEP_POST,
        CLEANUP_STEP_PRE,
        CLEANUP_STEP,
        CLEANUP_STEP_POST,
        EMPTY_MANA_POOL,
        AT_END_OF_TURN,
        ZONE_CHANGE,
        ZONE_CHANGE_GROUP,
        ZONE_CHANGE_BATCH(true),
        DRAW_TWO_OR_MORE_CARDS,
        DRAW_CARD,
        DREW_CARD,
        EXPLORE,
        EXPLORED,
        ECHO_PAID,
        MIRACLE_CARD_REVEALED,
        MADNESS_CARD_EXILED,
        INVESTIGATED,
        KICKED,
        DISCARD_CARD,
        DISCARDED_CARD,
        DISCARDED_CARDS,
        CYCLE_CARD,
        CYCLED_CARD,
        CYCLE_DRAW,
        CLASH,
        CLASHED,
        DAMAGE_PLAYER,
        MILL_CARDS,
        MILLED_CARD,
        MILLED_CARDS_BATCH_FOR_ONE_PLAYER(true),
        MILLED_CARDS_BATCH_FOR_ALL(true),
        DAMAGED_PLAYER,
        DAMAGED_BATCH_FOR_PLAYERS(true),
        DAMAGED_BATCH_FOR_ONE_PLAYER(true),
        DAMAGED_BATCH_BY_SOURCE(true),
        DAMAGED_BATCH_FOR_ALL(true),
        DAMAGED_BATCH_COULD_HAVE_FIRED,
        DAMAGE_CAUSES_LIFE_LOSS,
        PLAYER_LIFE_CHANGE,
        GAIN_LIFE,
        GAINED_LIFE,
        LOSE_LIFE,
        LOST_LIFE,
        LOST_LIFE_BATCH_FOR_ONE_PLAYER(true),
        LOST_LIFE_BATCH(true),
        PLAY_LAND,
        LAND_PLAYED,
        CREATURE_CHAMPIONED,
        CREW_VEHICLE,
        CREWED_VEHICLE,
        VEHICLE_CREWED,
        SADDLE_MOUNT,
        SADDLED_MOUNT,
        MOUNT_SADDLED,
        STATION_PERMANENT,
        CAST_SPELL,
        CAST_SPELL_LATE,
        SPELL_CAST,
        ACTIVATE_ABILITY,
        ACTIVATED_ABILITY,
        TAKE_SPECIAL_ACTION,
        TAKEN_SPECIAL_ACTION,
        TAKE_SPECIAL_MANA_PAYMENT,
        TAKEN_SPECIAL_MANA_PAYMENT,
        TRIGGERED_ABILITY,
        RESOLVING_ABILITY,
        COPY_STACKOBJECT,
        COPIED_STACKOBJECT,
        ADD_MANA,
        MANA_ADDED,
        MANA_PAID,
        LOSES,
        LOST,
        WINS,
        DRAW_PLAYER,
        TARGET,
        TARGETED,
        TARGETS_VALID,
        COUNTER,
        COUNTERED,
        DECLARING_ATTACKERS,
        DECLARED_ATTACKERS,
        DECLARE_ATTACKER,
        ATTACKER_DECLARED,
        DEFENDER_ATTACKED,
        DECLARING_BLOCKERS,
        DECLARED_BLOCKERS,
        DECLARE_BLOCKER,
        BLOCKER_DECLARED,
        CREATURE_BLOCKED,
        CREATURE_BLOCKS,
        BATCH_BLOCK_NONCOMBAT,
        UNBLOCKED_ATTACKER,
        SEARCH_LIBRARY,
        LIBRARY_SEARCHED,
        SHUFFLE_LIBRARY,
        LIBRARY_SHUFFLED,
        ENCHANT_PLAYER,
        ENCHANTED_PLAYER,
        CAN_TAKE_MULLIGAN,
        SCRY,
        SCRIED,
        SCRY_TO_BOTTOM,
        SURVEIL,
        SURVEILED,
        PROLIFERATE,
        PROLIFERATED,
        FATESEALED,
        FLIP_COIN,
        FLIP_COINS,
        COIN_FLIPPED,
        REPLACE_ROLLED_DIE,
        ROLL_DIE,
        DIE_ROLLED,
        ROLL_DICE,
        DICE_ROLLED,
        PLANESWALK,
        PLANESWALKED,
        PAID_CUMULATIVE_UPKEEP,
        DIDNT_PAY_CUMULATIVE_UPKEEP,
        PAY_LIFE,
        LIFE_PAID,
        CASCADE_LAND,
        LEARN,
        ENTERS_THE_BATTLEFIELD_SELF,
        ENTERS_THE_BATTLEFIELD_CONTROL,
        ENTERS_THE_BATTLEFIELD_COPY,
        ENTERS_THE_BATTLEFIELD,
        TAP,
        TAPPED,
        TAPPED_FOR_MANA,
        TAPPED_BATCH(true),
        UNTAP,
        UNTAPPED,
        UNTAPPED_BATCH(true),
        FLIP,
        FLIPPED,
        TRANSFORMING,
        TRANSFORMED,
        ADAPT,
        BECOMES_MONSTROUS,
        BECOMES_EXERTED,
        BECOMES_RENOWNED,
        GAINS_CLASS_LEVEL,
        CREATURE_ENLISTED,
        BECOME_MONARCH,
        BECOMES_MONARCH,
        TOOK_INITIATIVE,
        BECOMES_DAY_NIGHT,
        MEDITATED,
        PHASE_OUT,
        PHASED_OUT,
        PHASE_IN,
        PHASED_IN,
        TURN_FACE_UP,
        TURNED_FACE_UP,
        TURN_FACE_DOWN,
        TURNED_FACE_DOWN,
        MANIFESTED_DREAD,
        OPTION_USED,
        DAMAGE_PERMANENT,
        DAMAGED_PERMANENT,
        DAMAGED_BATCH_FOR_PERMANENTS(true),
        DAMAGED_BATCH_FOR_ONE_PERMANENT(true),
        REMOVE_DAMAGE_EOT,
        DESTROY_PERMANENT,
        DESTROYED_PERMANENT,
        SACRIFICE_PERMANENT,
        SACRIFICED_PERMANENT,
        SACRIFICED_PERMANENT_BATCH(true),
        FIGHTED_PERMANENT,
        BATCH_FIGHT,
        EXPLOITED_CREATURE,
        EVOLVED_CREATURE,
        EMBALMED_CREATURE,
        ETERNALIZED_CREATURE,
        ATTACH,
        ATTACHED,
        UNATTACH,
        UNATTACHED,
        STAY_ATTACHED,
        ADD_COUNTER,
        COUNTER_ADDED,
        ADD_COUNTERS,
        COUNTERS_ADDED,
        REMOVE_COUNTER,
        COUNTER_REMOVED,
        REMOVE_COUNTERS,
        COUNTERS_REMOVED,
        LOSE_CONTROL,
        LOST_CONTROL,
        GAIN_CONTROL,
        GAINED_CONTROL,
        CREATE_TOKEN,
        CREATED_TOKEN,
        CREATED_TOKENS,
        REGENERATE,
        REGENERATED,
        CHANGE_COLOR,
        COLOR_CHANGED,
        NUMBER_OF_TRIGGERS,
        COMBAT_DAMAGE_APPLIED,
        SELECTED_ATTACKER,
        SELECTED_BLOCKER,
        VOTE,
        VOTED,
        ROOM_ENTERED,
        VENTURE,
        VENTURED,
        DUNGEON_COMPLETED,
        TEMPTED_BY_RING,
        RING_BEARER_CHOSEN,
        REMOVED_FROM_COMBAT,
        CARD_FORETOLD,
        FACE_VILLAINOUS_CHOICE,
        DISCOVERED,
        EXILED_WHILE_CRAFTING,
        SOLVE_CASE,
        CASE_SOLVED,
        BECOME_SUSPECTED,
        EVIDENCE_COLLECTED,
        MENTORED_CREATURE,
        BECOME_PLOTTED,
        FORAGED,
        GAVE_GIFT,
        RADIATION_GAIN_LIFE,
        PAY_SACRIFICE_COST,
        EARTHBENDED,
        AIRBENDED,
        FIREBENDED,
        WATERBENDED,
        CUSTOM_EVENT;

        private final boolean isBatch;

        private EventType() {
            this(false);
        }

        private EventType(boolean isBatch) {
            this.isBatch = isBatch;
        }

        public boolean isBatch() {
            return this.isBatch;
        }
    }
}

