/*
 * Decompiled with CFR 0.152.
 */
package mage.game.events;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.events.GameEvent;
import mage.game.permanent.PermanentToken;

public class ZoneChangeGroupEvent
extends GameEvent {
    private final Zone fromZone;
    private final Zone toZone;
    private final Set<Card> cards;
    private final Set<PermanentToken> tokens;
    Ability source;

    public ZoneChangeGroupEvent(Set<Card> cards, Set<PermanentToken> tokens, UUID sourceId, Ability source, UUID playerId, Zone fromZone, Zone toZone) {
        super(GameEvent.EventType.ZONE_CHANGE_GROUP, null, null, playerId);
        this.fromZone = fromZone;
        this.toZone = toZone;
        this.cards = cards;
        this.tokens = tokens;
        this.source = source;
    }

    public Zone getFromZone() {
        return this.fromZone;
    }

    public Zone getToZone() {
        return this.toZone;
    }

    public boolean isDiesEvent() {
        return this.toZone == Zone.GRAVEYARD && this.fromZone == Zone.BATTLEFIELD;
    }

    public Set<Card> getCards() {
        return this.cards;
    }

    public Set<PermanentToken> getTokens() {
        return this.tokens;
    }

    public Ability getSource() {
        return this.source;
    }
}

