/*
 * Decompiled with CFR 0.152.
 */
package mage.game.mulligan;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.mulligan.Mulligan;
import mage.players.Player;
import mage.target.common.TargetCardInHand;

public class LondonMulligan
extends Mulligan {
    private final Map<UUID, Integer> startingHandSizes = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> openingHandSizes = new HashMap<UUID, Integer>();

    public LondonMulligan(int freeMulligans) {
        super(freeMulligans);
    }

    LondonMulligan(LondonMulligan mulligan) {
        super(mulligan);
        this.startingHandSizes.putAll(mulligan.startingHandSizes);
        this.openingHandSizes.putAll(mulligan.openingHandSizes);
    }

    @Override
    public void executeMulliganPhase(Game game, int startingHandSize) {
        for (UUID playerId : game.getState().getPlayerList(game.getStartingPlayerId())) {
            this.openingHandSizes.put(playerId, startingHandSize);
            this.startingHandSizes.put(playerId, startingHandSize);
        }
        super.executeMulliganPhase(game, startingHandSize);
    }

    @Override
    public int mulliganDownTo(Game game, UUID playerId) {
        Player player = game.getPlayer(playerId);
        int deduction = 1;
        if (this.freeMulligans > 0) {
            if (this.usedFreeMulligans.containsKey(player.getId())) {
                int used = (Integer)this.usedFreeMulligans.get(player.getId());
                if (used < this.freeMulligans) {
                    deduction = 0;
                }
            } else {
                deduction = 0;
            }
        }
        return this.openingHandSizes.get(playerId) - deduction;
    }

    @Override
    public boolean canTakeMulligan(Game game, Player player) {
        return super.canTakeMulligan(game, player) && this.openingHandSizes.get(player.getId()) > 0;
    }

    @Override
    public void mulligan(Game game, UUID playerId) {
        Player player = game.getPlayer(playerId);
        int numCards = this.startingHandSizes.get(player.getId());
        player.getLibrary().addAll(player.getHand().getCards(game), game);
        player.getHand().clear();
        player.shuffleLibrary(null, game);
        int deduction = 1;
        if (this.freeMulligans > 0) {
            if (this.usedFreeMulligans.containsKey(player.getId())) {
                int used = (Integer)this.usedFreeMulligans.get(player.getId());
                if (used < this.freeMulligans) {
                    deduction = 0;
                    this.usedFreeMulligans.put(player.getId(), used + 1);
                }
            } else {
                deduction = 0;
                this.usedFreeMulligans.put(player.getId(), 1);
            }
        }
        this.openingHandSizes.put(playerId, this.openingHandSizes.get(playerId) - deduction);
        int newHandSize = this.openingHandSizes.get(player.getId());
        if (deduction == 0) {
            game.fireInformEvent(player.getLogName() + " mulligans for free.");
        } else {
            game.fireInformEvent(player.getLogName() + " mulligans down to " + newHandSize + (newHandSize == 1 ? " card" : " cards"));
        }
        this.drawHand(numCards, player, game);
        while (player.canRespond() && player.getHand().size() > newHandSize) {
            TargetCardInHand target = new TargetCardInHand(new FilterCard("card (" + (player.getHand().size() - newHandSize) + " more) to put on the bottom of your library"));
            player.chooseTarget(Outcome.Discard, target, null, game);
            player.putCardsOnBottomOfLibrary(new CardsImpl((Collection<UUID>)target.getTargets()), game, null, true);
        }
    }

    @Override
    public void endMulligan(Game game, UUID playerId) {
    }

    @Override
    public LondonMulligan copy() {
        return new LondonMulligan(this);
    }
}

