/*
 * Decompiled with CFR 0.152.
 */
package mage.game.mulligan;

import java.util.Locale;
import mage.game.mulligan.CanadianHighlanderMulligan;
import mage.game.mulligan.LondonMulligan;
import mage.game.mulligan.Mulligan;
import mage.game.mulligan.ParisMulligan;
import mage.game.mulligan.SmoothedLondonMulligan;
import mage.game.mulligan.VancouverMulligan;

public enum MulliganType {
    GAME_DEFAULT("Game Default"),
    VANCOUVER("Vancouver"),
    PARIS("Paris"),
    LONDON("London"),
    SMOOTHED_LONDON("Smoothed London"),
    CANADIAN_HIGHLANDER("Canadian Highlander");

    private final String displayName;

    private MulliganType(String displayName) {
        this.displayName = displayName;
    }

    public Mulligan getMulligan(int freeMulligans) {
        switch (this) {
            case PARIS: {
                return new ParisMulligan(freeMulligans);
            }
            case CANADIAN_HIGHLANDER: {
                return new CanadianHighlanderMulligan(freeMulligans);
            }
            case VANCOUVER: {
                return new VancouverMulligan(freeMulligans);
            }
            case SMOOTHED_LONDON: {
                return new SmoothedLondonMulligan(freeMulligans);
            }
        }
        return new LondonMulligan(freeMulligans);
    }

    public String toString() {
        return this.displayName;
    }

    public static MulliganType valueByName(String name) {
        String search = (name != null ? name : "").toUpperCase(Locale.ENGLISH);
        MulliganType res = GAME_DEFAULT;
        for (MulliganType m : MulliganType.values()) {
            if (!m.displayName.toUpperCase(Locale.ENGLISH).equals(search)) continue;
            res = m;
            break;
        }
        return res;
    }

    public MulliganType orDefault(MulliganType defaultMulligan) {
        if (this == GAME_DEFAULT) {
            return defaultMulligan;
        }
        return this;
    }
}

