/*
 * Decompiled with CFR 0.152.
 */
package mage.game.mulligan;

import java.util.UUID;
import mage.game.Game;
import mage.game.mulligan.Mulligan;
import mage.players.Player;

public class ParisMulligan
extends Mulligan {
    public ParisMulligan(int freeMulligans) {
        super(freeMulligans);
    }

    ParisMulligan(ParisMulligan mulligan) {
        super(mulligan);
    }

    @Override
    public int mulliganDownTo(Game game, UUID playerId) {
        Player player = game.getPlayer(playerId);
        int deduction = 1;
        if (this.freeMulligans > 0) {
            if (this.usedFreeMulligans != null && this.usedFreeMulligans.containsKey(player.getId())) {
                int used = (Integer)this.usedFreeMulligans.get(player.getId());
                if (used < this.freeMulligans) {
                    deduction = 0;
                }
            } else {
                deduction = 0;
            }
        }
        return player.getHand().size() - deduction;
    }

    @Override
    public void mulligan(Game game, UUID playerId) {
        Player player = game.getPlayer(playerId);
        int numCards = player.getHand().size();
        player.getLibrary().addAll(player.getHand().getCards(game), game);
        player.getHand().clear();
        player.shuffleLibrary(null, game);
        int deduction = 1;
        if (this.freeMulligans > 0) {
            if (this.usedFreeMulligans.containsKey(player.getId())) {
                int used = (Integer)this.usedFreeMulligans.get(player.getId());
                if (used < this.freeMulligans) {
                    deduction = 0;
                    this.usedFreeMulligans.put(player.getId(), used + 1);
                }
            } else {
                deduction = 0;
                this.usedFreeMulligans.put(player.getId(), 1);
            }
        }
        game.fireInformEvent(player.getLogName() + " mulligans" + (deduction == 0 ? " for free and draws " : " down to ") + (numCards - deduction) + (numCards - deduction == 1 ? " card" : " cards"));
        this.drawHand(numCards - deduction, player, game);
    }

    @Override
    public void endMulligan(Game game, UUID playerId) {
    }

    @Override
    public ParisMulligan copy() {
        return new ParisMulligan(this);
    }
}

