/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.ApprovingObject;
import mage.MageObject;
import mage.MageObjectReference;
import mage.ObjectColor;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.RequirementEffect;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.effects.common.RegenerateSourceEffect;
import mage.abilities.effects.common.continuous.BecomesFaceDownCreatureEffect;
import mage.abilities.hint.HintUtils;
import mage.abilities.keyword.CompleatedAbility;
import mage.abilities.keyword.DayboundAbility;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.DefenderAbility;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.HexproofBaseAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.InfectAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.NightboundAbility;
import mage.abilities.keyword.ProtectionAbility;
import mage.abilities.keyword.ShroudAbility;
import mage.abilities.keyword.SquirrellinkAbility;
import mage.abilities.keyword.WitherAbility;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.EffectType;
import mage.constants.EmptyNames;
import mage.constants.EnterEventType;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.constants.Rarity;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.filter.FilterOpponent;
import mage.game.Game;
import mage.game.GameState;
import mage.game.ZoneChangeInfo;
import mage.game.ZonesHandler;
import mage.game.combat.CombatGroup;
import mage.game.command.CommandObject;
import mage.game.events.DamageEvent;
import mage.game.events.DamagePermanentEvent;
import mage.game.events.DamagedPermanentEvent;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.events.PreventDamageEvent;
import mage.game.events.PreventedDamageEvent;
import mage.game.events.SacrificedPermanentEvent;
import mage.game.events.TappedEvent;
import mage.game.events.TargetEvent;
import mage.game.events.UntappedEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.SquirrelToken;
import mage.game.permanent.token.Token;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.TargetPlayer;
import mage.util.CardUtil;
import mage.util.GameLog;
import mage.util.ThreadLocalStringBuilder;
import org.apache.log4j.Logger;

public abstract class PermanentImpl
extends CardImpl
implements Permanent {
    private static final Logger logger = Logger.getLogger(PermanentImpl.class);
    private static final ThreadLocalStringBuilder threadLocalBuilder = new ThreadLocalStringBuilder(300);
    protected boolean tapped;
    protected boolean flipped;
    protected boolean transformed;
    protected boolean monstrous;
    protected boolean renowned;
    protected boolean suspected;
    protected boolean harnessed = false;
    protected boolean manifested = false;
    protected boolean cloaked = false;
    protected boolean morphed = false;
    protected boolean disguised = false;
    protected boolean ringBearerFlag = false;
    protected boolean canBeSacrificed = true;
    protected int classLevel = 1;
    protected final Set<UUID> goadingPlayers = new HashSet<UUID>();
    protected UUID originalControllerId;
    protected UUID controllerId;
    protected UUID protectorId = null;
    protected UUID beforeResetControllerId;
    protected int damage;
    protected boolean controlledFromStartOfControllerTurn;
    protected int turnsOnBattlefield;
    protected boolean phasedIn = true;
    protected boolean indirectPhase = false;
    protected boolean faceDown;
    protected boolean attacking;
    protected int blocking;
    protected int maxBlocks = 1;
    protected int minBlockedBy = 1;
    protected int maxBlockedBy = 0;
    protected boolean deathtouched;
    protected boolean solved = false;
    protected Map<String, List<UUID>> connectedCards = new HashMap<String, List<UUID>>();
    protected Set<MageObjectReference> dealtDamageByThisTurn;
    protected UUID attachedTo;
    protected int attachedToZoneChangeCounter;
    protected MageObjectReference pairedPermanent;
    protected List<UUID> bandedCards = new ArrayList<UUID>();
    protected Counters counters;
    protected List<MarkedDamageInfo> markedDamage;
    protected int markedLifelink;
    protected int timesLoyaltyUsed = 0;
    protected int loyaltyActivationsAvailable = 1;
    protected int transformCount = 0;
    protected Map<String, String> info = new LinkedHashMap<String, String>();
    protected int createOrder;
    protected boolean legendRuleApplies = true;
    protected boolean prototyped;
    private static final List<UUID> emptyList = Collections.unmodifiableList(new ArrayList());
    private static final String suspectedInfoKey = "IS_SUSPECTED";
    private static final String ringbearerInfoKey = "IS_RINGBEARER";

    protected PermanentImpl(UUID ownerId, UUID controllerId, String name) {
        super(ownerId, name);
        if (controllerId == null) {
            throw new IllegalArgumentException("Wrong code usage: controllerId can't be null - " + name, new Throwable());
        }
        this.originalControllerId = controllerId;
        this.controllerId = controllerId;
        this.counters = new Counters(new Counter[0]);
    }

    protected PermanentImpl(UUID id, UUID ownerId, UUID controllerId, String name) {
        super(id, ownerId, name);
        this.originalControllerId = controllerId;
        this.controllerId = controllerId;
        this.counters = new Counters(new Counter[0]);
    }

    protected PermanentImpl(PermanentImpl permanent) {
        super(permanent);
        this.tapped = permanent.tapped;
        this.flipped = permanent.flipped;
        this.originalControllerId = permanent.originalControllerId;
        this.controllerId = permanent.controllerId;
        this.damage = permanent.damage;
        this.controlledFromStartOfControllerTurn = permanent.controlledFromStartOfControllerTurn;
        this.turnsOnBattlefield = permanent.turnsOnBattlefield;
        this.phasedIn = permanent.phasedIn;
        this.indirectPhase = permanent.indirectPhase;
        this.faceDown = permanent.faceDown;
        this.attacking = permanent.attacking;
        this.blocking = permanent.blocking;
        this.maxBlocks = permanent.maxBlocks;
        this.deathtouched = permanent.deathtouched;
        this.solved = permanent.solved;
        this.markedLifelink = permanent.markedLifelink;
        this.connectedCards = CardUtil.deepCopyObject(permanent.connectedCards);
        this.dealtDamageByThisTurn = CardUtil.deepCopyObject(permanent.dealtDamageByThisTurn);
        if (permanent.markedDamage != null) {
            this.markedDamage = new ArrayList<MarkedDamageInfo>();
            for (MarkedDamageInfo mdi : permanent.markedDamage) {
                this.markedDamage.add(new MarkedDamageInfo(mdi.counter.copy(), mdi.sourceObject, mdi.addCounters));
            }
        }
        this.info.putAll(permanent.info);
        this.counters = permanent.counters.copy();
        this.attachedTo = permanent.attachedTo;
        this.attachedToZoneChangeCounter = permanent.attachedToZoneChangeCounter;
        this.minBlockedBy = permanent.minBlockedBy;
        this.maxBlockedBy = permanent.maxBlockedBy;
        this.transformed = permanent.transformed;
        this.monstrous = permanent.monstrous;
        this.renowned = permanent.renowned;
        this.suspected = permanent.suspected;
        this.harnessed = permanent.harnessed;
        this.ringBearerFlag = permanent.ringBearerFlag;
        this.classLevel = permanent.classLevel;
        this.goadingPlayers.addAll(permanent.goadingPlayers);
        this.pairedPermanent = permanent.pairedPermanent;
        this.bandedCards.addAll(permanent.bandedCards);
        this.timesLoyaltyUsed = permanent.timesLoyaltyUsed;
        this.loyaltyActivationsAvailable = permanent.loyaltyActivationsAvailable;
        this.legendRuleApplies = permanent.legendRuleApplies;
        this.transformCount = permanent.transformCount;
        this.protectorId = permanent.protectorId;
        this.morphed = permanent.morphed;
        this.disguised = permanent.disguised;
        this.manifested = permanent.manifested;
        this.cloaked = permanent.cloaked;
        this.createOrder = permanent.createOrder;
        this.prototyped = permanent.prototyped;
        this.canBeSacrificed = permanent.canBeSacrificed;
    }

    @Override
    public String toString() {
        String name = this.getName().isEmpty() ? "face down [" + this.getId().toString().substring(0, 3) + "]" : this.getIdName();
        String imageInfo = this.getExpansionSetCode() + ":" + this.getCardNumber() + ":" + this.getImageFileName() + ":" + this.getImageNumber();
        return name + ", " + (this.getBasicMageObject() instanceof Token ? "T" : "C") + ", " + this.getBasicMageObject().getClass().getSimpleName() + ", " + imageInfo + ", " + this.getPower() + "/" + this.getToughness() + (this.getDamage() > 0 ? ", damage " + this.getDamage() : "") + (this.isCopy() ? ", copy" : "") + (this.isTapped() ? ", tapped" : "") + (this.isAttacking() ? ", attacking" : "") + (this.getBlocking() > 0 ? ", blocking" : "");
    }

    @Override
    public void setControllerId(UUID controllerId) {
        this.controllerId = controllerId;
        this.abilities.setControllerId(controllerId);
    }

    @Override
    public void setOriginalControllerId(UUID originalControllerId) {
        this.originalControllerId = originalControllerId;
    }

    @Override
    public void reset(Game game) {
        this.resetControl();
        this.maxBlocks = 1;
        this.minBlockedBy = 1;
        this.maxBlockedBy = 0;
        this.copy = false;
        this.goadingPlayers.clear();
        this.loyaltyActivationsAvailable = 1;
        this.legendRuleApplies = true;
        this.canBeSacrificed = true;
    }

    @Override
    public String getName() {
        if (this.name.isEmpty()) {
            if (this.faceDown) {
                return EmptyNames.FACE_DOWN_CREATURE.getObjectName();
            }
            return "";
        }
        return this.name;
    }

    @Override
    public String getValue(GameState state) {
        StringBuilder sb = threadLocalBuilder.get();
        sb.append(this.controllerId).append(this.getName()).append(this.tapped).append(this.damage);
        sb.append(this.subtype).append(this.supertype).append(this.power.getValue()).append(this.toughness.getValue());
        sb.append(this.abilities.getValue());
        for (Counter counter : this.getCounters(state).values()) {
            sb.append(counter.getName()).append(counter.getCount());
        }
        return sb.toString();
    }

    @Override
    public void addInfo(String key, String value, Game game) {
        if (this.info == null) {
            this.info = new HashMap<String, String>();
        }
        if (value == null || value.isEmpty()) {
            this.info.remove(key);
        } else {
            this.info.put(key, value);
        }
    }

    @Override
    public final List<String> getRules(Game game) {
        try {
            List<String> rules = super.getRules(game);
            if (this.info != null) {
                rules.addAll(this.info.values());
            }
            if (game == null || game.getPhase() == null) {
                return rules;
            }
            ArrayList<String> restrictHints = new ArrayList<String>();
            for (Map.Entry<RestrictionEffect, Set<Ability>> entry : game.getContinuousEffects().getApplicableRestrictionEffects(this, game).entrySet()) {
                for (Ability ability : entry.getValue()) {
                    if (!entry.getKey().canAttack(game, false) || !entry.getKey().canAttack(this, null, ability, game, false)) {
                        restrictHints.add(HintUtils.prepareText("Can't attack" + this.addSourceObjectName(game, ability), null, "ICON_RESTRICT"));
                    }
                    if (!entry.getKey().canBlock(null, this, ability, game, false)) {
                        restrictHints.add(HintUtils.prepareText("Can't block" + this.addSourceObjectName(game, ability), null, "ICON_RESTRICT"));
                    }
                    if (!entry.getKey().canBeUntapped(this, ability, game, false)) {
                        restrictHints.add(HintUtils.prepareText("Can't untapped" + this.addSourceObjectName(game, ability), null, "ICON_RESTRICT"));
                    }
                    if (!entry.getKey().canUseActivatedAbilities(this, ability, game, false)) {
                        restrictHints.add(HintUtils.prepareText("Can't use activated abilities" + this.addSourceObjectName(game, ability), null, "ICON_RESTRICT"));
                    }
                    if (entry.getKey().canTransform(game, false)) continue;
                    restrictHints.add(HintUtils.prepareText("Can't transform" + this.addSourceObjectName(game, ability), null, "ICON_RESTRICT"));
                }
            }
            for (Map.Entry<ContinuousEffectImpl, Set<Ability>> entry : game.getContinuousEffects().getApplicableRequirementEffects(this, false, game).entrySet()) {
                for (Ability ability : entry.getValue()) {
                    Player player;
                    MageObject object;
                    if (((RequirementEffect)entry.getKey()).mustAttack(game)) {
                        restrictHints.add(HintUtils.prepareText("Must attack" + this.addSourceObjectName(game, ability), null, "ICON_REQUIRE"));
                    }
                    if (((RequirementEffect)entry.getKey()).mustBlock(game)) {
                        restrictHints.add(HintUtils.prepareText("Must block" + this.addSourceObjectName(game, ability), null, "ICON_REQUIRE"));
                    }
                    if (((RequirementEffect)entry.getKey()).mustBlockAny(game)) {
                        restrictHints.add(HintUtils.prepareText("Must block any" + this.addSourceObjectName(game, ability), null, "ICON_REQUIRE"));
                    }
                    if (((RequirementEffect)entry.getKey()).mustBlockAllAttackers(game)) {
                        restrictHints.add(HintUtils.prepareText("Must block all attackers" + this.addSourceObjectName(game, ability), null, "ICON_REQUIRE"));
                    }
                    if ((object = game.getObject(((RequirementEffect)entry.getKey()).mustAttackDefender(ability, game))) != null) {
                        restrictHints.add(HintUtils.prepareText("Must attack defender " + object.getLogName() + this.addSourceObjectName(game, ability), null, "ICON_REQUIRE"));
                    }
                    if ((player = game.getPlayer(((RequirementEffect)entry.getKey()).mustAttackDefender(ability, game))) != null) {
                        restrictHints.add(HintUtils.prepareText("Must attack defender " + player.getLogName() + this.addSourceObjectName(game, ability), null, "ICON_REQUIRE"));
                    }
                    if ((object = game.getObject(((RequirementEffect)entry.getKey()).mustBlockAttacker(ability, game))) != null) {
                        restrictHints.add(HintUtils.prepareText("Must block attacker " + object.getLogName() + this.addSourceObjectName(game, ability), null, "ICON_REQUIRE"));
                    }
                    if ((object = game.getObject(((RequirementEffect)entry.getKey()).mustBlockAttackerIfElseUnblocked(ability, game))) == null) continue;
                    restrictHints.add(HintUtils.prepareText("Must block attacker if able " + object.getLogName() + this.addSourceObjectName(game, ability), null, "ICON_REQUIRE"));
                }
            }
            for (UUID uUID : this.getGoadingPlayers()) {
                Player player = game.getPlayer(uUID);
                if (player == null) continue;
                restrictHints.add(HintUtils.prepareText("Goaded by " + player.getLogName() + " (must attack)", null, "ICON_REQUIRE"));
            }
            restrictHints.sort(String::compareTo);
            if (!restrictHints.isEmpty()) {
                if (rules.stream().noneMatch(s -> s.contains("<br/><hintstart/>"))) {
                    rules.add("<br/><hintstart/>");
                }
                HintUtils.appendHints(rules, restrictHints);
            }
            return rules;
        }
        catch (Exception e) {
            return CardUtil.RULES_ERROR_INFO;
        }
    }

    private String addSourceObjectName(Game game, Ability ability) {
        MageObject object;
        if (ability != null && (object = game.getObject(ability.getSourceId())) != null) {
            return " (" + object.getIdName() + ")";
        }
        return "";
    }

    @Override
    public Abilities<Ability> getAbilities() {
        return super.getAbilities();
    }

    @Override
    public Abilities<Ability> getAbilities(Game game) {
        return super.getAbilities(game);
    }

    @Override
    public Ability addAbility(Ability ability, UUID sourceId, Game game) {
        return this.addAbility(ability, sourceId, game, false);
    }

    @Override
    public Ability addAbility(Ability ability, UUID sourceId, Game game, boolean fromExistingObject) {
        if (!this.abilities.containsKey(ability.getId())) {
            Ability copyAbility = ability.copy();
            copyAbility.newId();
            copyAbility.setControllerId(this.controllerId);
            copyAbility.setSourceId(this.objectId);
            if (game != null) {
                game.getState().addAbility(copyAbility, sourceId, this);
            }
            this.abilities.add(copyAbility);
            if (!fromExistingObject) {
                this.abilities.addAll(copyAbility.getSubAbilities());
            }
            return copyAbility;
        }
        return null;
    }

    @Override
    public void removeAllAbilities(UUID sourceId, Game game) {
        this.abilities.clear();
    }

    @Override
    public void removeAbility(Ability abilityToRemove, UUID sourceId, Game game) {
        if (abilityToRemove == null) {
            return;
        }
        ArrayList toRemove = new ArrayList();
        this.abilities.forEach(a -> {
            if (a.isSameInstance(abilityToRemove)) {
                toRemove.add(a);
            }
        });
        toRemove.forEach(r -> this.abilities.remove(r));
    }

    @Override
    public void removeAbilities(List<Ability> abilitiesToRemove, UUID sourceId, Game game) {
        if (abilitiesToRemove == null) {
            return;
        }
        abilitiesToRemove.forEach(a -> this.removeAbility((Ability)a, sourceId, game));
    }

    @Override
    public Counters getCounters(Game game) {
        return this.counters;
    }

    @Override
    public Counters getCounters(GameState state) {
        return this.counters;
    }

    @Override
    public UUID getControllerOrOwnerId() {
        return this.controllerId;
    }

    @Override
    public int getTurnsOnBattlefield() {
        return this.turnsOnBattlefield;
    }

    @Override
    public void beginningOfTurn(Game game) {
        if (game.isActivePlayer(this.controllerId)) {
            this.controlledFromStartOfControllerTurn = true;
        }
    }

    @Override
    public void endOfTurn(Game game) {
        if (!game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.REMOVE_DAMAGE_EOT, this.getId(), null, this.getControllerId()))) {
            this.damage = 0;
        }
        this.timesLoyaltyUsed = 0;
        ++this.turnsOnBattlefield;
        this.deathtouched = false;
        this.dealtDamageByThisTurn = null;
        for (Ability ability : this.abilities) {
            ability.reset(game);
        }
    }

    @Override
    public void incrementLoyaltyActivationsAvailable() {
        this.incrementLoyaltyActivationsAvailable(Integer.MAX_VALUE);
    }

    @Override
    public void incrementLoyaltyActivationsAvailable(int max) {
        if (this.loyaltyActivationsAvailable < max) {
            ++this.loyaltyActivationsAvailable;
        }
    }

    @Override
    public void setLoyaltyActivationsAvailable(int setActivations) {
        if (this.loyaltyActivationsAvailable < setActivations) {
            this.loyaltyActivationsAvailable = setActivations;
        }
    }

    @Override
    public void addLoyaltyUsed() {
        ++this.timesLoyaltyUsed;
    }

    @Override
    public boolean canLoyaltyBeUsed(Game game) {
        Player controller = game.getPlayer(this.controllerId);
        if (controller != null) {
            return this.loyaltyActivationsAvailable > this.timesLoyaltyUsed;
        }
        return false;
    }

    @Override
    public void setLegendRuleApplies(boolean legendRuleApplies) {
        this.legendRuleApplies = legendRuleApplies;
    }

    @Override
    public boolean legendRuleApplies() {
        return this.legendRuleApplies;
    }

    @Override
    public boolean isTapped() {
        return this.tapped;
    }

    @Override
    public void setTapped(boolean tapped) {
        this.tapped = tapped;
    }

    @Override
    public boolean canTap(Game game) {
        return !this.isCreature(game) || !this.hasSummoningSickness();
    }

    @Override
    public boolean untap(Game game) {
        if (this.tapped && !this.replaceEvent(GameEvent.EventType.UNTAP, game)) {
            this.tapped = false;
            UntappedEvent event = new UntappedEvent(this.objectId, this.controllerId, game.getTurnStepType() == PhaseStep.UNTAP);
            game.fireEvent(event);
            game.getState().addSimultaneousUntappedToBatch(event, game);
            return true;
        }
        return false;
    }

    @Override
    public boolean tap(Ability source, Game game) {
        return this.tap(false, source, game);
    }

    @Override
    public boolean tap(boolean forCombat, Ability source, Game game) {
        if (!this.tapped && !this.replaceEvent(GameEvent.EventType.TAP, game)) {
            this.tapped = true;
            TappedEvent event = new TappedEvent(this.objectId, source, source == null ? null : source.getControllerId(), forCombat);
            game.fireEvent(event);
            game.getState().addSimultaneousTappedToBatch(event, game);
            return true;
        }
        return false;
    }

    @Override
    public void setFaceDown(boolean value, Game game) {
        this.faceDown = value;
    }

    @Override
    public boolean isFaceDown(Game game) {
        return this.faceDown;
    }

    @Override
    public boolean isFlipped() {
        return this.flipped;
    }

    @Override
    public boolean flip(Game game) {
        if (!this.flipped && !this.replaceEvent(GameEvent.EventType.FLIP, game)) {
            this.flipped = true;
            this.fireEvent(GameEvent.EventType.FLIPPED, game);
            return true;
        }
        return false;
    }

    @Override
    public boolean transform(Ability source, Game game) {
        return this.transform(source, game, false);
    }

    private boolean checkDayNightBound() {
        return this.getAbilities().containsClass(DayboundAbility.class) || this.getAbilities().containsClass(NightboundAbility.class);
    }

    private boolean checkTransformRestrictionEffects(Game game) {
        for (Map.Entry<RestrictionEffect, Set<Ability>> entry : game.getContinuousEffects().getApplicableRestrictionEffects(this, game).entrySet()) {
            if (entry.getKey().canTransform(game, true)) continue;
            return false;
        }
        return true;
    }

    public MageObject getOtherFace() {
        return this.transformed ? this.getMainCard() : this.getMainCard().getSecondCardFace();
    }

    @Override
    public boolean transform(Ability source, Game game, boolean ignoreDayNight) {
        if (!this.isTransformable() || !ignoreDayNight && this.checkDayNightBound() || this.getOtherFace().isInstantOrSorcery() || !this.checkTransformRestrictionEffects(game) || source != null && !source.checkTransformCount(this, game)) {
            return false;
        }
        if (this.transformed) {
            Card orgCard = this.getMainCard();
            this.getPower().setModifiedBaseValue(orgCard.getPower().getValue());
            this.getToughness().setModifiedBaseValue(orgCard.getToughness().getValue());
        }
        game.informPlayers(this.getLogName() + " transforms into " + this.getOtherFace().getLogName() + CardUtil.getSourceLogName(game, source, this.getId()));
        this.setTransformed(!this.transformed);
        ++this.transformCount;
        game.applyEffects();
        this.replaceEvent(GameEvent.EventType.TRANSFORMING, game);
        game.addSimultaneousEvent(GameEvent.getEvent(GameEvent.EventType.TRANSFORMED, this.getId(), this.getControllerId()));
        return true;
    }

    @Override
    public int getTransformCount() {
        return this.transformCount;
    }

    @Override
    public boolean isPhasedIn() {
        return this.phasedIn;
    }

    @Override
    public boolean isPhasedOutIndirectly() {
        return !this.phasedIn && this.indirectPhase;
    }

    @Override
    public boolean phaseIn(Game game) {
        return this.phaseIn(game, true);
    }

    @Override
    public boolean phaseIn(Game game, boolean onlyDirect) {
        if (!(this.phasedIn || this.replaceEvent(GameEvent.EventType.PHASE_IN, game) || onlyDirect && this.indirectPhase)) {
            this.phasedIn = true;
            this.indirectPhase = false;
            game.informPlayers(this.getLogName() + " phased in");
            for (UUID attachedId : this.getAttachments()) {
                Permanent attachedPerm = game.getPermanent(attachedId);
                if (attachedPerm == null) continue;
                attachedPerm.phaseIn(game, false);
            }
            game.addSimultaneousEvent(GameEvent.getEvent(GameEvent.EventType.PHASED_IN, this.objectId, null, this.controllerId));
            return true;
        }
        return false;
    }

    @Override
    public boolean phaseOut(Game game) {
        return this.phaseOut(game, false);
    }

    @Override
    public boolean phaseOut(Game game, boolean indirectPhase) {
        if (this.phasedIn && !this.replaceEvent(GameEvent.EventType.PHASE_OUT, game)) {
            for (UUID attachedId : this.getAttachments()) {
                Permanent attachedPerm = game.getPermanent(attachedId);
                if (attachedPerm == null) continue;
                attachedPerm.phaseOut(game, true);
            }
            this.removeFromCombat(game);
            this.phasedIn = false;
            this.indirectPhase = indirectPhase;
            game.informPlayers(this.getLogName() + " phased out");
            this.fireEvent(GameEvent.EventType.PHASED_OUT, game);
            return true;
        }
        return false;
    }

    public void removeSummoningSickness() {
        this.controlledFromStartOfControllerTurn = true;
    }

    @Override
    public boolean wasControlledFromStartOfControllerTurn() {
        return this.controlledFromStartOfControllerTurn;
    }

    @Override
    public boolean hasSummoningSickness() {
        return !this.controlledFromStartOfControllerTurn && !this.abilities.containsKey(HasteAbility.getInstance().getId());
    }

    @Override
    public boolean isAttacking() {
        return this.attacking;
    }

    @Override
    public boolean isBlocked(Game game) {
        for (CombatGroup combatGroup : game.getCombat().getGroups()) {
            if (!combatGroup.getBlocked() || !combatGroup.getAttackers().contains(this.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getBlocking() {
        return this.blocking;
    }

    @Override
    public int getMaxBlocks() {
        return this.maxBlocks;
    }

    @Override
    public int getMinBlockedBy() {
        return this.minBlockedBy;
    }

    @Override
    public int getMaxBlockedBy() {
        return this.maxBlockedBy;
    }

    @Override
    public UUID getControllerId() {
        return this.controllerId;
    }

    @Override
    public void resetControl() {
        this.beforeResetControllerId = this.controllerId;
        this.controllerId = this.originalControllerId;
    }

    @Override
    public boolean changeControllerId(UUID newControllerId, Game game, Ability source) {
        GameEvent gainControlEvent;
        Player newController = game.getPlayer(newControllerId);
        if (newController == null || !newController.isInGame()) {
            return false;
        }
        if (this.beforeResetControllerId != newControllerId && game.replaceEvent(gainControlEvent = GameEvent.getEvent(GameEvent.EventType.GAIN_CONTROL, this.getId(), null, newControllerId))) {
            return false;
        }
        GameEvent loseControlEvent = GameEvent.getEvent(GameEvent.EventType.LOSE_CONTROL, this.getId(), null, newControllerId);
        if (game.replaceEvent(loseControlEvent)) {
            return false;
        }
        this.controllerId = newControllerId;
        this.getAbilities().setControllerId(newControllerId);
        return true;
    }

    public void removeUncontrolledRingBearer(Game game) {
        if (this.isRingBearer()) {
            Player controller = this.beforeResetControllerId == null ? null : game.getPlayer(this.beforeResetControllerId);
            String controllerName = controller == null ? "" : controller.getLogName();
            game.informPlayers(controllerName + " has lost control of " + this.getLogName() + ". It is no longer a Ring-bearer.");
            this.setRingBearer(game, false);
        }
    }

    @Override
    public boolean checkControlChanged(Game game) {
        if (!this.controllerId.equals(this.beforeResetControllerId)) {
            this.removeFromCombat(game);
            this.controlledFromStartOfControllerTurn = false;
            this.removeUncontrolledRingBearer(game);
            this.getAbilities(game).setControllerId(this.controllerId);
            game.getContinuousEffects().setController(this.objectId, this.controllerId);
            game.fireEvent(new GameEvent(GameEvent.EventType.LOST_CONTROL, this.objectId, null, this.beforeResetControllerId));
            game.fireEvent(new GameEvent(GameEvent.EventType.GAINED_CONTROL, this.objectId, null, this.controllerId));
            return true;
        }
        if (this.isCopy()) {
            this.getAbilities(game).setControllerId(this.controllerId);
            game.getContinuousEffects().setController(this.objectId, this.controllerId);
        }
        return false;
    }

    @Override
    public UUID getAttachedTo() {
        return this.attachedTo;
    }

    @Override
    public int getAttachedToZoneChangeCounter() {
        return this.attachedToZoneChangeCounter;
    }

    @Override
    public void addConnectedCard(String key, UUID connectedCard) {
        if (this.connectedCards.containsKey(key)) {
            this.connectedCards.get(key).add(connectedCard);
        } else {
            ArrayList<UUID> list = new ArrayList<UUID>();
            list.add(connectedCard);
            this.connectedCards.put(key, list);
        }
    }

    @Override
    public List<UUID> getConnectedCards(String key) {
        return this.connectedCards.getOrDefault(key, emptyList);
    }

    @Override
    public void clearConnectedCards(String key) {
        if (this.connectedCards.containsKey(key)) {
            this.connectedCards.get(key).clear();
        }
    }

    @Override
    public void unattach(Game game) {
        this.attachedTo = null;
        this.addInfo("attachedTo", null, game);
    }

    @Override
    public void attachTo(UUID attachToObjectId, Ability source, Game game) {
        Permanent attachedToPerm;
        if (this.attachedTo != null && !Objects.equals(this.attachedTo, attachToObjectId)) {
            Permanent attachedToUntilNowObject = game.getPermanent(this.attachedTo);
            if (attachedToUntilNowObject != null) {
                attachedToUntilNowObject.removeAttachment(this.objectId, source, game);
            } else {
                Card attachedToUntilNowCard = game.getCard(this.attachedTo);
                if (attachedToUntilNowCard != null) {
                    attachedToUntilNowCard.removeAttachment(this.objectId, source, game);
                } else {
                    Player attachedToUntilNowPlayer = game.getPlayer(this.attachedTo);
                    if (attachedToUntilNowPlayer != null) {
                        attachedToUntilNowPlayer.removeAttachment(this, source, game);
                    }
                }
            }
        }
        this.attachedTo = attachToObjectId;
        this.attachedToZoneChangeCounter = game.getState().getZoneChangeCounter(attachToObjectId);
        for (Ability ability : this.getAbilities()) {
            for (Effect value : ability.getEffects(game, EffectType.CONTINUOUS)) {
                ContinuousEffect effect = (ContinuousEffect)value;
                game.getContinuousEffects().setOrder(effect);
                for (ContinuousEffect conEffect : game.getContinuousEffects().getLayeredEffects(game)) {
                    if (!conEffect.getId().equals(effect.getId())) continue;
                    game.getContinuousEffects().setOrder(conEffect);
                }
            }
        }
        this.addInfo("attachedTo", null, game);
        if (this.attachedTo != null && (attachedToPerm = game.getPermanent(this.getAttachedTo())) == null) {
            MageObject attachedToObject = game.getObject(this.getAttachedTo());
            if (attachedToObject != null) {
                this.addInfo("attachedTo", CardUtil.addToolTipMarkTags("Attached to: " + attachedToObject.getIdName()), game);
            } else {
                Player attachedToPlayer = game.getPlayer(this.getAttachedTo());
                if (attachedToPlayer != null) {
                    this.addInfo("attachedTo", CardUtil.addToolTipMarkTags("Attached to: " + attachedToPlayer.getName()), game);
                }
            }
        }
    }

    @Override
    public boolean isDeathtouched() {
        return this.deathtouched;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public int damage(int damage, Ability source, Game game) {
        return this.damage(damage, source.getSourceId(), source, game);
    }

    @Override
    public int damage(int damage, UUID attackerId, Ability source, Game game) {
        return this.doDamage(damage, attackerId, source, game, true, false, false, null);
    }

    @Override
    public int damage(int damage, UUID attackerId, Ability source, Game game, boolean combat, boolean preventable) {
        return this.doDamage(damage, attackerId, source, game, preventable, combat, false, null);
    }

    @Override
    public int damage(int damage, UUID attackerId, Ability source, Game game, boolean combat, boolean preventable, List<UUID> appliedEffects) {
        return this.doDamage(damage, attackerId, source, game, preventable, combat, false, appliedEffects);
    }

    private int doDamage(int damageAmount, UUID attackerId, Ability source, Game game, boolean preventable, boolean combat, boolean markDamage, List<UUID> appliedEffects) {
        int countersToRemove;
        if (damageAmount < 1) {
            return 0;
        }
        DamagePermanentEvent event = new DamagePermanentEvent(this.objectId, attackerId, this.controllerId, damageAmount, preventable, combat);
        event.setAppliedEffects(appliedEffects);
        game.getState().addBatchDamageCouldHaveBeenFired(combat, game);
        if (game.replaceEvent(event)) {
            return 0;
        }
        int actualDamageDone = this.checkProtectionAbilities(event, attackerId, source, game);
        if (actualDamageDone < 1) {
            return 0;
        }
        int lethal = this.getLethalDamage(attackerId, game);
        MageObject attacker = game.getObject(attackerId);
        if (this.isCreature(game)) {
            if (PermanentImpl.checkWither(event, attacker, game)) {
                if (markDamage) {
                    this.markDamage(CounterType.M1M1.createInstance(actualDamageDone), attacker, true);
                } else {
                    SpellAbility damageSourceAbility = null;
                    if (attacker instanceof Permanent) {
                        damageSourceAbility = ((Permanent)attacker).getSpellAbility();
                    }
                    this.addCounters(CounterType.M1M1.createInstance(actualDamageDone), game.getControllerId(attackerId), damageSourceAbility, game);
                }
            } else {
                this.damage = CardUtil.overflowInc(this.damage, actualDamageDone);
            }
        }
        if (this.isPlaneswalker(game)) {
            int loyalty = this.getCounters(game).getCount(CounterType.LOYALTY);
            countersToRemove = Math.min(actualDamageDone, loyalty);
            if (attacker != null && markDamage) {
                this.markDamage(CounterType.LOYALTY.createInstance(countersToRemove), attacker, false);
            } else {
                this.removeCounters(CounterType.LOYALTY.getName(), countersToRemove, source, game, true);
            }
        }
        if (this.isBattle(game)) {
            int defense = this.getCounters(game).getCount(CounterType.DEFENSE);
            countersToRemove = Math.min(actualDamageDone, defense);
            if (attacker != null && markDamage) {
                this.markDamage(CounterType.DEFENSE.createInstance(countersToRemove), attacker, false);
            } else {
                this.removeCounters(CounterType.DEFENSE.getName(), countersToRemove, source, game, true);
            }
        }
        DamagedPermanentEvent damagedEvent = new DamagedPermanentEvent(this.getId(), attackerId, this.getControllerId(), actualDamageDone, combat);
        damagedEvent.setExcess(actualDamageDone - lethal);
        game.fireEvent(damagedEvent);
        game.getState().addSimultaneousDamage(damagedEvent, game);
        UUID sourceControllerId = null;
        Abilities<Ability> sourceAbilities = null;
        attacker = game.getPermanentOrLKIBattlefield(attackerId);
        if (attacker == null) {
            StackObject stackObject = game.getStack().getStackObject(attackerId);
            attacker = stackObject != null ? stackObject.getStackAbility().getSourceObject(game) : game.getObject(attackerId);
            if (attacker instanceof Spell) {
                sourceAbilities = ((Spell)attacker).getAbilities(game);
                sourceControllerId = ((Spell)attacker).getControllerId();
            } else if (attacker instanceof Card) {
                sourceAbilities = ((Card)attacker).getAbilities(game);
                sourceControllerId = ((Card)attacker).getOwnerId();
            } else if (attacker instanceof CommandObject) {
                sourceControllerId = ((CommandObject)attacker).getControllerId();
                sourceAbilities = attacker.getAbilities();
            } else {
                attacker = null;
            }
        } else {
            sourceAbilities = ((Permanent)attacker).getAbilities(game);
            sourceControllerId = ((Permanent)attacker).getControllerId();
        }
        if (attacker != null && sourceAbilities != null) {
            Player player;
            if (sourceAbilities.containsKey(LifelinkAbility.getInstance().getId())) {
                if (markDamage) {
                    game.getPermanent(attackerId).markLifelink(actualDamageDone);
                } else {
                    player = game.getPlayer(sourceControllerId);
                    player.gainLife(actualDamageDone, game, source);
                }
            }
            if (sourceAbilities.containsKey(DeathtouchAbility.getInstance().getId())) {
                this.deathtouched = true;
            }
            if (this.dealtDamageByThisTurn == null) {
                this.dealtDamageByThisTurn = new HashSet<MageObjectReference>();
            }
            if (sourceAbilities.containsKey(SquirrellinkAbility.getInstance().getId())) {
                player = game.getPlayer(sourceControllerId);
                new SquirrelToken().putOntoBattlefield(actualDamageDone, game, source, player.getId());
            }
            this.dealtDamageByThisTurn.add(new MageObjectReference(attacker, game));
        }
        if (attacker == null) {
            game.informPlayers(this.getLogName() + " gets " + actualDamageDone + " damage");
        } else {
            game.informPlayers(attacker.getLogName() + " deals " + actualDamageDone + " damage to " + this.getLogName());
        }
        return actualDamageDone;
    }

    private static boolean checkWither(DamageEvent event, MageObject attacker, Game game) {
        if (event.isAsThoughWither() || event.isAsThoughInfect()) {
            return true;
        }
        if (attacker == null) {
            return false;
        }
        Abilities<Ability> abilities = attacker instanceof Card ? ((Card)attacker).getAbilities(game) : attacker.getAbilities();
        return abilities.containsKey(InfectAbility.getInstance().getId()) || abilities.containsKey(WitherAbility.getInstance().getId());
    }

    @Override
    public void markLifelink(int damage) {
        this.markedLifelink += damage;
    }

    @Override
    public int markDamage(int damageAmount, UUID attackerId, Ability source, Game game, boolean preventable, boolean combat) {
        return this.doDamage(damageAmount, attackerId, source, game, preventable, combat, true, null);
    }

    @Override
    public int applyDamage(Game game) {
        if (this.markedLifelink > 0) {
            Player player = game.getPlayer(this.getControllerId());
            player.gainLife(this.markedLifelink, game, null);
            this.markedLifelink = 0;
        }
        if (this.markedDamage == null) {
            return 0;
        }
        for (MarkedDamageInfo mdi : this.markedDamage) {
            SpellAbility source = null;
            if (mdi.sourceObject instanceof PermanentToken) {
                PermanentToken sourceToken = (PermanentToken)mdi.sourceObject;
                source = new SpellAbility(null, sourceToken.name);
                source.setSourceId(sourceToken.objectId);
                source.setControllerId(sourceToken.controllerId);
            } else if (mdi.sourceObject instanceof Permanent) {
                source = ((Permanent)mdi.sourceObject).getSpellAbility();
            }
            if (mdi.addCounters) {
                this.addCounters(mdi.counter, game.getControllerId(mdi.sourceObject.getId()), source, game);
                continue;
            }
            this.removeCounters(mdi.counter, source, game, true);
        }
        this.markedDamage.clear();
        return 0;
    }

    @Override
    public int getLethalDamage(UUID attackerId, Game game) {
        int lethal = Integer.MAX_VALUE;
        if (this.isCreature(game)) {
            lethal = game.getState().getActivePowerInsteadOfToughnessForDamageLethalityFilters().stream().anyMatch(f -> f.match(this, game)) ? this.power.getValue() : this.toughness.getValue();
            lethal = Math.max(lethal - this.damage, 0);
            Card attacker = game.getPermanent(attackerId);
            if (attacker == null) {
                attacker = game.getCard(attackerId);
            }
            if (attacker != null && attacker.getAbilities(game).containsKey(DeathtouchAbility.getInstance().getId())) {
                lethal = Math.min(1, lethal);
            }
        }
        if (this.isPlaneswalker(game)) {
            lethal = Math.min(lethal, this.getCounters(game).getCount(CounterType.LOYALTY));
        }
        if (this.isBattle(game)) {
            lethal = Math.min(lethal, this.getCounters(game).getCount(CounterType.DEFENSE));
        }
        return lethal;
    }

    @Override
    public void removeAllDamage(Game game) {
        this.damage = 0;
        this.deathtouched = false;
    }

    private int checkProtectionAbilities(GameEvent event, UUID attackerId, Ability source, Game game) {
        PreventDamageEvent preventEvent;
        MageObject attacker = game.getObject(attackerId);
        if (attacker != null && this.hasProtectionFrom(attacker, game) && !game.replaceEvent(preventEvent = new PreventDamageEvent(this.getId(), attackerId, source, this.getControllerId(), event.getAmount(), ((DamageEvent)event).isCombatDamage()))) {
            int preventedDamage = event.getAmount();
            event.setAmount(0);
            game.fireEvent(new PreventedDamageEvent(this.getId(), attackerId, source, this.getControllerId(), preventedDamage));
            return 0;
        }
        return event.getAmount();
    }

    private void markDamage(Counter counter, MageObject source, boolean addCounters) {
        if (this.markedDamage == null) {
            this.markedDamage = new ArrayList<MarkedDamageInfo>();
        }
        this.markedDamage.add(new MarkedDamageInfo(counter, source, addCounters));
    }

    @Override
    public boolean entersBattlefield(Ability source, Game game, Zone fromZone, boolean fireEvent) {
        this.controlledFromStartOfControllerTurn = false;
        BecomesFaceDownCreatureEffect.FaceDownType faceDownType = BecomesFaceDownCreatureEffect.findFaceDownType(game, this);
        if (faceDownType != null) {
            BecomesFaceDownCreatureEffect.makeFaceDownObject(game, null, this, faceDownType, null);
        }
        if (game.replaceEvent(new EntersTheBattlefieldEvent(this, source, this.getControllerId(), fromZone, EnterEventType.SELF))) {
            return false;
        }
        EntersTheBattlefieldEvent event = new EntersTheBattlefieldEvent(this, source, this.getControllerId(), fromZone);
        if (game.replaceEvent(event)) {
            return false;
        }
        if (this.isPlaneswalker(game)) {
            int loyalty = this.getStartingLoyalty() == -2 ? CardUtil.getSourceCostsTag(game, source, "X", 0).intValue() : this.getStartingLoyalty();
            int countersToAdd = this.hasAbility(CompleatedAbility.getInstance(), game) ? loyalty - 2 * source.getManaCostsToPay().getPhyrexianPaid() : loyalty;
            if (countersToAdd > 0) {
                this.addCounters(CounterType.LOYALTY.createInstance(countersToAdd), source, game);
            }
        }
        if (this.isBattle(game)) {
            int defense = this.getStartingDefense() == -2 ? CardUtil.getSourceCostsTag(game, source, "X", 0).intValue() : this.getStartingDefense();
            if (defense > 0) {
                this.addCounters(CounterType.DEFENSE.createInstance(defense), source, game);
            }
            this.chooseProtector(game, source);
        }
        if (!fireEvent) {
            return false;
        }
        game.addSimultaneousEvent(event);
        return true;
    }

    @Override
    public boolean canBeTargetedBy(MageObject sourceObject, UUID sourceControllerId, Ability source, Game game) {
        if (sourceObject != null) {
            if (this.abilities.containsKey(ShroudAbility.getInstance().getId()) && game.getContinuousEffects().asThough(this.getId(), AsThoughEffectType.SHROUD, null, sourceControllerId, game).isEmpty()) {
                return false;
            }
            if (game.getPlayer(this.getControllerId()).hasOpponent(sourceControllerId, game) && game.getContinuousEffects().asThough(this.getId(), AsThoughEffectType.HEXPROOF, null, sourceControllerId, game).isEmpty()) {
                if (this.abilities.stream().filter(HexproofBaseAbility.class::isInstance).map(HexproofBaseAbility.class::cast).anyMatch(ability -> ability.checkObject(sourceObject, source, game))) {
                    return false;
                }
            }
            if (this.hasProtectionFrom(sourceObject, game)) {
                return false;
            }
            return !game.getContinuousEffects().preventedByRuleModification(new TargetEvent(this, sourceObject.getId(), sourceControllerId), null, game, true);
        }
        return true;
    }

    @Override
    public boolean hasProtectionFrom(MageObject source, Game game) {
        for (ProtectionAbility ability : this.getAbilities(game).getProtectionAbilities()) {
            if (ability.canTarget(source, game)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean destroy(Ability source, Game game) {
        return this.destroy(source, game, false);
    }

    @Override
    public boolean destroy(Ability source, Game game, boolean noRegen) {
        if (!game.getState().getZone(this.getId()).equals((Object)Zone.BATTLEFIELD)) {
            return false;
        }
        if (this.abilities.containsKey(IndestructibleAbility.getInstance().getId())) {
            return false;
        }
        if (!game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.DESTROY_PERMANENT, this.objectId, source, this.controllerId, noRegen ? 1 : 0))) {
            if (this.moveToZone(Zone.GRAVEYARD, source, game, false)) {
                Card card = game.getCard(this.getId());
                String logName = card != null ? card.getLogName() : this.getLogName();
                if (this.isCreature(game)) {
                    game.informPlayers(logName + " died" + CardUtil.getSourceLogName(game, " by ", source, "", ""));
                } else {
                    game.informPlayers(logName + " was destroyed" + CardUtil.getSourceLogName(game, " by ", source, "", ""));
                }
                game.fireEvent(GameEvent.getEvent(GameEvent.EventType.DESTROYED_PERMANENT, this.objectId, source, this.controllerId));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean sacrifice(Ability source, Game game) {
        if (this.isPhasedIn() && this.canBeSacrificed && !game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.SACRIFICE_PERMANENT, this.objectId, source, this.controllerId))) {
            this.moveToZone(Zone.GRAVEYARD, source, game, false);
            Player player = game.getPlayer(this.getControllerId());
            if (player != null) {
                game.informPlayers(player.getLogName() + " sacrificed " + this.getLogName() + CardUtil.getSourceLogName(game, source));
            }
            SacrificedPermanentEvent sacrificedPermanentEvent = new SacrificedPermanentEvent(this.objectId, source, this.controllerId);
            game.fireEvent(sacrificedPermanentEvent);
            game.getState().addSimultaneousSacrificedPermanentToBatch(sacrificedPermanentEvent, game);
            return true;
        }
        return false;
    }

    @Override
    public boolean regenerate(Ability source, Game game) {
        if (!game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.REGENERATE, this.objectId, source, this.controllerId))) {
            this.tap(source, game);
            this.removeFromCombat(game);
            this.removeAllDamage(game);
            RegenerateSourceEffect.decRegenerationShieldsAmount(game, this.getId());
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.REGENERATED, this.objectId, source, this.controllerId));
            return true;
        }
        return false;
    }

    @Override
    public void addPower(int power) {
        this.power.increaseBoostedValue(power);
    }

    @Override
    public void addToughness(int toughness) {
        this.toughness.increaseBoostedValue(toughness);
    }

    protected void fireEvent(GameEvent.EventType eventType, Game game) {
        game.fireEvent(GameEvent.getEvent(eventType, this.objectId, null, this.controllerId));
    }

    protected boolean replaceEvent(GameEvent.EventType eventType, Game game) {
        return game.replaceEvent(GameEvent.getEvent(eventType, this.objectId, null, this.controllerId));
    }

    @Override
    public boolean canAttack(UUID defenderId, Game game) {
        if (this.tapped) {
            return false;
        }
        return this.canAttackInPrinciple(defenderId, game);
    }

    @Override
    public boolean canBeAttacked(UUID attackerId, UUID defendingPlayerId, Game game) {
        if (this.isPlaneswalker(game)) {
            return this.isControlledBy(defendingPlayerId);
        }
        if (this.isBattle(game)) {
            return this.isProtectedBy(defendingPlayerId);
        }
        return false;
    }

    @Override
    public boolean canAttackInPrinciple(UUID defenderId, Game game) {
        if (this.isBattle(game)) {
            return false;
        }
        Set<ApprovingObject> approvingObjects = game.getContinuousEffects().asThough(this.objectId, AsThoughEffectType.ATTACK_AS_HASTE, null, defenderId, game);
        if (this.hasSummoningSickness() && approvingObjects.isEmpty()) {
            return false;
        }
        if (defenderId == null ? game.getCombat().getDefenders().stream().noneMatch(defenderToCheckId -> this.canAttackCheckRestrictionEffects((UUID)defenderToCheckId, game)) : !this.canAttackCheckRestrictionEffects(defenderId, game)) {
            return false;
        }
        return !this.abilities.containsKey(DefenderAbility.getInstance().getId()) || !game.getContinuousEffects().asThough(this.objectId, AsThoughEffectType.ATTACK, null, this.getControllerId(), game).isEmpty();
    }

    private boolean canAttackCheckRestrictionEffects(UUID defenderId, Game game) {
        for (Map.Entry<RestrictionEffect, Set<Ability>> effectEntry : game.getContinuousEffects().getApplicableRestrictionEffects(this, game).entrySet()) {
            if (!effectEntry.getKey().canAttack(game, true)) {
                return false;
            }
            for (Ability ability : effectEntry.getValue()) {
                if (effectEntry.getKey().canAttack(this, defenderId, ability, game, true)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canBlock(UUID attackerId, Game game) {
        if (this.tapped && game.getState().getContinuousEffects().asThough(this.getId(), AsThoughEffectType.BLOCK_TAPPED, null, this.getControllerId(), game).isEmpty() || this.isBattle(game) || !this.isCreature(game) || this.isSuspected()) {
            return false;
        }
        Permanent attacker = game.getPermanent(attackerId);
        if (attacker == null) {
            return false;
        }
        if (!game.getPlayer(this.getControllerId()).hasOpponent(attacker.getControllerId(), game)) {
            return false;
        }
        for (Map.Entry<RestrictionEffect, Set<Ability>> entry : game.getContinuousEffects().getApplicableRestrictionEffects(this, game).entrySet()) {
            for (Ability ability : entry.getValue()) {
                if (entry.getKey().canBlock(attacker, this, ability, game, true)) continue;
                return false;
            }
        }
        for (Map.Entry<RestrictionEffect, Set<Ability>> restrictionEntry : game.getContinuousEffects().getApplicableRestrictionEffects(attacker, game).entrySet()) {
            for (Ability ability : restrictionEntry.getValue()) {
                if (restrictionEntry.getKey().canBeBlocked(attacker, this, ability, game, true)) continue;
                return false;
            }
        }
        return !attacker.hasProtectionFrom(this, game);
    }

    @Override
    public boolean canBlockAny(Game game) {
        if (this.tapped && game.getState().getContinuousEffects().asThough(this.getId(), AsThoughEffectType.BLOCK_TAPPED, null, this.getControllerId(), game).isEmpty()) {
            return false;
        }
        for (Map.Entry<RestrictionEffect, Set<Ability>> entry : game.getContinuousEffects().getApplicableRestrictionEffects(this, game).entrySet()) {
            RestrictionEffect effect = entry.getKey();
            for (Ability ability : entry.getValue()) {
                if (effect.canBlock(null, this, ability, game, true)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canUseActivatedAbilities(Game game) {
        for (Map.Entry<RestrictionEffect, Set<Ability>> entry : game.getContinuousEffects().getApplicableRestrictionEffects(this, game).entrySet()) {
            RestrictionEffect effect = entry.getKey();
            for (Ability ability : entry.getValue()) {
                if (effect.canUseActivatedAbilities(this, ability, game, true)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setAttacking(boolean attacking) {
        this.attacking = attacking;
    }

    @Override
    public void setBlocking(int blocking) {
        this.blocking = blocking;
    }

    @Override
    public void setMaxBlocks(int maxBlocks) {
        this.maxBlocks = maxBlocks;
    }

    @Override
    public void setMinBlockedBy(int minBlockedBy) {
        this.minBlockedBy = minBlockedBy;
    }

    @Override
    public void setMaxBlockedBy(int maxBlockedBy) {
        this.maxBlockedBy = maxBlockedBy;
    }

    @Override
    public boolean removeFromCombat(Game game) {
        return this.removeFromCombat(game, true);
    }

    @Override
    public boolean removeFromCombat(Game game, boolean withEvent) {
        if (this.isAttacking() || this.blocking > 0) {
            return game.getCombat().removeFromCombat(this.objectId, game, withEvent);
        }
        if (this.isPlaneswalker(game) && game.getCombat().getDefenders().contains(this.getId())) {
            game.getCombat().removeDefendingPermanentFromCombat(this.objectId, game);
        }
        return false;
    }

    @Override
    public boolean imprint(UUID imprintedCard, Game game) {
        if (!game.getExile().containsId(imprintedCard, game)) {
            return false;
        }
        if (this.connectedCards.containsKey("imprint")) {
            if (!this.connectedCards.get("imprint").contains(imprintedCard)) {
                this.connectedCards.get("imprint").add(imprintedCard);
            }
        } else {
            ArrayList<UUID> imprinted = new ArrayList<UUID>();
            imprinted.add(imprintedCard);
            this.connectedCards.put("imprint", imprinted);
        }
        return true;
    }

    @Override
    public boolean clearImprinted(Game game) {
        this.connectedCards.put("imprint", new ArrayList());
        return true;
    }

    @Override
    public List<UUID> getImprinted() {
        return this.connectedCards.getOrDefault("imprint", emptyList);
    }

    @Override
    public Set<MageObjectReference> getDealtDamageByThisTurn() {
        if (this.dealtDamageByThisTurn == null) {
            return new HashSet<MageObjectReference>();
        }
        return this.dealtDamageByThisTurn;
    }

    @Override
    public boolean isTransformed() {
        return this.transformed;
    }

    @Override
    public void setTransformed(boolean value) {
        this.transformed = value;
    }

    @Override
    public boolean isMonstrous() {
        return this.monstrous;
    }

    @Override
    public boolean isPrototyped() {
        return this.prototyped;
    }

    @Override
    public void setMonstrous(boolean value) {
        this.monstrous = value;
    }

    @Override
    public boolean isRenowned() {
        return this.renowned;
    }

    @Override
    public void setRenowned(boolean value) {
        this.renowned = value;
    }

    @Override
    public boolean isSuspected() {
        return this.suspected;
    }

    @Override
    public void setSuspected(boolean value, Game game, Ability source) {
        if (!value || !game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.BECOME_SUSPECTED, this.getId(), source, source.getControllerId()))) {
            this.suspected = value;
        }
        if (this.suspected) {
            this.addInfo(suspectedInfoKey, CardUtil.addToolTipMarkTags("Suspected (has menace and can't block)"), game);
        } else {
            this.addInfo(suspectedInfoKey, null, game);
        }
    }

    @Override
    public void setRingBearer(Game game, boolean value) {
        if (value == this.ringBearerFlag) {
            return;
        }
        if (value) {
            Player player = game.getPlayer(this.getControllerId());
            String playername = "";
            if (player != null) {
                playername = player.getLogName();
                Permanent existingRingbearer = player.getRingBearer(game);
                if (existingRingbearer != null && existingRingbearer.getId() != this.getId()) {
                    existingRingbearer.setRingBearer(game, false);
                }
            }
            this.addInfo(ringbearerInfoKey, CardUtil.addToolTipMarkTags("Is " + playername + "'s Ring-bearer"), game);
        } else {
            this.addInfo(ringbearerInfoKey, null, game);
        }
        this.ringBearerFlag = value;
    }

    @Override
    public int getClassLevel() {
        return this.classLevel;
    }

    @Override
    public boolean setClassLevel(int classLevel) {
        if (this.classLevel == classLevel - 1) {
            this.classLevel = classLevel;
            return true;
        }
        return false;
    }

    @Override
    public void addGoadingPlayer(UUID playerId) {
        this.goadingPlayers.add(playerId);
    }

    @Override
    public Set<UUID> getGoadingPlayers() {
        return this.goadingPlayers;
    }

    @Override
    public void chooseProtector(Game game, Ability source) {
        Player newProtector;
        Set<UUID> opponents = game.getOpponents(this.getControllerId());
        Player controller = game.getPlayer(this.getControllerId());
        if (controller == null) {
            return;
        }
        if (opponents.size() > 1) {
            TargetPlayer target = new TargetPlayer(new FilterOpponent("protector for " + this.getName()));
            target.withNotTarget(true);
            target.setRequired(true);
            controller.choose(Outcome.Neutral, target, source, game);
            newProtector = game.getPlayer(target.getFirstTarget());
        } else {
            newProtector = opponents.size() == 1 ? game.getPlayer(opponents.iterator().next()) : null;
        }
        if (newProtector != null) {
            String protectorName = newProtector.getLogName();
            game.informPlayers(protectorName + " has been chosen to protect " + this.getLogName());
            this.addInfo("protector", "Protected by " + protectorName, game);
            this.setProtectorId(newProtector.getId());
        } else {
            game.informPlayers(controller.getLogName() + " remains in protect of " + this.getLogName() + " as there are no opponents for new protector");
        }
    }

    @Override
    public void setProtectorId(UUID protectorId) {
        this.protectorId = protectorId;
    }

    @Override
    public UUID getProtectorId() {
        return this.protectorId;
    }

    @Override
    public boolean isProtectedBy(UUID playerId) {
        return this.protectorId != null && this.protectorId.equals(playerId);
    }

    @Override
    public void setCanBeSacrificed(boolean canBeSacrificed) {
        this.canBeSacrificed = canBeSacrificed;
    }

    @Override
    public boolean canBeSacrificed() {
        return this.canBeSacrificed;
    }

    @Override
    public void setPairedCard(MageObjectReference pairedCard) {
        this.pairedPermanent = pairedCard;
        if (pairedCard == null) {
            this.addInfo("soulbond", null, null);
        }
    }

    @Override
    public MageObjectReference getPairedCard() {
        return this.pairedPermanent;
    }

    @Override
    public void clearPairedCard() {
        this.pairedPermanent = null;
    }

    @Override
    public void addBandedCard(UUID bandedCard) {
        if (!this.bandedCards.contains(bandedCard)) {
            this.bandedCards.add(bandedCard);
        }
    }

    @Override
    public void removeBandedCard(UUID bandedCard) {
        this.bandedCards.remove(bandedCard);
    }

    @Override
    public List<UUID> getBandedCards() {
        return this.bandedCards;
    }

    @Override
    public void clearBandedCards() {
        this.bandedCards.clear();
    }

    @Override
    public String getLogName() {
        if (this.name.isEmpty()) {
            if (this.faceDown) {
                return GameLog.getNeutralColoredText("face down creature");
            }
            return GameLog.getNeutralColoredText("a creature without name");
        }
        return GameLog.getColoredObjectIdName(this);
    }

    @Override
    public boolean isManifested() {
        return this.manifested;
    }

    @Override
    public void setManifested(boolean value) {
        this.manifested = value;
    }

    @Override
    public boolean isCloaked() {
        return this.cloaked;
    }

    @Override
    public void setCloaked(boolean value) {
        this.cloaked = value;
    }

    @Override
    public boolean isMorphed() {
        return this.morphed;
    }

    @Override
    public void setMorphed(boolean value) {
        this.morphed = value;
    }

    @Override
    public boolean isDisguised() {
        return this.disguised;
    }

    @Override
    public void setDisguised(boolean value) {
        this.disguised = value;
    }

    @Override
    public void setRarity(Rarity rarity) {
        this.rarity = rarity;
    }

    @Override
    public void setFlipCard(boolean flipCard) {
        this.flipCard = flipCard;
    }

    @Override
    public void setFlipCardName(String flipCardName) {
        this.flipCardName = flipCardName;
    }

    @Override
    public void setSecondCardFace(Card card) {
        this.secondSideCard = card;
    }

    @Override
    public void setPrototyped(boolean prototyped) {
        this.prototyped = prototyped;
    }

    @Override
    public boolean isRingBearer() {
        return this.ringBearerFlag;
    }

    @Override
    public boolean isSolved() {
        return this.solved;
    }

    @Override
    public boolean solve(Game game, Ability source) {
        if (this.solved) {
            return false;
        }
        GameEvent event = new GameEvent(GameEvent.EventType.SOLVE_CASE, this.getId(), source, source.getControllerId());
        if (game.replaceEvent(event)) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            game.informPlayers(controller.getLogName() + " solved " + this.getLogName() + CardUtil.getSourceLogName(game, source));
        }
        this.solved = true;
        game.fireEvent(new GameEvent(GameEvent.EventType.CASE_SOLVED, this.getId(), source, source.getControllerId()));
        return true;
    }

    @Override
    public boolean isHarnessed() {
        return this.harnessed;
    }

    @Override
    public void setHarnessed(boolean value) {
        this.harnessed = value;
    }

    @Override
    public boolean fight(Permanent fightTarget, Ability source, Game game) {
        return this.fight(fightTarget, source, game, true);
    }

    @Override
    public boolean fight(Permanent fightTarget, Ability source, Game game, boolean batchTrigger) {
        game.fireEvent(GameEvent.getEvent(GameEvent.EventType.FIGHTED_PERMANENT, fightTarget.getId(), source, source.getControllerId()));
        game.fireEvent(GameEvent.getEvent(GameEvent.EventType.FIGHTED_PERMANENT, this.getId(), source, source.getControllerId()));
        this.damage(fightTarget.getPower().getValue(), fightTarget.getId(), source, game);
        fightTarget.damage(this.getPower().getValue(), this.getId(), source, game);
        if (batchTrigger) {
            HashSet<MageObjectReference> morSet = new HashSet<MageObjectReference>();
            morSet.add(new MageObjectReference(this, game));
            morSet.add(new MageObjectReference(fightTarget, game));
            String data = UUID.randomUUID().toString();
            game.getState().setValue("batchFight_" + data, morSet);
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.BATCH_FIGHT, this.getId(), source, source.getControllerId(), data, 0));
        }
        return true;
    }

    @Override
    public int getCreateOrder() {
        return this.createOrder;
    }

    @Override
    public void setCreateOrder(int createOrder) {
        this.createOrder = createOrder;
    }

    @Override
    public ObjectColor getColor() {
        return this.color;
    }

    @Override
    public ObjectColor getColor(Game game) {
        return this.color;
    }

    @Override
    public boolean moveToZone(Zone toZone, Ability source, Game game, boolean flag, List<UUID> appliedEffects) {
        Zone fromZone = game.getState().getZone(this.objectId);
        Player controller = game.getPlayer(this.controllerId);
        if (controller != null) {
            ZoneChangeEvent event = new ZoneChangeEvent(this, source, this.controllerId, fromZone, toZone, appliedEffects);
            ZoneChangeInfo zoneChangeInfo = toZone == Zone.LIBRARY ? new ZoneChangeInfo.Library(event, flag) : new ZoneChangeInfo(event);
            return ZonesHandler.moveCard(zoneChangeInfo, game, source);
        }
        return false;
    }

    @Override
    public boolean moveToExile(UUID exileId, String name, Ability source, Game game, List<UUID> appliedEffects) {
        Zone fromZone = game.getState().getZone(this.objectId);
        ZoneChangeEvent event = new ZoneChangeEvent(this, source, this.ownerId, fromZone, Zone.EXILED, appliedEffects);
        ZoneChangeInfo.Exile zcInfo = new ZoneChangeInfo.Exile(event, exileId, name);
        return ZonesHandler.moveCard(zcInfo, game, source);
    }

    private static class MarkedDamageInfo
    implements Serializable {
        private final Counter counter;
        private final MageObject sourceObject;
        private final boolean addCounters;

        private MarkedDamageInfo(Counter counter, MageObject sourceObject, boolean addCounters) {
            this.counter = counter;
            this.sourceObject = sourceObject;
            this.addCounters = addCounters;
        }
    }
}

