/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent.token;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubTypeSet;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AlienAngelTokenEffect
extends ContinuousEffectImpl {
    AlienAngelTokenEffect() {
        super(Duration.EndOfTurn, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.UnboostCreature);
        this.staticText = "this token isn't a creature until end of turn";
    }

    private AlienAngelTokenEffect(AlienAngelTokenEffect effect) {
        super(effect);
    }

    @Override
    public AlienAngelTokenEffect copy() {
        return new AlienAngelTokenEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            this.discard();
            return false;
        }
        permanent.removeAllSubTypes(game, SubTypeSet.CreatureType);
        permanent.removeCardType(game, CardType.CREATURE);
        return true;
    }
}

