/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent.token;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeControllerEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.players.Player;

class BelzenlokDemonTokenEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("another creature");

    BelzenlokDemonTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice another creature. If you can't, this creature deals 6 damage to you.";
    }

    BelzenlokDemonTokenEffect(BelzenlokDemonTokenEffect effect) {
        super(effect);
    }

    @Override
    public BelzenlokDemonTokenEffect copy() {
        return new BelzenlokDemonTokenEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int otherCreatures = new PermanentsOnBattlefieldCount(filter).calculate(game, source, this);
        if (otherCreatures > 0) {
            new SacrificeControllerEffect((FilterPermanent)filter, 1, "").apply(game, source);
        } else {
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null) {
                controller.damage(6, source.getSourceId(), source, game);
            }
        }
        return true;
    }

    static {
        filter.add(CardType.CREATURE.getPredicate());
        filter.add(AnotherPredicate.instance);
    }
}

