/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent.token;

import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.CardType;
import mage.filter.common.FilterAttackingCreature;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.permanent.token.TokenImpl;
import mage.target.TargetPermanent;

public final class LandMineToken
extends TokenImpl {
    private static final FilterAttackingCreature filter = new FilterAttackingCreature("attacking creature without flying");

    public LandMineToken() {
        super("Land Mine", "colorless artifact token named Land Mine with \"{R}, Sacrifice this artifact: This artifact deals 2 damage to target attacking creature without flying.\"");
        this.cardType.add(CardType.ARTIFACT);
        SimpleActivatedAbility ability = new SimpleActivatedAbility(new DamageTargetEffect(2), new ManaCostsImpl("{R}"));
        ability.addCost(new SacrificeSourceCost());
        ability.addTarget(new TargetPermanent(filter));
        this.addAbility(ability);
    }

    private LandMineToken(LandMineToken token) {
        super(token);
    }

    @Override
    public LandMineToken copy() {
        return new LandMineToken(this);
    }

    static {
        filter.add(Predicates.not(new AbilityPredicate(FlyingAbility.class)));
    }
}

