/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent.token;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInExile;

class ReturnSengirNosferatuEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("exiled card named Sengir Nosferatu");

    ReturnSengirNosferatuEffect() {
        super(Outcome.Benefit);
    }

    private ReturnSengirNosferatuEffect(ReturnSengirNosferatuEffect effect) {
        super(effect);
    }

    @Override
    public ReturnSengirNosferatuEffect copy() {
        return new ReturnSengirNosferatuEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInExile target = new TargetCardInExile(filter);
        target.withNotTarget(true);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        player.chooseTarget(Outcome.PutCreatureInPlay, target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, true, null);
    }

    static {
        filter.add(new NamePredicate("Sengir Nosferatu"));
    }
}

