/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent.token;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class SmokeBlessingTokenEffect
extends OneShotEffect {
    SmokeBlessingTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "it deals 1 damage to its controller and you create a Treasure token";
    }

    private SmokeBlessingTokenEffect(SmokeBlessingTokenEffect effect) {
        super(effect);
    }

    @Override
    public SmokeBlessingTokenEffect copy() {
        return new SmokeBlessingTokenEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player;
        Permanent permanent = (Permanent)this.getValue("attachedTo");
        if (permanent != null && (player = game.getPlayer(permanent.getControllerId())) != null) {
            player.damage(1, permanent.getId(), source, game);
        }
        new TreasureToken().putOntoBattlefield(1, game, source);
        return true;
    }
}

