/*
 * Decompiled with CFR 0.152.
 */
package mage.game.tournament;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import mage.game.match.MatchOptions;
import mage.game.tournament.LimitedOptions;
import mage.players.PlayerType;

public class TournamentOptions
implements Serializable {
    protected String name;
    protected String tournamentType;
    protected List<PlayerType> playerTypes = new ArrayList<PlayerType>();
    protected MatchOptions matchOptions;
    protected LimitedOptions limitedOptions;
    protected boolean watchingAllowed = true;
    protected boolean planeChase = false;
    protected int numberRounds;
    protected String password;
    protected int quitRatio;
    protected int minimumRating;

    public TournamentOptions(String name, String matchType, boolean isSingleMultiplayerGame) {
        this.name = name;
        this.matchOptions = new MatchOptions("", matchType, isSingleMultiplayerGame);
    }

    public String getName() {
        return this.name;
    }

    public String getTournamentType() {
        return this.tournamentType;
    }

    public void setTournamentType(String tournamentType) {
        this.tournamentType = tournamentType;
    }

    public List<PlayerType> getPlayerTypes() {
        return this.playerTypes;
    }

    public MatchOptions getMatchOptions() {
        return this.matchOptions;
    }

    public void setLimitedOptions(LimitedOptions limitedOptions) {
        this.limitedOptions = limitedOptions;
    }

    public LimitedOptions getLimitedOptions() {
        return this.limitedOptions;
    }

    public boolean isWatchingAllowed() {
        return this.watchingAllowed;
    }

    public void setWatchingAllowed(boolean watchingAllowed) {
        this.watchingAllowed = watchingAllowed;
    }

    public boolean isPlaneChase() {
        return this.planeChase;
    }

    public void setPlaneChase(boolean planeChase) {
        this.planeChase = planeChase;
        this.matchOptions.setPlaneChase(planeChase);
    }

    public int getNumberRounds() {
        return this.numberRounds;
    }

    public void setNumberRounds(int numberRounds) {
        this.numberRounds = numberRounds;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getQuitRatio() {
        return this.quitRatio;
    }

    public void setQuitRatio(int quitRatio) {
        this.quitRatio = quitRatio;
    }

    public int getMinimumRating() {
        return this.minimumRating;
    }

    public void setMinimumRating(int minimumRating) {
        this.minimumRating = minimumRating;
    }
}

